/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.demo.linker.search.wordextraction;

import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.supa.demo.linker.search.wordextraction.ExtractCodeQueryElementsFromCas;
import com.ibm.supa.linker.search.querys.elements.IdentifierQueryElement;
import com.ibm.supa.linker.search.querys.elements.QueryElement;
import com.ibm.supa.linker.search.querys.elements.SubWordQueryElement;
import com.ibm.uima.UIMAFramework;
import com.ibm.uima.analysis_engine.AnalysisEngineProcessException;
import com.ibm.uima.analysis_engine.TaeDescription;
import com.ibm.uima.analysis_engine.TextAnalysisEngine;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceManager;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.util.InvalidXMLException;
import com.ibm.uima.util.XMLInputSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeSyntaxScanner {
    private TextAnalysisEngine mTae;
    private TCAS mTcas;
    private String mArtifact;

    public CodeSyntaxScanner(String artifact) {
        this.initCodeSyntaxTeaAndCreateNewCas();
        this.mArtifact = artifact;
    }

    private void initCodeSyntaxTeaAndCreateNewCas() {
        try {
            String installPath = GlobalConfiguration.getConfiguration().getInstallPath();
            File codeSyntaxTaeDescriptorFile = new File(installPath, "lib" + File.separator + "linker" + File.separator + "desc" + File.separator + "annotator" + File.separator + "CodeAggregatedAnnotatorDescriptor.xml");
            XMLInputSource in = new XMLInputSource(codeSyntaxTaeDescriptorFile);
            TaeDescription taeDesc = UIMAFramework.getXMLParser().parseTaeDescription(in);
            ResourceManager rsrcMgr = UIMAFramework.newDefaultResourceManager();
            rsrcMgr.setExtensionClassPath(this.getClass().getClassLoader(), "", true);
            this.mTae = UIMAFramework.produceTAE((ResourceSpecifier)taeDesc, (ResourceManager)rsrcMgr, (Map)UIMAFramework.getDefaultPerformanceTuningProperties());
            this.mTcas = this.mTae.newTCAS();
        }
        catch (IOException xmlEx) {
            xmlEx.printStackTrace();
        }
        catch (InvalidXMLException ioEx) {
            ioEx.printStackTrace();
        }
        catch (ResourceInitializationException resEx) {
            resEx.printStackTrace();
        }
    }

    public static String pathToDocContent(String DocPath) {
        try {
            FileInputStream fis = new FileInputStream(DocPath);
            int x = fis.available();
            byte[] codeB = new byte[x];
            fis.read(codeB);
            return new String(codeB);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public LinkedList<QueryElement> analyzeCode(String codeText, String collectionId, HashMap<ExtractCodeQueryElementsFromCas.QueriesTypes, Boolean> queriesConstraints, Class<?> cls) {
        this.mTcas.reset();
        this.initCasInputDocInfo();
        this.mTcas.setDocumentText(codeText);
        try {
            this.mTae.process((CAS)this.mTcas);
        }
        catch (AnalysisEngineProcessException e) {
            e.printStackTrace();
        }
        return this.getQueries(collectionId, queriesConstraints, cls);
    }

    private LinkedList<QueryElement> getQueries(String collectionId, HashMap<ExtractCodeQueryElementsFromCas.QueriesTypes, Boolean> queriesConstraints, Class<?> cls) {
        try {
            ExtractCodeQueryElementsFromCas cToQ = (ExtractCodeQueryElementsFromCas)cls.newInstance();
            cToQ.init(this.mTcas, collectionId);
            LinkedList<QueryElement> queries = cToQ.getQueries(queriesConstraints);
            cToQ.releaseResources();
            return queries;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void initCasInputDocInfo() {
        TypeSystem ts = this.mTcas.getTypeSystem();
        Type tInputDocInfo = ts.getType("com.ibm.supa.type.InputDocInfo");
        Feature fFileType = tInputDocInfo.getFeatureByBaseName("fileType");
        FeatureStructure fs = this.mTcas.createFS(tInputDocInfo);
        fs.setFeatureValueFromString(fFileType, this.mArtifact);
        this.mTcas.getIndexRepository().addFS(fs);
    }

    public static void printQueries(LinkedList<QueryElement> results) {
        for (QueryElement result : results) {
            String cName = result.getClass().getSimpleName();
            if (SubWordQueryElement.class == result.getClass()) {
                SubWordQueryElement convResSubW = (SubWordQueryElement)result;
                IdentifierQueryElement convRes = (IdentifierQueryElement)convResSubW.subElement();
                System.out.println(String.valueOf(cName) + "->" + convRes.getClass().getSimpleName() + " (" + convRes.identifier() + ")");
                continue;
            }
            IdentifierQueryElement convRes = (IdentifierQueryElement)result;
            System.out.println(String.valueOf(cName) + " (" + convRes.identifier() + ")");
        }
    }

    public void finalize() throws Throwable {
        this.mTae.destroy();
    }
}

