/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.security.blueGroups;

import com.ibm.supa.security.AuthObjectLookup;
import com.ibm.supa.security.Permission;
import com.ibm.supa.security.UnifiedPermissionsModule;
import com.ibm.supa.security.UsernamePasswordCredential;
import com.ibm.supa.security.blueGroups.AuthObjectLookupImpl;
import com.ibm.supa.security.blueGroups.PermissionGroups;
import com.ibm.swat.password.cwa2;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PermissionsModuleImpl
extends UnifiedPermissionsModule {
    private final UsernamePasswordCredential credential;
    private final cwa2 bgAccess;
    private final int depth;

    PermissionsModuleImpl(UsernamePasswordCredential credential, cwa2 bgAccess, int depth) {
        this.credential = credential;
        this.bgAccess = bgAccess;
        this.depth = depth;
    }

    public boolean authenticate() {
        return this.bgAccess.authenticate(this.credential.getUsername(), this.credential.getPassword()).getCode() == 0;
    }

    protected <P extends Permission> Set<P> loadPermissions(AuthObjectLookup<?, P> authObjectLookup, P ... permissions) throws ClassCastException {
        if (authObjectLookup == null || !this.authenticate()) {
            return Collections.emptySet();
        }
        HashSet<P> result = new HashSet<P>();
        AuthObjectLookupImpl lookup = (AuthObjectLookupImpl)authObjectLookup;
        P[] PArray = permissions;
        int n = 0;
        int n2 = PArray.length;
        while (n < n2) {
            P p = PArray[n];
            Object permissionGroups = lookup.getAuthObject((Permission)p);
            if (permissionGroups != null && !this.inAGroup(((PermissionGroups)permissionGroups).getDenyGroup()) && this.inAGroup(((PermissionGroups)permissionGroups).getAllowGroup())) {
                result.add(p);
            }
            ++n;
        }
        return result;
    }

    private boolean inAGroup(String group) {
        if (group == null) {
            return false;
        }
        return this.bgAccess.inAGroup(this.credential.getUsername(), group, this.depth).getCode() == 0;
    }
}

