/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.supa.security.blueGroups;

import com.ibm.supa.security.AuthObjectLookup;
import com.ibm.supa.security.Permission;
import com.ibm.supa.security.blueGroups.PermissionGroups;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthObjectLookupImpl<P extends Permission>
implements AuthObjectLookup<PermissionGroups, P> {
    private int timeoutInSeconds = 3600;
    private Map<String, String> allowGroupLookup;
    private Map<String, String> denyGroupLookup;

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public void setAllowGroupLookup(Map<String, String> groupLookup) {
        this.allowGroupLookup = groupLookup;
    }

    public void setDenyGroupLookup(Map<String, String> denyGroupLookup) {
        this.denyGroupLookup = denyGroupLookup;
    }

    public PermissionGroups getAuthObject(P permission) {
        String name = permission.name();
        return new PermissionGroups(this.getValue(this.allowGroupLookup, name), this.getValue(this.denyGroupLookup, name));
    }

    private String getValue(Map<String, String> map, String name) {
        return map == null ? null : map.get(name);
    }

    public long getTimeout() {
        return (long)this.timeoutInSeconds * 1000L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UserAuthObjectLookupImpl
    extends AuthObjectLookupImpl<Permission.User>
    implements AuthObjectLookup.UserAuthObjectLookup<PermissionGroups> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AdminAuthObjectLookupImpl
    extends AuthObjectLookupImpl<Permission.Admin>
    implements AuthObjectLookup.AdminAuthObjectLookup<PermissionGroups> {
    }
}

