/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.Messages;
import java.text.CharacterIterator;

public final class StringBufferCharacterIterator
implements CharacterIterator {
    private StringBuffer text;
    private int begin;
    private int end;
    private int pos;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public StringBufferCharacterIterator(StringBuffer stringBuffer) {
        this(stringBuffer, 0);
    }

    public StringBufferCharacterIterator(StringBuffer stringBuffer, int n) {
        this(stringBuffer, 0, stringBuffer.length(), n);
    }

    public StringBufferCharacterIterator(StringBuffer stringBuffer, int n, int n2, int n3) {
        if (stringBuffer == null) {
            throw new NullPointerException();
        }
        this.text = stringBuffer;
        if (n < 0 || n > n2 || n2 > stringBuffer.length()) {
            throw new IllegalArgumentException(Messages.getString("invalid.substring"));
        }
        if (n3 < n || n3 > n2) {
            throw new IllegalArgumentException(Messages.getString("invalid.position"));
        }
        this.begin = n;
        this.end = n2;
        this.pos = n3;
    }

    public void setText(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            throw new NullPointerException();
        }
        this.text = stringBuffer;
        this.begin = 0;
        this.end = stringBuffer.length();
        this.pos = 0;
    }

    public char first() {
        this.pos = this.begin;
        return this.current();
    }

    public char last() {
        this.pos = this.end != this.begin ? this.end - 1 : this.end;
        return this.current();
    }

    public char setIndex(int n) {
        if (n < this.begin || n > this.end) {
            throw new IllegalArgumentException(Messages.getString("invalid.index"));
        }
        this.pos = n;
        return this.current();
    }

    public char current() {
        if (this.pos >= this.begin && this.pos < this.end) {
            return this.text.charAt(this.pos);
        }
        return '\uffff';
    }

    public char next() {
        if (this.pos < this.end - 1) {
            ++this.pos;
            return this.text.charAt(this.pos);
        }
        this.pos = this.end;
        return '\uffff';
    }

    public char previous() {
        if (this.pos > this.begin) {
            --this.pos;
            return this.text.charAt(this.pos);
        }
        return '\uffff';
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.end;
    }

    public int getIndex() {
        return this.pos;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StringBufferCharacterIterator)) {
            return false;
        }
        StringBufferCharacterIterator stringBufferCharacterIterator = (StringBufferCharacterIterator)object;
        if (this.hashCode() != stringBufferCharacterIterator.hashCode()) {
            return false;
        }
        if (!this.text.equals(stringBufferCharacterIterator.text)) {
            return false;
        }
        return this.pos == stringBufferCharacterIterator.pos && this.begin == stringBufferCharacterIterator.begin && this.end == stringBufferCharacterIterator.end;
    }

    public int hashCode() {
        return this.text.hashCode() ^ this.pos ^ this.begin ^ this.end;
    }

    public Object clone() {
        try {
            StringBufferCharacterIterator stringBufferCharacterIterator = (StringBufferCharacterIterator)super.clone();
            return stringBufferCharacterIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

