/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.parser.RBBICategory;
import java.text.CharacterIterator;
import java.util.Vector;

public class HTMLAnnotatedSource
implements ParsingStream {
    private static final String ENCODING = "UTF-8";
    private CharacterIterator text = null;
    private StringBuffer html = new StringBuffer();
    private StringBuffer s = new StringBuffer();
    private static final int ALLOC_SIZE = 1024;
    Holder holder = new Holder();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public Object get(String string) {
        return this.holder.get(string);
    }

    void addEncoded(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            switch (c) {
                case '<': {
                    this.html.append("&lt;");
                }
                case '>': {
                    this.html.append("&gt;");
                    continue block4;
                }
                default: {
                    this.html.append(c);
                }
            }
        }
    }

    void addElement(String string, int n, int n2, Object object) {
        this.html.append("<a class=");
        this.html.append(string);
        this.html.append(" href=\"");
        this.holder.add(this.html, object);
        this.html.append("\">");
        UniLexAnalyzer.memcpy(this.s, this.text, n, n2);
        this.addEncoded(this.s);
        this.html.append("</a> ");
    }

    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.holder.reset();
        this.text = uniLexAnalyzer.getSourceText();
        int n = this.text.getEndIndex() - this.text.getBeginIndex();
        this.html.ensureCapacity(n *= 10);
        this.html.setLength(0);
        this.html.append("<HTML>\r\n");
        this.html.append("<HEAD>\r\n");
        this.html.append("<STYLE>\r\n");
        this.html.append(".d { color:blue;   text-decoration: none; }\r\n");
        this.html.append(".w { color:#00008b;  text-decoration: none; }\r\n");
        this.html.append(".u { color:red; background-color: yellow; text-decoration: none; }\r\n");
        this.html.append(".p { color:green; text-decoration: none; }\r\n");
        this.html.append(".g { color:cyan;  text-decoration: none; }\r\n");
        this.html.append(".ge { color:cyan;  text-decoration: none; }\r\n");
        this.html.append("</STYLE>\r\n");
        this.html.append("</HEAD>\r\n");
        this.html.append("<BODY>\r\n");
        this.html.append("\r\n");
    }

    public void close() {
        this.html.append("\r\n");
        this.html.append("</BODY>\r\n");
        this.html.append("</HTML>\r\n");
    }

    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        this.addElement("d", n2, n3, glossCollection);
    }

    public void createUnknown(int n, int n2, int n3, int n4) {
        this.addElement(RBBICategory.isWordLike(n4) ? "w" : "u", n2, n3, new Integer(n4));
    }

    public void createBreakpoint(int n, int n2, int n3) {
        if (n3 == 2) {
            this.html.append("<b>&para; </b>\r\n");
            return;
        }
        if (n3 == 1) {
            this.html.append("\r\n<hr>\r\n\r\n");
            return;
        }
        this.html.append(" &lt;break type " + n3 + "&gt; ");
    }

    public void createPunctuation(int n, int n2, int n3, int n4) {
        this.html.append("<b class=p>");
        UniLexAnalyzer.memcpy(this.s, this.text, n2, n3);
        this.addEncoded(this.s);
        this.html.append("</b> ");
    }

    public int startGroup(int n, int n2, int n3) {
        if (n3 == 1) {
            this.html.append("[");
        } else {
            this.html.append("[(" + n3 + ")");
        }
        return 0;
    }

    public void closeGroup(int n) {
        this.html.append("] ");
    }

    public void fork() {
        this.html.append("&lt;");
    }

    public void addToFork() {
        this.html.append("&gt;&lt; ");
    }

    public void mergeRoutes(int n) {
        this.html.append("&gt; ");
    }

    public void showError(String string) {
        this.html.setLength(0);
        this.html.append("<html>\r\n");
        this.html.append("<body>\r\n");
        this.addEncoded(new StringBuffer(string));
        this.html.append("</body>");
        this.html.append("</html>");
    }

    public String getHTML() {
        String string = this.html.toString();
        return string;
    }

    static class Holder {
        Vector arrays;
        Object[] currArray = new Object[1024];
        int block;
        int pos;

        Holder() {
            this.arrays = new Vector(4, 4);
            this.currArray = new Object[1024];
            this.arrays.add(this.currArray);
            this.reset();
        }

        void reset() {
            this.block = 0;
            this.pos = 0;
        }

        void grow() {
            this.currArray = new Object[1024];
            this.arrays.add(this.currArray);
            ++this.block;
            this.pos = 0;
        }

        void add(StringBuffer stringBuffer, Object object) {
            if (this.pos >= this.currArray.length) {
                this.grow();
            }
            this.currArray[this.pos] = object;
            stringBuffer.append("?b=" + Integer.toHexString(this.block) + "&p=" + Integer.toHexString(this.pos));
            ++this.pos;
        }

        Object get(int n, int n2) {
            try {
                Object[] objectArray = (Object[])this.arrays.get(n);
                return objectArray[n2];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        Object get(String string) {
            try {
                int n;
                int n2;
                int n3 = string.indexOf(63);
                if (n3 >= 0 && string.charAt(n3 + 1) == 'b' && (n2 = string.indexOf(38, n = n3 + 3)) >= 0 && string.charAt(n2 + 1) == 'p') {
                    int n4;
                    int n5;
                    int n6 = string.length();
                    for (n5 = n4 = n2 + 3; n5 < n6 && Character.isLetterOrDigit(string.charAt(n5)); ++n5) {
                    }
                    int n7 = Integer.parseInt(string.substring(n, n2), 16);
                    int n8 = Integer.parseInt(string.substring(n4, n5), 16);
                    return this.get(n7, n8);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

