/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipException;

public class CorrectedGZIPInputStream
extends GZIPInputStream {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public CorrectedGZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, n);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eos) {
            return -1;
        }
        if ((n2 = this.readBytes(byArray, n, n2)) == -1) {
            this.readTrailer();
            this.eos = true;
        } else {
            this.crc.update(byArray, n, n2);
        }
        return n2;
    }

    private int readBytes(byte[] byArray, int n, int n2) throws IOException {
        if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            int n3;
            while ((n3 = this.inf.inflate(byArray, n, n2)) == 0) {
                if (this.inf.finished() || this.inf.needsDictionary()) {
                    return -1;
                }
                if (!this.inf.needsInput()) continue;
                this.fill();
            }
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            String string = dataFormatException.getMessage();
            throw new ZipException(string != null ? string : "Invalid ZLIB data format");
        }
    }

    private void readTrailer() throws IOException {
        InputStream inputStream = this.in;
        int n = this.inf.getRemaining();
        if (n > 0) {
            inputStream = new SequenceInputStream(new ByteArrayInputStream(this.buf, this.len - n, n), this.in);
        }
        long l = 0xFFFFFFFFL & (long)this.inf.getTotalOut();
        long l2 = this.crc.getValue();
        long l3 = this.readUInt(inputStream);
        long l4 = this.readUInt(inputStream);
        if (l3 != l2) {
            throw new IOException("GZIP trailer CRC error");
        }
        if (l4 != l) {
            throw new IOException("GZIP trailer length error " + l + "/" + l4);
        }
    }

    private long readUInt(InputStream inputStream) throws IOException {
        long l = inputStream.read();
        l |= (long)inputStream.read() << 8;
        l |= (long)inputStream.read() << 16;
        return l |= (long)inputStream.read() << 24;
    }
}

