/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.util;

import java.io.ByteArrayInputStream;
import java.text.CharacterIterator;

public class ByteCharacterIterator
extends ByteArrayInputStream
implements CharacterIterator {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public ByteCharacterIterator(byte[] byArray) {
        super(byArray);
    }

    public void setData(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public final char current() {
        if (this.pos >= this.count) {
            return '\uffff';
        }
        return (char)(this.buf[this.pos] & 0xFF);
    }

    public final char first() {
        this.pos = 0;
        return this.current();
    }

    public final char last() {
        this.pos = this.count > 0 ? this.count - 1 : 0;
        return this.current();
    }

    public char next() {
        if (++this.pos >= this.count) {
            this.pos = this.count;
            return '\uffff';
        }
        return (char)(this.buf[this.pos] & 0xFF);
    }

    public char previous() {
        if (--this.pos < 0) {
            this.pos = -1;
            return '\uffff';
        }
        return (char)(this.buf[this.pos] & 0xFF);
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.count;
    }

    public int getIndex() {
        return this.pos;
    }

    public char setIndex(int n) {
        this.pos = n;
        if (this.pos < 0 || this.pos >= this.count) {
            return '\uffff';
        }
        return (char)(this.buf[this.pos] & 0xFF);
    }

    public Object clone() {
        return null;
    }
}

