/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.trellis.EdgeListElement;
import com.ibm.dltj.trellis.GlossFilter;
import com.ibm.dltj.trellis.Trellis;
import com.ibm.dltj.trellis.WeightBuffer;
import com.ibm.dltj.trellis.WeightEdgeListElement;
import com.ibm.dltj.trellis.WeightExtractor;
import com.ibm.dltj.util.ArrayResize;

public final class WeightTrellis
implements Trellis {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    private int startIndex;
    private int endIndex;
    private WeightBuffer[] matches = new WeightBuffer[32];
    private WeightEdgeListElement[] path = new WeightEdgeListElement[32];
    private static final int SEGMENT_SIZE = 16;
    private final WeightExtractor extractor;
    private final GlossFilter filter;
    private static final boolean DEBUG = "1".equals(System.getProperty("TRELLIS.DEBUG"));

    static String getCopyright() {
        return COPYRIGHT;
    }

    public WeightTrellis(WeightExtractor weightExtractor, GlossFilter glossFilter) {
        int n;
        this.extractor = weightExtractor;
        this.filter = glossFilter;
        for (n = 0; n < this.matches.length; ++n) {
            this.matches[n] = new WeightBuffer();
        }
        for (n = 0; n < this.path.length; ++n) {
            this.path[n] = new WeightEdgeListElement();
        }
    }

    public void init(int n) {
        this.startIndex = this.endIndex = n;
        this.extractor.open();
    }

    public void clear() {
        this.endIndex = 0;
        this.startIndex = 0;
        this.extractor.close();
        for (int i = 0; i < this.matches.length; ++i) {
            this.matches[i].clear();
        }
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public boolean isAmbiguous(int n) {
        return this.endIndex != n;
    }

    public boolean isEmpty() {
        return this.startIndex == this.endIndex;
    }

    public void addElement(int n, int n2, Object object) {
        int n3;
        int n4;
        if (this.endIndex < n2) {
            this.endIndex = n2;
        }
        if ((n4 = this.matches.length) <= (n3 = n2 - this.startIndex)) {
            int n5 = (n3 / 16 + 1) * 16;
            this.matches = (WeightBuffer[])ArrayResize.resize(this.matches, n5);
            this.path = (WeightEdgeListElement[])ArrayResize.resize(this.path, n5);
            for (int i = n4; i < n5; ++i) {
                this.matches[i] = new WeightBuffer();
                this.path[i] = new WeightEdgeListElement();
            }
        }
        this.extractor.extract(n, n2, object, this.matches[n - this.startIndex]);
    }

    public EdgeListElement process() throws DLTException {
        WeightEdgeListElement weightEdgeListElement;
        int n;
        int n2 = this.endIndex - this.startIndex;
        this.path[0].weight = 0;
        this.path[0].next = null;
        for (n = 1; n <= n2; ++n) {
            this.path[n].weight = Integer.MAX_VALUE;
        }
        this.path[n2].next = null;
        for (n = 0; n <= n2; ++n) {
            WeightEdgeListElement weightEdgeListElement2 = this.path[n];
            if (weightEdgeListElement2.weight == Integer.MAX_VALUE) continue;
            WeightBuffer weightBuffer = this.matches[n];
            for (int i = 0; i < weightBuffer.size; ++i) {
                if (!this.filter.accept(weightBuffer.glosses[i])) continue;
                WeightEdgeListElement weightEdgeListElement3 = this.path[weightBuffer.endIndices[i] - this.startIndex];
                if (weightEdgeListElement2.weight + weightBuffer.weights[i] >= weightEdgeListElement3.weight) continue;
                weightEdgeListElement3.set(weightBuffer.startIndices[i], weightBuffer.endIndices[i], weightEdgeListElement2.weight + weightBuffer.weights[i], weightBuffer.glosses[i], weightEdgeListElement2);
            }
        }
        if (DEBUG) {
            this.getPathDiagram();
        }
        return (weightEdgeListElement = this.path[n2]) == null ? null : weightEdgeListElement.reverse();
    }

    public Object[] getElement(int n, int n2) {
        WeightBuffer weightBuffer = this.matches[n - this.startIndex];
        int n3 = 0;
        Object object = null;
        for (int i = 0; i < weightBuffer.size; ++i) {
            if (n2 != weightBuffer.endIndices[i] || object == weightBuffer.elements[i]) continue;
            object = weightBuffer.elements[i];
            ++n3;
        }
        Object[] objectArray = new Object[n3];
        n3 = 0;
        object = null;
        for (int i = 0; i < weightBuffer.size; ++i) {
            if (n2 != weightBuffer.endIndices[i] || object == weightBuffer.elements[i]) continue;
            object = weightBuffer.elements[i];
            objectArray[n3++] = object;
        }
        return objectArray;
    }

    public void append(Trellis trellis, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.endIndex < n2) {
            this.endIndex = n2;
        }
        if ((n5 = this.matches.length) <= (n4 = n2 - this.startIndex + 1)) {
            n3 = (n4 / 16 + 1) * 16;
            this.matches = (WeightBuffer[])ArrayResize.resize(this.matches, n3);
            this.path = (WeightEdgeListElement[])ArrayResize.resize(this.path, n3);
            for (int i = n5; i < n3; ++i) {
                this.matches[i] = new WeightBuffer();
                this.path[i] = new WeightEdgeListElement();
            }
        }
        n3 = ((WeightTrellis)trellis).startIndex;
        WeightBuffer[] weightBufferArray = ((WeightTrellis)trellis).matches;
        for (int i = n; i < n2; ++i) {
            this.matches[i - this.startIndex].append(weightBufferArray[i - n3]);
        }
    }

    private void getPathDiagram() {
        WeightEdgeListElement weightEdgeListElement;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = this.endIndex - this.startIndex;
        stringBuffer.append("digraph \"G\" {\n");
        stringBuffer.append("rankdir=LR;\n");
        stringBuffer.append("node [shape=plaintext];\n");
        stringBuffer.append("\"0\" [label=\"Text Index:0\"];\n");
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("\"").append(n).append("\" -> \"").append(n + 1).append("\";\n");
        }
        stringBuffer.append("node [fontsize=").append("8").append(", widht=").append(".25").append(", height").append(".25").append(", shape=ellipse];\n");
        for (n = 0; n <= n2; ++n) {
            stringBuffer.append("{ rank=same; ");
            stringBuffer.append("\"").append(n).append("\" ");
            weightEdgeListElement = this.path[n];
            stringBuffer.append("\"index").append(n).append("\" ");
            stringBuffer.append("; }\n");
            stringBuffer.append("\"index").append(n).append("\" [label=\"").append(n).append("\"];\n");
        }
        stringBuffer.append("edge [fontsize=").append("8").append("];\n");
        for (n = 0; n <= n2; ++n) {
            weightEdgeListElement = this.path[n];
            stringBuffer.append("\"index").append(weightEdgeListElement.startIndex).append("\"->\"index").append(weightEdgeListElement.endIndex).append("\" [label=\"").append(weightEdgeListElement.weight).append("\"];\n");
        }
        stringBuffer.append("}\n\n");
        stringBuffer2.append("\n");
        System.err.println("[For Graphviz]");
        System.err.println("Sample usage to draw the trellis graph in SVG format: ");
        System.err.println("1) install \"Graphviz\" and \"Adobe SVG Viewer\"");
        System.err.println("2) save below script as \"graph.dot\"");
        System.err.println("3) run command> dot -Gfontname=\"MS Gothic\" -Nfontname=\"MS Gothic\" -Efontname=\"MS Gothic\" -Tsvg -ograph.svg graph.dot");
        System.err.println("4) \"graph.svg\" is the result graph file");
        System.err.println();
        System.err.print(stringBuffer.toString());
        System.err.println();
        System.err.println("[For Manual trace]");
        System.err.println();
        System.err.print(stringBuffer2.toString());
        System.err.println();
    }
}

