/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.util.ArrayResize;

public final class WeightBuffer {
    public static final String COPYRIGHT = "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    int[] startIndices;
    int[] endIndices;
    Object[] elements;
    Object[] glosses;
    int[] weights;
    private static final int BLOCK_SIZE = 8;
    int size = 0;

    static String getCopyright() {
        return COPYRIGHT;
    }

    WeightBuffer() {
        this.startIndices = new int[8];
        this.endIndices = new int[8];
        this.elements = new Object[8];
        this.glosses = new Object[8];
        this.weights = new int[8];
    }

    WeightBuffer(int n) {
        this.startIndices = new int[n];
        this.endIndices = new int[n];
        this.elements = new Object[n];
        this.glosses = new Object[n];
        this.weights = new int[n];
    }

    void clear() {
        this.size = 0;
    }

    public void add(int n, int n2, Object object, Object object2, int n3) {
        int n4 = this.elements.length;
        if (n4 == this.size) {
            int n5 = (this.size / 8 + 1) * 8;
            this.startIndices = (int[])ArrayResize.resize(this.startIndices, n5);
            this.endIndices = (int[])ArrayResize.resize(this.endIndices, n5);
            this.elements = (Object[])ArrayResize.resize(this.elements, n5);
            this.glosses = (Object[])ArrayResize.resize(this.glosses, n5);
            this.weights = (int[])ArrayResize.resize(this.weights, n5);
        }
        this.startIndices[this.size] = n;
        this.endIndices[this.size] = n2;
        this.elements[this.size] = object;
        this.glosses[this.size] = object2;
        this.weights[this.size] = n3;
        ++this.size;
    }

    void append(WeightBuffer weightBuffer) {
        int n = this.elements.length;
        int n2 = this.size + weightBuffer.size;
        if (n <= n2) {
            int n3 = (n2 / 8 + 1) * 8;
            this.startIndices = (int[])ArrayResize.resize(this.startIndices, n3);
            this.endIndices = (int[])ArrayResize.resize(this.endIndices, n3);
            this.elements = (Object[])ArrayResize.resize(this.elements, n3);
            this.glosses = (Object[])ArrayResize.resize(this.glosses, n3);
            this.weights = (int[])ArrayResize.resize(this.weights, n3);
        }
        System.arraycopy(weightBuffer.startIndices, 0, this.startIndices, this.size, weightBuffer.size);
        System.arraycopy(weightBuffer.endIndices, 0, this.endIndices, this.size, weightBuffer.size);
        System.arraycopy(weightBuffer.elements, 0, this.elements, this.size, weightBuffer.size);
        System.arraycopy(weightBuffer.glosses, 0, this.glosses, this.size, weightBuffer.size);
        System.arraycopy(weightBuffer.weights, 0, this.weights, this.size, weightBuffer.size);
        this.size += weightBuffer.size;
    }
}

