/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.data.ja.JaStatesNameHandler;
import com.ibm.dltj.trellis.EdgeListElement;
import com.ibm.dltj.trellis.GlossFilter;
import com.ibm.dltj.trellis.StateArray;
import com.ibm.dltj.trellis.StateBuffer;
import com.ibm.dltj.trellis.StateEdgeListElement;
import com.ibm.dltj.trellis.StateEdgeListElementArray;
import com.ibm.dltj.trellis.StateExtractor;
import com.ibm.dltj.trellis.Trellis;
import com.ibm.dltj.util.ArrayResize;

public final class StateTrellis
implements Trellis {
    private static final int STATE_ID_START = 0;
    private static final int STATE_ID_FINAL = 1;
    private int startIndex;
    private int endIndex;
    private StateBuffer[] matches = new StateBuffer[128];
    private StateEdgeListElementArray[] columns = new StateEdgeListElementArray[128];
    private static final int SEGMENT_SIZE = 64;
    private final StateExtractor extractor;
    private final GlossFilter filter;
    private static final boolean DEBUG = "1".equals(System.getProperty("TRELLIS.DEBUG"));

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public StateTrellis(StateExtractor stateExtractor, GlossFilter glossFilter) {
        int n;
        this.extractor = stateExtractor;
        this.filter = glossFilter;
        for (n = 0; n < this.matches.length; ++n) {
            this.matches[n] = new StateBuffer();
        }
        for (n = 0; n < this.columns.length; ++n) {
            this.columns[n] = new StateEdgeListElementArray();
        }
    }

    public void init(int n) {
        this.startIndex = this.endIndex = n;
        this.extractor.open();
    }

    public void clear() {
        int n;
        this.endIndex = 0;
        this.startIndex = 0;
        this.extractor.close();
        for (n = 0; n < this.matches.length; ++n) {
            this.matches[n].clear();
        }
        for (n = 0; n < this.columns.length; ++n) {
            this.columns[n].clear();
        }
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public boolean isAmbiguous(int n) {
        return this.endIndex != n;
    }

    public boolean isEmpty() {
        return this.startIndex == this.endIndex;
    }

    public void addElement(int n, int n2, Object object) {
        int n3;
        int n4;
        if (this.endIndex < n2) {
            this.endIndex = n2;
        }
        if ((n4 = this.matches.length) <= (n3 = n2 - this.startIndex)) {
            int n5 = (n3 / 64 + 1) * 64;
            this.matches = (StateBuffer[])ArrayResize.resize(this.matches, n5);
            this.columns = (StateEdgeListElementArray[])ArrayResize.resize(this.columns, n5);
            for (int i = n4; i < n5; ++i) {
                this.matches[i] = new StateBuffer();
                this.columns[i] = new StateEdgeListElementArray();
            }
        }
        this.extractor.extract(n, n2, object, this.matches[n - this.startIndex]);
    }

    public EdgeListElement process() throws DLTException {
        StateEdgeListElement stateEdgeListElement;
        int n;
        Object object;
        int n2 = this.endIndex - this.startIndex;
        this.columns[0].add(this.startIndex, this.startIndex, 0, 0, 0, null, null);
        for (int i = 0; i <= n2; ++i) {
            StateEdgeListElementArray stateEdgeListElementArray = this.columns[i];
            object = this.matches[i];
            for (n = 0; n < stateEdgeListElementArray.size; ++n) {
                stateEdgeListElement = stateEdgeListElementArray.array[n];
                for (int j = 0; j < ((StateBuffer)object).size; ++j) {
                    Object object2;
                    StateArray stateArray = ((StateBuffer)object).matrices[j].get(stateEdgeListElement.endState);
                    if (stateArray == null || !this.filter.accept(object2 = ((StateBuffer)object).glosses[j])) continue;
                    int n3 = ((StateBuffer)object).startIndices[j];
                    int n4 = ((StateBuffer)object).endIndices[j];
                    StateEdgeListElementArray stateEdgeListElementArray2 = this.columns[n4 - this.startIndex];
                    for (int k = 0; k < stateArray.size; ++k) {
                        int n5 = stateArray.states[k];
                        int n6 = stateArray.weights[k] + stateEdgeListElement.weight;
                        int n7 = 0;
                        for (n7 = 0; n7 < stateEdgeListElementArray2.size; ++n7) {
                            StateEdgeListElement stateEdgeListElement2 = stateEdgeListElementArray2.array[n7];
                            if (n5 != stateEdgeListElement2.endState) continue;
                            if (n6 >= stateEdgeListElement2.weight) break;
                            stateEdgeListElement2.set(n3, n4, stateEdgeListElement.endState, n5, n6, object2, stateEdgeListElement);
                            break;
                        }
                        if (n7 != stateEdgeListElementArray2.size) continue;
                        stateEdgeListElementArray2.add(n3, n4, stateEdgeListElement.endState, n5, n6, object2, stateEdgeListElement);
                    }
                }
            }
        }
        StateEdgeListElement stateEdgeListElement3 = null;
        int n8 = Integer.MAX_VALUE;
        object = this.columns[n2];
        for (n = 0; n < ((StateEdgeListElementArray)object).size; ++n) {
            stateEdgeListElement = ((StateEdgeListElementArray)object).array[n];
            if (stateEdgeListElement.endState != 1 || stateEdgeListElement.weight >= n8) continue;
            stateEdgeListElement3 = stateEdgeListElement;
            n8 = stateEdgeListElement.weight;
        }
        if (DEBUG) {
            this.getPathDiagram();
        }
        return stateEdgeListElement3 == null ? null : stateEdgeListElement3.reverse();
    }

    public Object[] getElement(int n, int n2) {
        StateBuffer stateBuffer = this.matches[n - this.startIndex];
        int n3 = 0;
        Object object = null;
        for (int i = 0; i < stateBuffer.size; ++i) {
            if (n2 != stateBuffer.endIndices[i] || object == stateBuffer.elements[i]) continue;
            object = stateBuffer.elements[i];
            ++n3;
        }
        Object[] objectArray = new Object[n3];
        n3 = 0;
        object = null;
        for (int i = 0; i < stateBuffer.size; ++i) {
            if (n2 != stateBuffer.endIndices[i] || object == stateBuffer.elements[i]) continue;
            object = stateBuffer.elements[i];
            objectArray[n3++] = object;
        }
        return objectArray;
    }

    public void append(Trellis trellis, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (this.endIndex < n2) {
            this.endIndex = n2;
        }
        if ((n5 = this.matches.length) <= (n4 = n2 - this.startIndex + 1)) {
            n3 = (n4 / 64 + 1) * 64;
            this.matches = (StateBuffer[])ArrayResize.resize(this.matches, n3);
            this.columns = (StateEdgeListElementArray[])ArrayResize.resize(this.columns, n3);
            for (int i = n5; i < n3; ++i) {
                this.matches[i] = new StateBuffer();
                this.columns[i] = new StateEdgeListElementArray();
            }
        }
        n3 = ((StateTrellis)trellis).startIndex;
        StateBuffer[] stateBufferArray = ((StateTrellis)trellis).matches;
        for (int i = n; i < n2; ++i) {
            this.matches[i - this.startIndex].append(stateBufferArray[i - n3]);
        }
    }

    private void getPathDiagram() {
        StateEdgeListElement stateEdgeListElement;
        int n;
        StateEdgeListElementArray stateEdgeListElementArray;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        JaStatesNameHandler jaStatesNameHandler = JaStatesNameHandler.getInstance();
        int n3 = this.endIndex - this.startIndex;
        stringBuffer.append("digraph \"G\" {\n");
        stringBuffer.append("rankdir=LR;\n");
        stringBuffer.append("node [shape=plaintext];\n");
        stringBuffer.append("\"0\" [label=\"Text Index:0\"];\n");
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuffer.append("\"").append(n2).append("\" -> \"").append(n2 + 1).append("\";\n");
        }
        stringBuffer.append("node [fontsize=").append("8").append(", fontname=").append("\"Arial Unicode MS\"").append(", widht=").append(".25").append(", height").append(".25").append(", shape=ellipse];\n");
        for (n2 = 0; n2 <= n3; ++n2) {
            stateEdgeListElementArray = this.columns[n2];
            stringBuffer.append("{ rank=same; ");
            stringBuffer.append("\"").append(n2).append("\" ");
            for (n = 0; n < stateEdgeListElementArray.size; ++n) {
                stateEdgeListElement = stateEdgeListElementArray.array[n];
                if (stateEdgeListElement.endState == 1) continue;
                stringBuffer.append("\"").append(stateEdgeListElement.endIndex).append("_").append(stateEdgeListElement.endState).append("\" ");
            }
            stringBuffer.append("; }\n");
            for (n = 0; n < stateEdgeListElementArray.size; ++n) {
                stateEdgeListElement = stateEdgeListElementArray.array[n];
                stringBuffer.append("\"").append(stateEdgeListElement.endIndex).append("_").append(stateEdgeListElement.endState).append("\" [label=\"#").append(stateEdgeListElement.endState).append("\\n").append(jaStatesNameHandler.get(stateEdgeListElement.endState)).append("\"];\n");
            }
        }
        stringBuffer.append("edge [fontsize=").append("8").append("];\n");
        for (n2 = 0; n2 <= n3; ++n2) {
            stateEdgeListElementArray = this.columns[n2];
            for (n = 0; n < stateEdgeListElementArray.size; ++n) {
                stateEdgeListElement = stateEdgeListElementArray.array[n];
                stringBuffer.append("\"").append(stateEdgeListElement.startIndex).append("_").append(stateEdgeListElement.startState).append("\"->\"").append(stateEdgeListElement.endIndex).append("_").append(stateEdgeListElement.endState).append("\" [label=\"").append(stateEdgeListElement.weight).append("\"];\n");
                stringBuffer2.append("(@").append(stateEdgeListElement.startIndex).append(", #").append(stateEdgeListElement.startState).append(") -> (@").append(stateEdgeListElement.endIndex).append(", #").append(stateEdgeListElement.endState).append(") = ").append(stateEdgeListElement.weight).append("\t").append(stateEdgeListElement.gloss).append("\n");
            }
        }
        stringBuffer.append("}\n\n");
        stringBuffer2.append("\n");
        System.err.println("[For Graphviz]");
        System.err.println("Sample usage to draw the trellis graph in SVG format: ");
        System.err.println("1) install \"Graphviz\" and \"Adobe SVG Viewer\"");
        System.err.println("2) save below script as \"graph.dot\"");
        System.err.println("3) run command> dot -Gfontname=\"MS Gothic\" -Nfontname=\"MS Gothic\" -Efontname=\"MS Gothic\" -Tsvg -ograph.svg graph.dot");
        System.err.println("4) \"graph.svg\" is the result graph file");
        System.err.println();
        System.err.print(stringBuffer.toString());
        System.err.println();
        System.err.println("[For Manual trace]");
        System.err.println();
        System.err.print(stringBuffer2.toString());
        System.err.println();
    }
}

