/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.trellis.StateArray;
import com.ibm.dltj.util.ArrayResize;

public final class StateMatrix {
    private StateArray[] matrix;
    private static final int BLOCK_SIZE = 256;
    private int hash = 17;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public StateMatrix() {
        this.matrix = new StateArray[256];
        this.hash = 17;
    }

    public StateMatrix(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (n2 >= nArray[i]) continue;
            n2 = nArray[i];
        }
        this.matrix = new StateArray[++n2];
        int[] nArray4 = new int[n2];
        for (n = 0; n < nArray.length; ++n) {
            int n3 = nArray[n];
            nArray4[n3] = nArray4[n3] + 1;
        }
        for (n = 0; n < this.matrix.length; ++n) {
            if (nArray4[n] <= 0) continue;
            this.matrix[n] = new StateArray(nArray4[n]);
        }
        for (n = 0; n < nArray.length; ++n) {
            this.matrix[nArray[n]].add(nArray2[n], nArray3[n]);
        }
        this.sort();
        this.hash();
    }

    public void add(int[] nArray, int[] nArray2, int[] nArray3) {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (n3 >= nArray[n2]) continue;
            n3 = nArray[n2];
        }
        n2 = this.matrix.length;
        if (n2 <= ++n3) {
            n = (n2 / 256 + 1) * 256;
            this.matrix = (StateArray[])ArrayResize.resize(this.matrix, n);
        }
        for (n = 0; n < nArray.length; ++n) {
            if (this.matrix[nArray[n]] == null) {
                this.matrix[nArray[n]] = new StateArray();
            }
            this.matrix[nArray[n]].add(nArray2[n], nArray3[n]);
        }
        this.trim();
        this.sort();
        this.hash();
    }

    private void trim() {
        int n;
        int n2 = this.matrix.length;
        for (n = this.matrix.length - 1; n >= 0; --n) {
            if (this.matrix[n] == null || this.matrix[n].size == 0) continue;
            n2 = n + 1;
            break;
        }
        if (n2 < this.matrix.length) {
            this.matrix = (StateArray[])ArrayResize.resize(this.matrix, n2);
        }
        for (n = 0; n < this.matrix.length; ++n) {
            if (this.matrix[n] == null) continue;
            this.matrix[n].trim();
        }
    }

    private void sort() {
        for (int i = 0; i < this.matrix.length; ++i) {
            if (this.matrix[i] == null) continue;
            this.matrix[i].sort();
        }
    }

    private void hash() {
        this.hash = 17;
        for (int i = 0; i < this.matrix.length; ++i) {
            if (this.matrix[i] == null) continue;
            this.hash = this.hash * 37 + this.matrix[i].hashCode();
        }
    }

    public StateArray get(int n) {
        return n < this.matrix.length ? this.matrix[n] : null;
    }

    public StateArray[] getAll() {
        return this.matrix;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StateMatrix)) {
            return false;
        }
        StateMatrix stateMatrix = (StateMatrix)object;
        StateArray[] stateArrayArray = stateMatrix.matrix;
        if (this.matrix.length != stateArrayArray.length) {
            return false;
        }
        for (int i = 0; i < this.matrix.length; ++i) {
            if (this.matrix[i] == null) {
                if (stateArrayArray[i] == null) continue;
                return false;
            }
            if (this.matrix[i].equals(stateArrayArray[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }
}

