/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.trellis.StateMatrix;
import com.ibm.dltj.util.ArrayResize;

public final class StateBuffer {
    int[] startIndices;
    int[] endIndices;
    Object[] elements;
    Object[] glosses;
    StateMatrix[] matrices;
    private static final int BLOCK_SIZE = 48;
    int size = 0;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    StateBuffer() {
        this.startIndices = new int[48];
        this.endIndices = new int[48];
        this.elements = new Object[48];
        this.glosses = new Object[48];
        this.matrices = new StateMatrix[48];
    }

    StateBuffer(int n) {
        this.startIndices = new int[n];
        this.endIndices = new int[n];
        this.elements = new Object[n];
        this.glosses = new Object[n];
        this.matrices = new StateMatrix[n];
    }

    void clear() {
        this.size = 0;
    }

    public void add(int n, int n2, Object object, Object object2, StateMatrix stateMatrix) {
        int n3 = this.elements.length;
        if (n3 == this.size) {
            int n4 = (this.size / 48 + 1) * 48;
            this.startIndices = (int[])ArrayResize.resize(this.startIndices, n4);
            this.endIndices = (int[])ArrayResize.resize(this.endIndices, n4);
            this.elements = (Object[])ArrayResize.resize(this.elements, n4);
            this.glosses = (Object[])ArrayResize.resize(this.glosses, n4);
            this.matrices = (StateMatrix[])ArrayResize.resize(this.matrices, n4);
        }
        this.startIndices[this.size] = n;
        this.endIndices[this.size] = n2;
        this.elements[this.size] = object;
        this.glosses[this.size] = object2;
        this.matrices[this.size] = stateMatrix;
        ++this.size;
    }

    void append(StateBuffer stateBuffer) {
        int n = this.elements.length;
        int n2 = this.size + stateBuffer.size;
        if (n <= n2) {
            int n3 = (n2 / 48 + 1) * 48;
            this.startIndices = (int[])ArrayResize.resize(this.startIndices, n3);
            this.endIndices = (int[])ArrayResize.resize(this.endIndices, n3);
            this.elements = (Object[])ArrayResize.resize(this.elements, n3);
            this.glosses = (Object[])ArrayResize.resize(this.glosses, n3);
            this.matrices = (StateMatrix[])ArrayResize.resize(this.matrices, n3);
        }
        System.arraycopy(stateBuffer.startIndices, 0, this.startIndices, this.size, stateBuffer.size);
        System.arraycopy(stateBuffer.endIndices, 0, this.endIndices, this.size, stateBuffer.size);
        System.arraycopy(stateBuffer.elements, 0, this.elements, this.size, stateBuffer.size);
        System.arraycopy(stateBuffer.glosses, 0, this.glosses, this.size, stateBuffer.size);
        System.arraycopy(stateBuffer.matrices, 0, this.matrices, this.size, stateBuffer.size);
        this.size += stateBuffer.size;
    }
}

