/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.trellis;

import com.ibm.dltj.util.ArrayResize;

public final class StateArray {
    int[] states;
    int[] weights;
    int size = 0;
    private static final int BLOCK_SIZE = 16;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    StateArray() {
        this.states = new int[16];
        this.weights = new int[16];
    }

    StateArray(int n) {
        this.states = new int[n];
        this.weights = new int[n];
    }

    void add(int n, int n2) {
        int n3 = this.states.length;
        if (this.size == n3) {
            int n4 = (n3 / 16 + 1) * 16;
            this.states = (int[])ArrayResize.resize(this.states, n4);
            this.weights = (int[])ArrayResize.resize(this.weights, n4);
        }
        this.states[this.size] = n;
        this.weights[this.size] = n2;
        ++this.size;
    }

    void trim() {
        int n = this.states.length;
        if (this.size < n) {
            this.states = (int[])ArrayResize.resize(this.states, this.size);
            this.weights = (int[])ArrayResize.resize(this.weights, this.size);
        }
    }

    void sort() {
        for (int i = 0; i < this.size - 1; ++i) {
            int n;
            int n2 = i;
            for (n = i + 1; n < this.size; ++n) {
                int n3 = this.states[n] - this.states[n2];
                if (n3 < 0) {
                    n2 = n;
                    continue;
                }
                if (n3 != 0 || (n3 = this.weights[n] - this.weights[n2]) >= 0) continue;
                n2 = n;
            }
            n = this.states[i];
            int n4 = this.weights[i];
            this.states[i] = this.states[n2];
            this.weights[i] = this.weights[n2];
            this.states[n2] = n;
            this.weights[n2] = n4;
        }
    }

    public int[] states() {
        return this.states;
    }

    public int[] weights() {
        return this.weights;
    }

    public int size() {
        return this.size;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof StateArray)) {
            return false;
        }
        StateArray stateArray = (StateArray)object;
        if (this.size != stateArray.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.states[i] == stateArray.states[i] && this.weights[i] == stateArray.weights[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 17;
        n = n * 37 + this.size;
        for (int i = 0; i < this.size; ++i) {
            n = n * 37 + this.states[i];
            n = n * 37 + this.weights[i];
        }
        return n;
    }
}

