/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.text;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.TrieMap;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.gloss.AbstractGlossVectorGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.parser.MWUParsingStream;
import com.ibm.dltj.util.StringBufferCharacterIterator;
import java.text.CharacterIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;

public class TextModel
implements MWUParsingStream {
    static float WEIGHT_DEFAULT = 1.0f;
    static float WEIGHT_FOR_MW = 5.0f;
    static float WEIGHT_FOR_FIRST_IN_PARAGRAPH = 2.0f;
    static float WEIGHT_FOR_EMPHASIS = 1.0f;
    private CharacterIterator text;
    private boolean firstInSentence;
    private boolean firstInParagraph;
    private int sentenceBegin;
    private boolean doEmphasizeWord;
    SentenceAnnotation currentSentence;
    TrieMap wordIndex = new TrieMap();
    protected LinkedList words = new LinkedList();
    protected LinkedList sentences = new LinkedList();
    StringBuffer token = new StringBuffer();
    StringBufferCharacterIterator tokenItr = new StringBufferCharacterIterator(this.token);
    private boolean sentenceStarting;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    private float positionWeight() {
        float f = 0.0f;
        if (this.doEmphasizeWord) {
            f += WEIGHT_FOR_EMPHASIS;
        }
        if (this.firstInParagraph) {
            f += WEIGHT_FOR_FIRST_IN_PARAGRAPH;
        }
        return f;
    }

    protected void processToken(StringBuffer stringBuffer, Gloss gloss, float f) {
        this.dumpln(">" + stringBuffer.toString() + " +" + f);
        this.tokenItr.setText(stringBuffer);
        WordAnnotation wordAnnotation = null;
        Object object = this.wordIndex.get(this.tokenItr, stringBuffer.length());
        if (object == null) {
            wordAnnotation = new WordAnnotation(stringBuffer.toString(), gloss);
            try {
                this.tokenItr.setIndex(0);
                this.wordIndex.add(this.tokenItr, stringBuffer.length(), wordAnnotation);
                this.words.add(wordAnnotation);
            }
            catch (DLTException dLTException) {
                dLTException.printStackTrace();
            }
        } else {
            wordAnnotation = (WordAnnotation)object;
            if (gloss != null) {
                wordAnnotation.gloss = gloss;
            }
        }
        wordAnnotation.numRef++;
        wordAnnotation.weight += f;
        this.currentSentence.words.add(wordAnnotation);
    }

    public void createMWU(int n, int n2, int n3, Gloss gloss) {
        block6: {
            block5: {
                if (!(gloss instanceof AbstractGlossVectorGloss)) break block5;
                AbstractGlossVectorGloss abstractGlossVectorGloss = (AbstractGlossVectorGloss)gloss;
                int n4 = abstractGlossVectorGloss.numChildren();
                for (int i = 0; i < n4; ++i) {
                    Gloss gloss2 = abstractGlossVectorGloss.getChild(i);
                    if (!(gloss2 instanceof LemmaGenerator)) continue;
                    LemmaGenerator lemmaGenerator = (LemmaGenerator)((Object)gloss2);
                    try {
                        lemmaGenerator.getLemma(this.text, n2, n3, this.token);
                        this.processToken(this.token, gloss, WEIGHT_FOR_MW + this.positionWeight());
                    }
                    catch (DLTException dLTException) {
                        // empty catch block
                    }
                    LemmaGenerator lemmaGenerator2 = lemmaGenerator;
                }
                break block6;
            }
            if (!(gloss instanceof LemmaGenerator)) break block6;
            LemmaGenerator lemmaGenerator = (LemmaGenerator)((Object)gloss);
            try {
                lemmaGenerator.getLemma(this.text, n2, n3, this.token);
                this.processToken(this.token, gloss, WEIGHT_FOR_MW + this.positionWeight());
            }
            catch (DLTException dLTException) {
                // empty catch block
            }
        }
    }

    public void close() {
        Collections.sort(this.words);
        Iterator iterator = this.sentences.iterator();
        while (iterator.hasNext()) {
            SentenceAnnotation sentenceAnnotation = (SentenceAnnotation)iterator.next();
            sentenceAnnotation.weight();
        }
        Collections.sort(this.sentences);
    }

    public void createStd(int n, int n2, int n3, GlossCollection glossCollection) {
        if (this.firstInSentence) {
            this.sentenceBegin = n2;
            this.firstInSentence = false;
        }
        GlossListElement glossListElement = glossCollection.getFirst();
        LemmaGenerator lemmaGenerator = null;
        while (glossListElement != null) {
            MidGloss midGloss;
            FeatureSetGloss featureSetGloss;
            Gloss gloss = glossListElement.getGloss();
            if (gloss instanceof MidGloss && (featureSetGloss = (midGloss = (MidGloss)gloss).getFeatureGloss()) != null) {
                if (featureSetGloss.is(201)) {
                    this.doEmphasizeWord = true;
                    UniLexAnalyzer.memcpy(this.token, this.text, n2, n3);
                    this.dumpln(">>!" + this.token.toString());
                    return;
                }
                if (featureSetGloss.is(200)) {
                    UniLexAnalyzer.memcpy(this.token, this.text, n2, n3);
                    this.dumpln(">>>" + this.token.toString());
                    return;
                }
                int n4 = featureSetGloss.getPOS();
                LemmaGenerator lemmaGenerator2 = midGloss.getLemmaGloss();
                if (lemmaGenerator2 != null && lemmaGenerator2 != lemmaGenerator) {
                    try {
                        lemmaGenerator2.getLemma(this.text, n2, n3, this.token);
                        this.processToken(this.token, gloss, this.positionWeight());
                    }
                    catch (DLTException dLTException) {
                        // empty catch block
                    }
                    lemmaGenerator = lemmaGenerator2;
                }
            }
            glossListElement = glossListElement.next;
        }
        this.doEmphasizeWord = false;
        this.firstInSentence = false;
    }

    private void dumpln(String string) {
    }

    public void createUnknown(int n, int n2, int n3, int n4) {
        if (this.firstInSentence) {
            this.sentenceBegin = n2;
        }
        this.doEmphasizeWord = false;
        this.firstInSentence = false;
        UniLexAnalyzer.memcpy(this.token, this.text, n2, n3);
        int n5 = this.token.length();
        for (int i = 0; i < n5; ++i) {
            this.token.setCharAt(i, Character.toLowerCase(this.token.charAt(i)));
        }
        this.processToken(this.token, null, this.positionWeight());
    }

    public void createBreakpoint(int n, int n2, int n3) {
        if (n3 == 2) {
            this.firstInSentence = true;
            this.firstInParagraph = false;
            this.sentenceStarting = true;
            this.currentSentence.begin = this.sentenceBegin;
            this.currentSentence.end = n2;
            this.sentenceBegin = n2;
            this.sentences.add(this.currentSentence);
            this.currentSentence = new SentenceAnnotation();
        }
        if (n3 == 1) {
            this.firstInParagraph = true;
        }
        this.doEmphasizeWord = false;
    }

    public void createPunctuation(int n, int n2, int n3, int n4) {
    }

    public void reset(UniLexAnalyzer uniLexAnalyzer) {
        this.firstInSentence = true;
        this.doEmphasizeWord = false;
        this.sentenceStarting = true;
        this.text = uniLexAnalyzer.getSourceText();
        this.sentenceBegin = this.text.getIndex();
        this.words.clear();
        this.sentences.clear();
        this.wordIndex = new TrieMap();
        this.currentSentence = new SentenceAnnotation();
    }

    public int startGroup(int n, int n2, int n3) {
        return 0;
    }

    public void closeGroup(int n) {
    }

    public void fork() {
    }

    public void addToFork() {
    }

    public void mergeRoutes(int n) {
    }

    public static class SentenceAnnotation
    implements Comparable {
        int begin;
        int end;
        float weight = 0.0f;
        LinkedList words = new LinkedList();

        public void weight() {
            Iterator iterator = this.words.iterator();
            while (iterator.hasNext()) {
                WordAnnotation wordAnnotation = (WordAnnotation)iterator.next();
                this.weight += wordAnnotation.getWeight();
            }
        }

        public int compareTo(Object object) {
            if (object instanceof SentenceAnnotation) {
                SentenceAnnotation sentenceAnnotation = (SentenceAnnotation)object;
                return this.weight < sentenceAnnotation.weight ? 1 : (this.weight > sentenceAnnotation.weight ? -1 : 0);
            }
            return 0;
        }

        public synchronized int getBegin() {
            return this.begin;
        }

        public synchronized int getEnd() {
            return this.end;
        }

        public synchronized float getWeight() {
            return this.weight;
        }
    }

    public static class WordAnnotation
    implements Comparable {
        private String lemma;
        private Gloss gloss;
        private int numRef = 0;
        private float weight = 0.0f;

        public WordAnnotation(String string, Gloss gloss) {
            this.lemma = string;
            this.gloss = gloss;
        }

        public int compareTo(Object object) {
            if (object instanceof WordAnnotation) {
                WordAnnotation wordAnnotation = (WordAnnotation)object;
                return this.weight < wordAnnotation.weight ? 1 : (this.weight > wordAnnotation.weight ? -1 : 0);
            }
            return 0;
        }

        public synchronized String getLemma() {
            return this.lemma;
        }

        public synchronized float getWeight() {
            return this.weight;
        }

        public synchronized int getNumRef() {
            return this.numRef;
        }

        public synchronized Gloss getGloss() {
            return this.gloss;
        }
    }
}

