/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.nondeterm.ApproximateMatcher;

class SuggestionSet {
    int count;
    int worstCost;
    int worstIndex;
    int setSize = 100;
    String[] sgsSet = null;
    int[] sgsCost = null;
    public CharacterBuffer target;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    SuggestionSet(int n, CharacterBuffer characterBuffer) {
        this.setSize = n;
        this.count = 0;
        this.target = characterBuffer;
        this.sgsSet = new String[this.setSize];
        this.sgsCost = new int[this.setSize];
        this.worstCost = Integer.MAX_VALUE;
        this.worstIndex = this.setSize;
    }

    public synchronized void updateWorstCost() {
        this.worstCost = 0;
        for (int i = 0; i < this.setSize; ++i) {
            if (this.worstCost > this.sgsCost[i]) continue;
            this.worstIndex = i;
            this.worstCost = this.sgsCost[i];
        }
    }

    public synchronized int add(String string, int n) {
        if (this.count == this.setSize && n >= this.worstCost) {
            return this.count;
        }
        for (int i = 0; i < this.count; ++i) {
            if (!this.sgsSet[i].equals(string)) continue;
            if (this.sgsCost[i] > n) {
                this.sgsCost[i] = n;
                if (this.count == this.setSize) {
                    this.updateWorstCost();
                }
            }
            return this.count;
        }
        if (this.count < this.setSize) {
            this.sgsSet[this.count] = string;
            this.sgsCost[this.count] = n;
            ++this.count;
            return this.count;
        }
        ApproximateMatcher.dlt_assert(this.count == this.setSize);
        if (this.worstIndex == this.setSize) {
            this.updateWorstCost();
        }
        ApproximateMatcher.dlt_assert(this.worstIndex != this.setSize);
        this.sgsSet[this.worstIndex] = string;
        this.sgsCost[this.worstIndex] = n;
        this.updateWorstCost();
        return this.count;
    }
}

