/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.CharacterBufferPool;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.WalkerOptions;

abstract class NondeterministicWalker {
    protected int replySize = -1;
    public static final int poolSize = 256;
    protected Pool optionsPool = null;
    protected CharacterBufferPool characterBufferPool = null;
    public boolean extraRanking = false;
    public boolean whiteSpaceTokenization = false;
    public boolean allowExactMatch = false;
    protected static final int scaleFactor = 7;
    protected static int scale = 1;
    public static final int DLTAID_ABSOLUTE_WORSTCOST = Integer.MAX_VALUE;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public static int getScaleFactor() {
        return 128;
    }

    public NondeterministicWalker(CharacterBufferPool characterBufferPool) {
        this.characterBufferPool = characterBufferPool;
    }

    public NondeterministicWalker(CharacterBufferPool characterBufferPool, Pool pool) {
        this.characterBufferPool = characterBufferPool;
        this.optionsPool = pool;
    }

    void chainNodeHandler() {
        throw new IllegalArgumentException(Messages.getString("notimplement"));
    }

    abstract void preSwichHandler(WalkerOptions var1, WalkerOptions var2);

    abstract void defaultNodeHandler(Node var1, CharacterBuffer var2, WalkerOptions var3, WalkerOptions var4);

    abstract void forkNodeHandler(Node var1, CharacterBuffer var2, WalkerOptions var3, WalkerOptions var4);

    abstract void ptrGlossNodeHandler(Node var1, CharacterBuffer var2, WalkerOptions var3, WalkerOptions var4);

    abstract boolean finalise(Node var1, CharacterBuffer var2, WalkerOptions var3, WalkerOptions var4);

    abstract String[] gather(String var1, Dictionary[] var2, Dictionary var3, int var4, boolean var5) throws DLTException;

    public boolean enumWords(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions) {
        if (node == null) {
            return false;
        }
        int n = node.getType();
        WalkerOptions walkerOptions2 = (WalkerOptions)this.optionsPool.evoke();
        this.preSwichHandler(walkerOptions2, walkerOptions);
        switch (n) {
            case 4: {
                this.chainNodeHandler();
            }
            case 8: {
                this.forkNodeHandler(node, characterBuffer, walkerOptions2, walkerOptions);
                this.optionsPool.reclaim(walkerOptions2.id);
                return false;
            }
            case 5: {
                boolean bl = this.finalise(node, characterBuffer, walkerOptions2, walkerOptions);
                this.optionsPool.reclaim(walkerOptions2.id);
                return bl;
            }
            case 6: {
                boolean bl = this.finalise(node, characterBuffer, walkerOptions2, walkerOptions);
                this.ptrGlossNodeHandler(node, characterBuffer, walkerOptions2, walkerOptions);
                this.optionsPool.reclaim(walkerOptions2.id);
                if (!bl) {
                    this.enumWords(node.get_trans(0), characterBuffer, walkerOptions);
                }
                return bl;
            }
        }
        this.defaultNodeHandler(node, characterBuffer, walkerOptions2, walkerOptions);
        this.optionsPool.reclaim(walkerOptions2.id);
        return false;
    }

    static void dlt_assert(boolean bl) {
        if (!bl) {
            System.err.println(Messages.getString("fail.assertion"));
            Exception exception = new Exception();
            exception.printStackTrace();
        }
    }
}

