/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBuffer;
import com.ibm.dltj.CharacterBufferPool;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.gloss.IntegerGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.nondeterm.NondeterministicWalker;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.SuggestionSet;
import com.ibm.dltj.nondeterm.WalkerOptions;

class FuzzyMatcher
extends NondeterministicWalker {
    public static final char QQ = '?';
    public static final char SS = '*';
    private SuggestionSet sgSet = null;
    public static final int maxRSize = 1000;
    static /* synthetic */ Class class$com$ibm$dltj$nondeterm$WalkerOptions;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public FuzzyMatcher(CharacterBufferPool characterBufferPool) {
        super(characterBufferPool);
        this.optionsPool = new Pool();
        this.optionsPool.init(class$com$ibm$dltj$nondeterm$WalkerOptions == null ? (class$com$ibm$dltj$nondeterm$WalkerOptions = FuzzyMatcher.class$("com.ibm.dltj.nondeterm.WalkerOptions")) : class$com$ibm$dltj$nondeterm$WalkerOptions, 256);
    }

    boolean finalise(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) {
        if (walkerOptions2.level == walkerOptions2.target.length || walkerOptions2.level + 1 == walkerOptions2.target.length && walkerOptions2.target.string[walkerOptions2.target.string.length - 1] == '*') {
            int n = 0;
            if (this.extraRanking) {
                GlossListElement glossListElement = ((GlossCollection)node.getGloss()).getFirst();
                while (glossListElement != null) {
                    IntegerGloss integerGloss;
                    n = glossListElement.gloss.getType() == 1 ? ((integerGloss = (IntegerGloss)((MidGloss)glossListElement.gloss).getGloss(18)) != null ? integerGloss.weight : FuzzyMatcher.getScaleFactor() - 1) : (glossListElement.gloss.getType() == 18 ? ((IntegerGloss)glossListElement.gloss).weight : FuzzyMatcher.getScaleFactor() - 1);
                    glossListElement = glossListElement.next;
                }
            }
            if (this.replySize == this.sgSet.add(characterBuffer.toString(), n) && !this.extraRanking) {
                return true;
            }
        }
        return false;
    }

    void forkNodeHandler(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) {
        int n = node.num_trans();
        for (int i = n - 1; i >= 0; --i) {
            Node node2 = node.get_trans(i);
            if (node2 == null) continue;
            this.enumWords(node2, characterBuffer, walkerOptions2);
        }
    }

    void defaultNodeHandler(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) {
        char c = '\u0000';
        if (walkerOptions2.level >= walkerOptions2.target.length) {
            return;
        }
        c = walkerOptions2.target.string[walkerOptions2.level];
        Node node2 = null;
        if (c != '\u0000' && (node2 = node.next(c)) != null) {
            characterBuffer.add(c);
            walkerOptions.level = walkerOptions2.level + 1;
            walkerOptions.target = walkerOptions2.target;
            this.enumWords(node2, characterBuffer, walkerOptions);
            --characterBuffer.length;
            return;
        }
        if (c == '*') {
            walkerOptions.level = walkerOptions2.level + 1;
            walkerOptions.target = walkerOptions2.target;
            this.enumWords(node, characterBuffer, walkerOptions);
        }
        if (c == '?' || c == '*') {
            int n = node.num_trans();
            for (int i = 0; i < n; ++i) {
                node2 = node.get_trans(i);
                if (node2 == null) continue;
                char c2 = node.get_char(i);
                characterBuffer.add(c2);
                walkerOptions.level = walkerOptions2.level + 1;
                walkerOptions.target = walkerOptions2.target;
                this.enumWords(node2, characterBuffer, walkerOptions);
                if (c == '*') {
                    walkerOptions.level = walkerOptions2.level;
                    this.enumWords(node2, characterBuffer, walkerOptions);
                }
                --characterBuffer.length;
            }
        }
        this.characterBufferPool.releaseBuffer(characterBuffer);
    }

    void preSwichHandler(WalkerOptions walkerOptions, WalkerOptions walkerOptions2) {
    }

    public String[] gather(String string, Dictionary[] dictionaryArray, Dictionary dictionary, int n, boolean bl) {
        this.sgSet = new SuggestionSet(n > 1000 ? 1000 : n, null);
        this.replySize = n;
        CharacterBuffer characterBuffer = new CharacterBuffer(string);
        for (int i = 0; i < dictionaryArray.length; ++i) {
            if (dictionaryArray[i] == null) continue;
            WalkerOptions walkerOptions = (WalkerOptions)this.optionsPool.evoke();
            walkerOptions.target = characterBuffer;
            CharacterBuffer characterBuffer2 = this.characterBufferPool.newBuffer();
            characterBuffer2.clear();
            this.enumWords(dictionaryArray[i].getNet().first(), characterBuffer2, walkerOptions);
            this.optionsPool.reclaim(walkerOptions.id);
            this.characterBufferPool.releaseBuffer(characterBuffer2);
        }
        return this.retResult();
    }

    private String[] retResult() {
        int n;
        String[] stringArray = new String[this.replySize];
        int[] nArray = new int[this.replySize];
        int n2 = -1;
        if (this.sgSet.count == 0) {
            return null;
        }
        for (n = 0; n < stringArray.length; ++n) {
            int n3 = Integer.MAX_VALUE;
            for (int i = 0; i < this.sgSet.count; ++i) {
                if (this.sgSet.sgsSet[i] == null || this.sgSet.sgsCost[i] > n3) continue;
                n3 = this.sgSet.sgsCost[i];
                n2 = i;
            }
            if (n3 == Integer.MAX_VALUE) break;
            stringArray[n] = this.sgSet.sgsSet[n2];
            nArray[n] = this.sgSet.sgsCost[n2];
            this.sgSet.sgsSet[n2] = null;
        }
        if (n < stringArray.length) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            return stringArray2;
        }
        return stringArray;
    }

    void ptrGlossNodeHandler(Node node, CharacterBuffer characterBuffer, WalkerOptions walkerOptions, WalkerOptions walkerOptions2) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

