/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.nondeterm;

import com.ibm.dltj.CharacterBufferPool;
import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.nondeterm.AggregateMatcher;
import com.ibm.dltj.nondeterm.FuzzyMatcher;
import com.ibm.dltj.nondeterm.NondeterministicWalker;
import com.ibm.dltj.nondeterm.Pool;
import com.ibm.dltj.nondeterm.QGramMatcher;
import com.ibm.dltj.nondeterm.QueryExpander;
import com.ibm.dltj.nondeterm.RuleBasedNormalizer;
import com.ibm.dltj.nondeterm.SpellAider;
import java.io.File;

public class AdvancedLookupDriver {
    public static final int fuzzyMatch = 1;
    public static final int approximateMatchSpellAid = 2;
    public static final int approximateMatchQuery = 3;
    public static final int MATCTH_FUZZY = 1;
    public static final int MATCH_FUZZY = 1;
    public static final int MATCH_SPELLAID = 2;
    public static final int MATCH_QUERY = 3;
    public static final int MATCH_NORMALIZATION = 4;
    public static final int MATCH_AGGREGATE = 5;
    public static final int MATCH_QGRAM = 6;
    public Dictionary[] masters = null;
    public Dictionary rules = null;
    public boolean obeyRules = true;
    public boolean extraRanking = false;
    public boolean whiteSpaceTokenization = false;
    public boolean allowExactMatch = false;
    public boolean doWhiteSpaces = true;
    public boolean strictMWU = false;
    public boolean doKatakanaMiddleDot;
    private CharacterBufferPool cPool = null;
    private Pool optionsPool;
    private Pool matchBufferPool;
    static /* synthetic */ Class class$com$ibm$dltj$CharacterBuffer;
    static /* synthetic */ Class class$com$ibm$dltj$nondeterm$AppmWalkerOptions;
    static /* synthetic */ Class class$com$ibm$dltj$nondeterm$ApproximateMatcher$PoolableMatchBuffer;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    private void init() {
        this.cPool = new CharacterBufferPool();
        this.cPool.init(class$com$ibm$dltj$CharacterBuffer == null ? (class$com$ibm$dltj$CharacterBuffer = AdvancedLookupDriver.class$("com.ibm.dltj.CharacterBuffer")) : class$com$ibm$dltj$CharacterBuffer, 256);
        this.optionsPool = new Pool();
        this.optionsPool.init(class$com$ibm$dltj$nondeterm$AppmWalkerOptions == null ? (class$com$ibm$dltj$nondeterm$AppmWalkerOptions = AdvancedLookupDriver.class$("com.ibm.dltj.nondeterm.AppmWalkerOptions")) : class$com$ibm$dltj$nondeterm$AppmWalkerOptions, 256);
        this.matchBufferPool = new Pool();
        this.matchBufferPool.init(class$com$ibm$dltj$nondeterm$ApproximateMatcher$PoolableMatchBuffer == null ? (class$com$ibm$dltj$nondeterm$ApproximateMatcher$PoolableMatchBuffer = AdvancedLookupDriver.class$("com.ibm.dltj.nondeterm.ApproximateMatcher$PoolableMatchBuffer")) : class$com$ibm$dltj$nondeterm$ApproximateMatcher$PoolableMatchBuffer, 256);
    }

    public AdvancedLookupDriver(Dictionary[] dictionaryArray) {
        this.masters = dictionaryArray;
        this.init();
    }

    public void setRules(Dictionary dictionary) {
        this.rules = dictionary;
    }

    public void setRules(String string) throws Exception {
        File[] fileArray = Dictionary.find(string, 15);
        this.rules = new Dictionary(fileArray[0]);
    }

    public synchronized String[] match(String string, int n, int n2) throws DLTException {
        switch (n) {
            case 3: {
                QueryExpander queryExpander = new QueryExpander(this.cPool, this.optionsPool, this.matchBufferPool);
                queryExpander.extraRanking = this.extraRanking;
                queryExpander.whiteSpaceTokenization = this.whiteSpaceTokenization;
                queryExpander.allowExactMatch = this.allowExactMatch;
                queryExpander.doWhiteSpaces = this.doWhiteSpaces;
                queryExpander.doExtraSuffix = true;
                queryExpander.strictMWU = this.strictMWU;
                return queryExpander.gather(string, this.masters, this.rules, n2, this.obeyRules);
            }
            case 2: {
                SpellAider spellAider = new SpellAider(this.cPool, this.optionsPool, this.matchBufferPool);
                spellAider.extraRanking = this.extraRanking;
                spellAider.whiteSpaceTokenization = this.whiteSpaceTokenization;
                spellAider.allowExactMatch = this.allowExactMatch;
                spellAider.doWhiteSpaces = this.doWhiteSpaces;
                spellAider.doExtraSuffix = true;
                spellAider.strictMWU = this.strictMWU;
                return spellAider.gather(string, this.masters, this.rules, n2, this.obeyRules);
            }
            case 1: {
                FuzzyMatcher fuzzyMatcher = new FuzzyMatcher(this.cPool);
                fuzzyMatcher.extraRanking = this.extraRanking;
                fuzzyMatcher.whiteSpaceTokenization = this.whiteSpaceTokenization;
                fuzzyMatcher.allowExactMatch = true;
                return fuzzyMatcher.gather(string, this.masters, null, n2, false);
            }
            case 5: {
                AggregateMatcher aggregateMatcher = new AggregateMatcher(this.cPool, this.optionsPool, this.matchBufferPool);
                aggregateMatcher.extraRanking = false;
                aggregateMatcher.whiteSpaceTokenization = this.whiteSpaceTokenization;
                aggregateMatcher.allowExactMatch = this.allowExactMatch;
                aggregateMatcher.doWhiteSpaces = this.doWhiteSpaces;
                aggregateMatcher.doExtraSuffix = true;
                return aggregateMatcher.gather(string, this.masters, null, n2, false);
            }
            case 4: {
                RuleBasedNormalizer ruleBasedNormalizer = new RuleBasedNormalizer(this.cPool, this.optionsPool, this.matchBufferPool);
                ruleBasedNormalizer.extraRanking = false;
                ruleBasedNormalizer.whiteSpaceTokenization = this.whiteSpaceTokenization;
                ruleBasedNormalizer.allowExactMatch = this.allowExactMatch;
                ruleBasedNormalizer.doWhiteSpaces = this.doWhiteSpaces;
                ruleBasedNormalizer.doExtraSuffix = false;
                ruleBasedNormalizer.doKatakanaMiddleDot = this.doKatakanaMiddleDot;
                return ruleBasedNormalizer.gather(string, this.masters, this.rules, n2, true);
            }
            case 6: {
                QGramMatcher qGramMatcher = new QGramMatcher(this.cPool);
                qGramMatcher.extraRanking = this.extraRanking;
                qGramMatcher.whiteSpaceTokenization = this.whiteSpaceTokenization;
                qGramMatcher.allowExactMatch = true;
                return qGramMatcher.gather(string, this.masters, null, n2, false);
            }
        }
        return null;
    }

    public void dispose() {
        this.masters = null;
        this.rules = null;
        this.cPool = null;
    }

    public static int getCostScale() {
        return NondeterministicWalker.getScaleFactor();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

