/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MapperGloss;
import com.ibm.dltj.gloss.StringGloss;
import com.ibm.dltj.gloss.TypedGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class TypedVectorGloss
extends TypedGloss {
    public Gloss[] element = empty;
    private static Gloss[] empty = new Gloss[0];

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public TypedVectorGloss() {
    }

    public TypedVectorGloss(StringGloss stringGloss, Gloss[] glossArray, int n) throws DLTException {
        super(stringGloss, n);
        if (glossArray == null) {
            return;
        }
        for (int i = 0; i < glossArray.length; ++i) {
            if (glossArray[i] != null) continue;
            throw new DLTException(Messages.getString("error.gloss.null"));
        }
        this.element = new Gloss[glossArray.length];
        System.arraycopy(glossArray, 0, this.element, 0, glossArray.length);
    }

    public int numChildren() {
        return this.element.length;
    }

    public Gloss getChild(int n) {
        return this.element[n];
    }

    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        if (n <= 0) {
            throw new DLTException(Messages.getString("error.streamformat"));
        }
        this.rtData = dataInputStream.readInt();
        this.element = new Gloss[n];
        for (int i = 0; i < n; ++i) {
            this.element[i] = new MapperGloss(dataInputStream.readInt());
        }
        this.typeIndex = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.element.length);
        dataOutputStream.writeInt(this.rtData);
        for (int i = 0; i < this.element.length; ++i) {
            int n2 = glossMapper.getGlossIndex(this.element[i]);
            dataOutputStream.writeInt(n2);
        }
        this.typeIndex = glossMapper.getGlossIndex(this.type);
        dataOutputStream.writeInt(this.typeIndex);
    }

    public void recalcPointers(Gloss[] glossArray) {
        super.recalcPointers(glossArray);
        if (this.element != null && this.element.length > 0 && this.element[0] instanceof MapperGloss) {
            for (int i = 0; i < this.element.length; ++i) {
                this.element[i] = glossArray[((MapperGloss)this.element[i]).map];
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypedVectorGloss)) {
            return false;
        }
        if (!this.type.equals(((TypedGloss)object).type)) {
            return false;
        }
        if (this.rtData != ((TypedVectorGloss)object).rtData) {
            return false;
        }
        return Arrays.equals(this.element, ((TypedVectorGloss)object).element);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.type.hashCode();
        for (int i = 0; i < this.element.length; ++i) {
            Gloss gloss = this.element[i];
            if (gloss == null) continue;
            n = n * 37 + gloss.hashCode();
        }
        return n;
    }

    public int getType() {
        return 69;
    }

    public Gloss getGloss(String string) throws DLTException {
        if (this.type.equals(string)) {
            return this;
        }
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i] instanceof TypedVectorGloss) {
                return ((TypedVectorGloss)this.element[i]).getGloss(string);
            }
            if (!this.type.equals(this.element[i].getTypeName())) continue;
            return this.element[i];
        }
        return null;
    }
}

