/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.StringGloss;
import com.ibm.dltj.gloss.TypedGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TypedStringGloss
extends TypedGloss {
    public String value;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public TypedStringGloss() {
    }

    public TypedStringGloss(StringGloss stringGloss, String string, int n) {
        super(stringGloss, n);
        this.value = string;
    }

    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.rtData = dataInputStream.readInt();
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(dataInputStream.readChar());
        }
        this.value = stringBuffer.toString();
        this.typeIndex = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.value.length());
        dataOutputStream.writeInt(this.rtData);
        for (int i = 0; i < this.value.length(); ++i) {
            dataOutputStream.writeChar(this.value.charAt(i));
        }
        this.typeIndex = glossMapper.getGlossIndex(this.type);
        dataOutputStream.writeInt(this.typeIndex);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypedStringGloss)) {
            return false;
        }
        if (!this.type.equals(((TypedGloss)object).type)) {
            return false;
        }
        if (this.rtData != ((TypedStringGloss)object).rtData) {
            return false;
        }
        return this.value.equals(((TypedStringGloss)object).value);
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.type.hashCode();
        n = 37 * n + this.value.hashCode();
        return n;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public int getType() {
        return 66;
    }

    public String toString() {
        return "TypeName:'" + this.type.value + "' " + "value:'" + this.value + "'";
    }
}

