/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.StringGloss;
import com.ibm.dltj.gloss.TypedGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TypedDoubleGloss
extends TypedGloss {
    public double value;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public TypedDoubleGloss() {
    }

    public TypedDoubleGloss(StringGloss stringGloss, double d, int n) {
        super(stringGloss, n);
        this.value = d;
    }

    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.rtData = dataInputStream.readInt();
        this.value = dataInputStream.readDouble();
        this.typeIndex = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.rtData);
        dataOutputStream.writeDouble(this.value);
        this.typeIndex = glossMapper.getGlossIndex(this.type);
        dataOutputStream.writeInt(this.typeIndex);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypedDoubleGloss)) {
            return false;
        }
        if (!this.type.equals(((TypedGloss)object).type)) {
            return false;
        }
        if (this.rtData != ((TypedDoubleGloss)object).rtData) {
            return false;
        }
        return this.value == ((TypedDoubleGloss)object).value;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.type.hashCode();
        n = 37 * n + (int)this.value;
        return n;
    }

    public int getType() {
        return 68;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public String toString() {
        return "TypeName:'" + this.type.value + "' " + "value:'" + this.value + "'";
    }
}

