/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.AbstractCharVectorGloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class TCRGloss
extends AbstractCharVectorGloss {
    public static final byte DLT_CORRECTION_TYPE_UNDEFINED = 0;
    public static final byte DLT_CORRECTION_TYPE_PHONETIC = 1;
    public static final byte DLT_CORRECTION_TYPE_KEYBOARD = 2;
    public static final byte DLT_CORRECTION_TYPE_OCR = 3;
    public static final byte DLT_CORRECTION_TYPE_SYNONYM = 4;
    int allflags;
    public char[] charValue;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public TCRGloss() {
        this.allflags = 0;
    }

    public TCRGloss(int n, int n2, int n3, String string) throws DLTException {
        super(string);
        if ((n & (n ^ 0xFF) | n2 & (n2 ^ 0xFF) | n3 & (n3 ^ 0xFF)) != 0) {
            throw new DLTException(Messages.getString("invalid.parameter"));
        }
        this.allflags = n & 0xFF | (n2 & 0xFF) << 8 | (n3 & 0xFF) << 16;
        this.charValue = this.value.toCharArray();
    }

    public final void read(DataInputStream dataInputStream, int n) throws IOException {
        this.allflags = dataInputStream.readInt();
        super.read_(dataInputStream, n);
        this.charValue = this.value.toCharArray();
    }

    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.value.length());
        dataOutputStream.writeInt(this.allflags);
        dataOutputStream.writeInt(this.rtData);
        for (int i = 0; i < this.value.length(); ++i) {
            dataOutputStream.writeShort(this.value.charAt(i));
        }
    }

    public final boolean equals(Object object) {
        return object instanceof TCRGloss && this.allflags == ((TCRGloss)object).allflags && super.equals(object);
    }

    public int compareTo(Object object) {
        TCRGloss tCRGloss = (TCRGloss)object;
        int n = super.compareTo(tCRGloss);
        if (n != 0) {
            return n;
        }
        return this.allflags - tCRGloss.allflags;
    }

    public final int hashCode() {
        return this.hashCode_() * 17 + this.allflags;
    }

    public final int getType() {
        return 17;
    }

    public final int getBOFA() {
        return (this.allflags & 0xFF0000) >>> 16;
    }

    public final int getCost() {
        return (this.allflags & 0xFF00) >> 8;
    }

    public final int getRType() {
        return this.allflags & 0xFF;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TCR(");
        stringBuffer.append(this.getRType()).append(',');
        stringBuffer.append(this.getCost()).append(',');
        stringBuffer.append(this.getBOFA()).append(',');
        stringBuffer.append(this.value);
        stringBuffer.append(')');
        if (stringBuffer.capacity() > stringBuffer.length()) {
            return new String(stringBuffer.toString());
        }
        return stringBuffer.toString();
    }
}

