/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.AbstractGlossVectorGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MWElementGloss;
import com.ibm.dltj.gloss.MapperGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MWUGloss
extends AbstractGlossVectorGloss {
    private Gloss definitionGloss;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public MWUGloss() {
    }

    public MWUGloss(Gloss gloss) {
        this.definitionGloss = gloss;
    }

    public Gloss getDefinitionGloss() {
        return this.definitionGloss;
    }

    public int getType() {
        return 56;
    }

    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        super.read_(dataInputStream, n);
        int n2 = dataInputStream.readInt();
        if (n2 >= 0) {
            this.definitionGloss = new MapperGloss(n2);
        }
    }

    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        if (this.element.length == 0) {
            throw new DLTException(Messages.getString("error.length"));
        }
        super.write_(dataOutputStream, glossMapper);
        int n = -1;
        if (this.definitionGloss != null) {
            n = glossMapper.getGlossIndex(this.definitionGloss);
        }
        dataOutputStream.writeInt(n);
    }

    public void recalcPointers(Gloss[] glossArray) {
        super.recalcPointers(glossArray);
        if (this.definitionGloss instanceof MapperGloss) {
            this.definitionGloss = glossArray[((MapperGloss)this.definitionGloss).map];
        }
    }

    public void addMWE(MWElementGloss mWElementGloss) {
        Gloss[] glossArray = new Gloss[this.element.length + 1];
        System.arraycopy(this.element, 0, glossArray, 0, this.element.length);
        glossArray[this.element.length] = mWElementGloss;
        this.element = glossArray;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String toString() {
        return "MWUnit";
    }
}

