/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.AbstractGlossVectorGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MWUGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MWElementGloss
extends AbstractGlossVectorGloss {
    private int flags;
    public static final int TRIGGER_FLAG = Integer.MIN_VALUE;
    public static final int LEFT_CONTEXT_FLAG = 0x40000000;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public MWElementGloss() {
    }

    public MWElementGloss(boolean bl, boolean bl2) {
        if (bl) {
            this.flags |= Integer.MIN_VALUE;
        }
        if (bl2) {
            this.flags |= 0x40000000;
        }
    }

    public int getFlags() {
        return this.flags;
    }

    public int getType() {
        return 55;
    }

    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.flags = dataInputStream.readInt();
        super.read_(dataInputStream, n);
    }

    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.element.length);
        dataOutputStream.writeInt(this.flags);
        dataOutputStream.writeInt(this.rtData);
        for (int i = 0; i < this.element.length; ++i) {
            int n2 = glossMapper.getGlossIndex(this.element[i]);
            dataOutputStream.writeInt(n2);
        }
    }

    public boolean isTrigger() {
        return 0 != (this.flags & Integer.MIN_VALUE);
    }

    public boolean needsLeftContext() {
        return 0 != (this.flags & 0x40000000);
    }

    public void addMWU(MWUGloss mWUGloss) {
        Gloss[] glossArray = new Gloss[this.element.length + 1];
        System.arraycopy(this.element, 0, glossArray, 0, this.element.length);
        glossArray[this.element.length] = mWUGloss;
        this.element = glossArray;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(Object object) {
        return object == this;
    }

    public String toString() {
        return "MWElement(t=" + Boolean.toString(this.isTrigger()) + ",l=" + Boolean.toString(this.needsLeftContext()) + ")";
    }
}

