/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class JaMorphGloss
extends Gloss {
    int jkom;
    int jpos;
    int extra;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public JaMorphGloss() {
    }

    public JaMorphGloss(int n, int n2, int n3) {
        this.jkom = n;
        this.jpos = n2;
        if (n3 != 0 && n3 != 1) {
            throw new Error();
        }
        this.extra = n3 << 24;
    }

    public final void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.jkom = dataInputStream.readInt();
        this.jpos = dataInputStream.readInt();
        this.extra = dataInputStream.readInt();
    }

    public final void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.jkom);
        dataOutputStream.writeInt(this.jpos);
        dataOutputStream.writeInt(this.extra);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("JaMorph(");
        stringBuffer.append(this.jkom).append(":").append(this.jpos).append(":").append(this.extra);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof JaMorphGloss)) {
            return false;
        }
        JaMorphGloss jaMorphGloss = (JaMorphGloss)object;
        return jaMorphGloss.jkom == this.jkom && jaMorphGloss.jpos == this.jpos && jaMorphGloss.extra == this.extra;
    }

    public final int hashCode() {
        return this.jkom ^ this.jpos ^ this.extra & 0xFF000000;
    }

    public final int getJKOM() {
        return this.jkom;
    }

    public final int getJPOS() {
        return this.jpos;
    }

    public final int getPhraseStart() {
        return (this.extra & 0xFF000000) >> 24;
    }

    public final int getType() {
        return 32;
    }
}

