/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.trellis.StateArray;
import com.ibm.dltj.trellis.StateMatrix;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;

public final class JaGramSetGloss
extends Gloss {
    private StateMatrix matrix;
    private int hash = 17;
    public static final Comparator comparator = new Comparator(){

        public int compare(Object object, Object object2) {
            long l = (Long)object;
            long l2 = (Long)object2;
            int n = JaGramSetGloss.getStartState(l) - JaGramSetGloss.getStartState(l2);
            if (n != 0) {
                return n;
            }
            n = JaGramSetGloss.getEndState(l) - JaGramSetGloss.getEndState(l2);
            if (n != 0) {
                return n;
            }
            return JaGramSetGloss.getWeight(l) - JaGramSetGloss.getWeight(l2);
        }
    };

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public JaGramSetGloss() {
        this.matrix = new StateMatrix();
        this.hash = this.matrix.hashCode();
    }

    public JaGramSetGloss(long[] lArray) {
        int[] nArray = new int[lArray.length];
        int[] nArray2 = new int[lArray.length];
        int[] nArray3 = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            nArray[i] = JaGramSetGloss.getStartState(l);
            nArray2[i] = JaGramSetGloss.getEndState(l);
            nArray3[i] = JaGramSetGloss.getWeight(l);
        }
        this.matrix = new StateMatrix(nArray, nArray2, nArray3);
        this.hash = this.matrix.hashCode();
    }

    public JaGramSetGloss(int[] nArray, int[] nArray2, int[] nArray3) {
        this.matrix = new StateMatrix(nArray, nArray2, nArray3);
        this.hash = this.matrix.hashCode();
    }

    public int getType() {
        return 34;
    }

    public void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        if (n <= 0) {
            throw new DLTException(Messages.getString("error.streamformat"));
        }
        dataInputStream.readInt();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = dataInputStream.readLong();
            nArray[i] = JaGramSetGloss.getStartState(l);
            nArray2[i] = JaGramSetGloss.getEndState(l);
            nArray3[i] = JaGramSetGloss.getWeight(l);
        }
        this.matrix = new StateMatrix(nArray, nArray2, nArray3);
        this.hash = this.matrix.hashCode();
    }

    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n;
        StateArray[] stateArrayArray = this.matrix.getAll();
        int n2 = 0;
        for (int i = 0; i < stateArrayArray.length; ++i) {
            StateArray stateArray = stateArrayArray[i];
            if (stateArray == null) continue;
            n2 += stateArray.size();
        }
        long[] lArray = new long[n2];
        n2 = 0;
        for (n = 0; n < stateArrayArray.length; ++n) {
            StateArray stateArray = stateArrayArray[n];
            if (stateArray == null) continue;
            int[] nArray = stateArray.states();
            int[] nArray2 = stateArray.weights();
            int n3 = stateArray.size();
            for (int i = 0; i < n3; ++i) {
                lArray[n2++] = JaGramSetGloss.getFlag(n, nArray[i], nArray2[i]);
            }
        }
        n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(lArray.length);
        dataOutputStream.writeInt(0);
        for (int i = 0; i < lArray.length; ++i) {
            dataOutputStream.writeLong(lArray[i]);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JaGramSetGloss)) {
            return false;
        }
        return this.matrix.equals(((JaGramSetGloss)object).matrix);
    }

    public int hashCode() {
        return this.hash;
    }

    public void add(long[] lArray) {
        int[] nArray = new int[lArray.length];
        int[] nArray2 = new int[lArray.length];
        int[] nArray3 = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            nArray[i] = JaGramSetGloss.getStartState(l);
            nArray2[i] = JaGramSetGloss.getEndState(l);
            nArray3[i] = JaGramSetGloss.getWeight(l);
        }
        this.matrix.add(nArray, nArray2, nArray3);
        this.hash = this.matrix.hashCode();
    }

    public StateMatrix getData() {
        return this.matrix;
    }

    static final int getStartState(long l) {
        return (int)(l >> 16 & 0xFFFFL);
    }

    static final int getEndState(long l) {
        return (int)(l & 0xFFFFL);
    }

    static final int getWeight(long l) {
        return (int)(l >> 32 & 0xFFFFFFFFFFFFFFFFL);
    }

    public static final long getFlag(int n, int n2, int n3) {
        long l = 0L;
        l = ((long)n & 0xFFFFL) << 16;
        l |= (long)n2 & 0xFFFFL;
        return l |= ((long)n3 & 0xFFFFFFFFFFFFFFFFL) << 32;
    }
}

