/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public class GrammarGloss
extends Gloss {
    private static int[] nulmask = new int[0];
    public int rtData;
    public int[] mask;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public GrammarGloss() {
        this.mask = nulmask;
    }

    public GrammarGloss(int[] nArray) {
        this.mask = nArray;
    }

    public final void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.rtData = dataInputStream.readInt();
        this.mask = new int[n];
        for (int i = 0; i < n; ++i) {
            this.mask[i] = dataInputStream.readInt();
        }
    }

    public final void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.mask.length);
        dataOutputStream.writeInt(this.rtData);
        for (int i = 0; i < this.mask.length; ++i) {
            dataOutputStream.writeInt(this.mask[i]);
        }
    }

    public final boolean equals(Object object) {
        return object instanceof GrammarGloss && Arrays.equals(this.mask, ((GrammarGloss)object).mask);
    }

    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.mask.length; ++i) {
            n = n * 37 + this.mask[i];
        }
        return n;
    }

    public int getRtData() {
        return this.rtData;
    }

    public int setRtData(int n) {
        this.rtData = n;
        return this.rtData;
    }

    public final int getType() {
        return 13;
    }

    public int getMaskN() {
        return this.mask.length;
    }

    public int getMask(int n) {
        return this.mask[n];
    }

    public final String toString() {
        String string = "Gramm(";
        for (int i = 0; i < this.mask.length; ++i) {
            String string2 = Integer.toHexString(this.mask[i]);
            string = string + string2;
            if (i >= this.mask.length - 1) continue;
            string = string + ";";
        }
        string = string + ")";
        return string;
    }
}

