/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.GlossPool;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GlossMapper {
    private final GlossPool[] gp;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public GlossMapper(GlossPool[] glossPoolArray) {
        this.gp = glossPoolArray;
        this.assignGlossIndex();
    }

    private void assignGlossIndex() {
        int n = 0;
        for (int i = 0; i < this.gp.length; ++i) {
            if (this.gp[i] == null) continue;
            Hashtable hashtable = this.gp[i].glossHash;
            Set set = hashtable.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                entry.setValue(new Integer(n++));
            }
        }
    }

    public void reAssign() {
        for (int i = 0; i < this.gp.length; ++i) {
            if (this.gp[i] == null) continue;
            Hashtable hashtable = this.gp[i].glossHash;
            Set set = hashtable.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                entry.setValue(entry.getKey());
            }
        }
    }

    public int getGlossIndex(Gloss gloss) throws DLTException {
        int n = gloss.getType();
        Hashtable hashtable = this.gp[n].glossHash;
        Integer n2 = (Integer)hashtable.get(gloss);
        if (n2 == null) {
            throw new DLTException(Messages.getString("cannot.savegloss"));
        }
        return n2;
    }
}

