/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FeatureSetGloss
extends Gloss {
    public static final int DLT_SIMPLE_DECOMP_FLAG_ALONE = 1;
    public static final int DLT_SIMPLE_DECOMP_FLAG_BEGINNING = 2;
    public static final int DLT_SIMPLE_DECOMP_FLAG_MIDDLE = 4;
    public static final int DLT_SIMPLE_DECOMP_FLAG_END = 8;
    public static final int DLT_SIMPLE_DECOMP_FLAG_INVALID = 16;
    private static String[] nameMap = new String[9];
    private static final byte bofaOff = 8;
    private static final byte detOff = 16;
    private static final byte stopOff = 17;
    private static final byte correctOff = 18;
    private static final byte suggestOff = 19;
    private static final byte userOff = 20;
    int allflags = 0;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public static String getPOSName(int n) {
        return n > 0 && n < 9 ? nameMap[n] : nameMap[0];
    }

    public FeatureSetGloss() {
    }

    public FeatureSetGloss(int n, int n2, int n3, int n4, int n5) {
        this.allflags = n & 0xFF | (n2 & 0xFF) << 8 | (n3 & 1) << 16 | (n4 & 1) << 17 | 0x40000 | 0x80000 | (n5 & 0xFFF) << 20;
    }

    public FeatureSetGloss(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.allflags = n & 0xFF | (n2 & 0xFF) << 8 | (bl ? 1 : 0) << 16 | (bl2 ? 1 : 0) << 17 | (bl3 ? 1 : 0) << 18 | (bl4 ? 1 : 0) << 19;
    }

    public final void read(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.allflags = dataInputStream.readInt();
    }

    public final void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.allflags);
    }

    public final boolean equals(Object object) {
        return object instanceof FeatureSetGloss && this.allflags == ((FeatureSetGloss)object).allflags;
    }

    public final int hashCode() {
        return this.allflags;
    }

    public final int getPOS() {
        return this.allflags & 0xFF;
    }

    public final int getBOFA() {
        return (this.allflags & 0xFF00) >> 8;
    }

    public final int getConstraintsMask() {
        return this.getBOFA();
    }

    public final int getDet() {
        return (this.allflags & 0x10000) >> 16;
    }

    public final int getStop() {
        return (this.allflags & 0x20000) >> 17;
    }

    public final int getUser() {
        return this.allflags >> 20 & 0xFFF;
    }

    public final boolean isCorrectSpelling() {
        return (this.allflags & 0x40000) != 0;
    }

    public final boolean isSuggestion() {
        return (this.allflags & 0x80000) != 0;
    }

    public final int getType() {
        return 15;
    }

    public final String toString() {
        return "FSET(\"" + FeatureSetGloss.getPOSName(this.getPOS()) + "\" constr=" + Integer.toBinaryString(this.getBOFA()) + " " + (this.getStop() > 0 ? "st" : " ") + ")";
    }

    public final boolean is(int n) {
        if (n > 0 && n < 101) {
            return n == this.getPOS();
        }
        switch (n) {
            case 101: {
                return (this.getBOFA() & 1) != 0;
            }
            case 102: {
                return (this.getBOFA() & 2) != 0;
            }
            case 104: {
                return (this.getBOFA() & 8) != 0;
            }
            case 103: {
                return (this.getBOFA() & 4) != 0;
            }
            case 105: {
                return (this.getBOFA() & 0x10) != 0;
            }
            case 206: {
                return this.isCorrectSpelling();
            }
            case 207: {
                return this.isSuggestion();
            }
            case 201: {
                return this.getDet() != 0;
            }
            case 200: {
                return this.getStop() != 0;
            }
        }
        return false;
    }

    public final void set(int n) throws DLTException {
        throw new DLTException(Messages.getString("notimplement.method"));
    }

    static {
        FeatureSetGloss.nameMap[0] = "Unknown";
        FeatureSetGloss.nameMap[1] = "Pronoun";
        FeatureSetGloss.nameMap[2] = "Verb";
        FeatureSetGloss.nameMap[3] = "Noun";
        FeatureSetGloss.nameMap[4] = "Adjective";
        FeatureSetGloss.nameMap[5] = "Adverb";
        FeatureSetGloss.nameMap[6] = "Adposition";
        FeatureSetGloss.nameMap[7] = "Interjection";
        FeatureSetGloss.nameMap[8] = "Conjunction ";
    }

    public static interface FeatureTags {
        public static final int POS_UNKNOWN = 0;
        public static final int POS_PRONOUN = 1;
        public static final int POS_VERB = 2;
        public static final int POS_NOUN = 3;
        public static final int POS_ADJECTIVE = 4;
        public static final int POS_ADVERB = 5;
        public static final int POS_ADPOSITION = 6;
        public static final int POS_INTERJECTION = 7;
        public static final int POS_CONJUNCTION = 8;
        public static final int DECOMP_FLAG_ALONE = 101;
        public static final int DECOMP_FLAG_BEGINNING = 102;
        public static final int DECOMP_FLAG_MIDDLE = 103;
        public static final int DECOMP_FLAG_END = 104;
        public static final int DECOMP_FLAG_INVALID = 105;
        public static final int STOPWORD = 200;
        public static final int DETERMINER = 201;
        public static final int ENDOFSENTENCE = 202;
        public static final int PROPERCASE = 203;
        public static final int ABBREVIATION = 204;
        public static final int ACRONYM = 205;
        public static final int CORRECTLYSPELT = 206;
        public static final int SUGGESTION = 207;
    }
}

