/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.AbstractCharVectorGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.LemmaGenerator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public abstract class BasicCutPasteGloss
extends AbstractCharVectorGloss
implements LemmaGenerator,
Comparable {
    private byte conv;
    private byte options;
    private short cut;
    public static final byte DLT_CASE_CONV_NOCONV = 0;
    public static final byte DLT_CASE_CONV_TOLOWER = 1;
    public static final byte DLT_CASE_CONV_TOUPPER = 2;
    public static final byte DLT_CASE_CONV_CAPITALIZE = 3;
    static final byte DLT_FUZZY_CASE_SS_IS_ONE_CHAR = 1;
    static final byte DLT_FUZZY_CASE_FIRST_CHAR_ONLY = 2;
    static final byte DLT_FUZZY_CASE_GREEK = 32;
    static final byte DLT_FUZZY_CASE_GREEK_MASK = 28;
    static final ConvMethod[] METHODS = new ConvMethod[]{new ConvMethod(0, 0, new NoConvConverter()), new ConvMethod(1, 2, new ToLowerConverter()), new ConvMethod(3, 2, new ToUpperConverter()), new ConvMethod(1, 0, new ToLowerConverter()), new ConvMethod(2, 0, new ToUpperConverter()), new ConvMethod(3, 0, new CapitalizeConverter()), new ConvMethod(1, 1, new ToLowerConverter()), new ConvMethod(2, 1, new ToUpperConverter()), new ConvMethod(3, 1, new CapitalizeConverter())};

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    BasicCutPasteGloss() {
        this.cut = 0;
        this.conv = 0;
        this.options = 0;
    }

    BasicCutPasteGloss(String string, String string2) {
        ConvMethod convMethod = null;
        String string3 = null;
        int n = -1;
        for (int i = 0; i < METHODS.length; ++i) {
            ConvMethod convMethod2 = METHODS[i];
            String string4 = convMethod2.converter.process(string, convMethod2.options);
            int n2 = BasicCutPasteGloss.findDifferentPosition(string2, string4);
            if (n < n2) {
                convMethod = convMethod2;
                string3 = string4;
                n = n2;
            }
            if (n2 == Math.min(string.length(), string2.length())) break;
        }
        this.conv = convMethod.conv;
        this.options = convMethod.options;
        this.value = new String(string2.substring(n)).intern();
        this.cut = (short)(string3.length() - n);
    }

    BasicCutPasteGloss(String string, int n, byte by, byte by2) {
        this.value = string.intern();
        this.cut = (short)n;
        this.conv = by;
        this.options = by2;
    }

    private static int findDifferentPosition(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return i;
        }
        return n;
    }

    public void read(DataInputStream dataInputStream, int n) throws IOException {
        this.rtData = dataInputStream.readInt();
        short s = dataInputStream.readShort();
        this.conv = (byte)((s & 0xFFFF) >>> 14);
        this.options = (byte)(s & 0xFF);
        this.cut = dataInputStream.readShort();
        StringBuffer stringBuffer = new StringBuffer(n -= 2);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)dataInputStream.readShort());
        }
        this.value = stringBuffer.toString().intern();
    }

    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.value.length() + 2);
        dataOutputStream.writeInt(this.rtData);
        int n2 = 0;
        n2 = (this.conv & 0xFFFF) << 14;
        n2 = this.options | n2;
        dataOutputStream.writeShort((short)n2);
        dataOutputStream.writeShort(this.cut);
        for (int i = 0; i < this.value.length(); ++i) {
            dataOutputStream.writeShort(this.value.charAt(i));
        }
    }

    private static final void memcpy(StringBuffer stringBuffer, CharacterIterator characterIterator, int n) {
        if (n-- > 0) {
            stringBuffer.append(characterIterator.current());
        }
        while (n-- > 0) {
            stringBuffer.append(characterIterator.next());
        }
    }

    private final void apply(CharacterIterator characterIterator, int n, StringBuffer stringBuffer) throws DLTException {
        if (n < 0 || characterIterator.getEndIndex() < characterIterator.getIndex() + n) {
            throw new DLTException(Messages.getString("error.wordboundary"));
        }
        stringBuffer.setLength(0);
        switch (this.conv) {
            case 0: {
                BasicCutPasteGloss.memcpy(stringBuffer, characterIterator, n);
                break;
            }
            case 1: {
                BasicCutPasteGloss.applyToLower(characterIterator, n, stringBuffer, this.options);
                break;
            }
            case 2: {
                BasicCutPasteGloss.applyToUpper(characterIterator, n, stringBuffer, this.options);
                break;
            }
            case 3: {
                BasicCutPasteGloss.applyCapitalize(characterIterator, n, stringBuffer, this.options);
                break;
            }
            default: {
                throw new DLTException(Messages.getString("error.cutpaste"));
            }
        }
        int n2 = stringBuffer.length() - this.cut;
        if (n2 < 0) {
            throw new DLTException(Messages.getString("error.code"));
        }
        stringBuffer.setLength(n2);
        stringBuffer.append(this.value);
    }

    static final void applyToUpper(CharacterIterator characterIterator, int n, StringBuffer stringBuffer, byte by) {
        if (n-- <= 0) {
            return;
        }
        int n2 = characterIterator.current();
        do {
            switch (n2) {
                case 223: {
                    if ((by & 1) == 0) break;
                    stringBuffer.append('S');
                    n2 = 83;
                    break;
                }
                default: {
                    n2 = Character.toUpperCase((char)n2);
                }
            }
            stringBuffer.append((char)n2);
            n2 = characterIterator.next();
        } while ((by & 2) == 0 && n-- > 0);
        if (n > 0) {
            BasicCutPasteGloss.memcpy(stringBuffer, characterIterator, n);
        }
    }

    static final void applyToLower(CharacterIterator characterIterator, int n, StringBuffer stringBuffer, byte by) {
        if (n-- <= 0) {
            return;
        }
        int n2 = characterIterator.current();
        do {
            switch (n2) {
                case 83: {
                    if ((by & 1) != 0 && n > 0) {
                        --n;
                        n2 = characterIterator.next();
                        if (n2 == 83) {
                            n2 = 223;
                            break;
                        }
                        stringBuffer.append('s');
                        break;
                    }
                }
                default: {
                    n2 = Character.toLowerCase((char)n2);
                }
            }
            stringBuffer.append((char)n2);
            n2 = characterIterator.next();
        } while ((by & 2) == 0 && n-- > 0);
        if (n > 0) {
            BasicCutPasteGloss.memcpy(stringBuffer, characterIterator, n);
        }
    }

    static final void applyCapitalize(CharacterIterator characterIterator, int n, StringBuffer stringBuffer, byte by) {
        if (n-- <= 0) {
            return;
        }
        int n2 = characterIterator.current();
        switch (n2) {
            case 83: {
                if ((by & 1) == 0 || n <= 0) break;
                --n;
                char c = characterIterator.next();
                n2 = c;
                if (c == 'S') break;
                stringBuffer.append('S');
                break;
            }
            case 223: {
                if ((by & 1) == 0) break;
                stringBuffer.append('S');
                n2 = 83;
                break;
            }
            default: {
                n2 = Character.toUpperCase((char)n2);
            }
        }
        stringBuffer.append((char)n2);
        characterIterator.next();
        if ((by & 2) != 0) {
            BasicCutPasteGloss.memcpy(stringBuffer, characterIterator, n);
        } else {
            BasicCutPasteGloss.applyToLower(characterIterator, n, stringBuffer, by);
        }
    }

    public final void getLemma(CharacterIterator characterIterator, int n, int n2, StringBuffer stringBuffer) throws DLTException {
        int n3 = characterIterator.getIndex();
        characterIterator.setIndex(n);
        this.apply(characterIterator, n2 - n, stringBuffer);
        characterIterator.setIndex(n3);
    }

    public final String getLemma(CharacterIterator characterIterator, int n, int n2) throws DLTException {
        StringBuffer stringBuffer = new StringBuffer();
        this.getLemma(characterIterator, n, n2, stringBuffer);
        return stringBuffer.toString();
    }

    public final String getLemma(String string) throws DLTException {
        return this.getLemma(new StringCharacterIterator(string), 0, string.length());
    }

    public String toString(String string) throws DLTException {
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        int n = 0;
        int n2 = string.length();
        return this.getLemma(stringCharacterIterator, n, n2);
    }

    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof BasicCutPasteGloss)) {
            return false;
        }
        BasicCutPasteGloss basicCutPasteGloss = (BasicCutPasteGloss)object;
        return basicCutPasteGloss.value.equals(this.value) && basicCutPasteGloss.cut == this.cut && basicCutPasteGloss.conv == this.conv && basicCutPasteGloss.options == this.options;
    }

    public int compareTo(BasicCutPasteGloss basicCutPasteGloss) {
        int n = super.compareTo(basicCutPasteGloss);
        if (n != 0) {
            return n;
        }
        n = this.cut - basicCutPasteGloss.cut;
        if (n != 0) {
            return n;
        }
        n = this.conv - basicCutPasteGloss.conv;
        if (n != 0) {
            return n;
        }
        n = this.options - basicCutPasteGloss.options;
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public int hashCode() {
        return this.cut + (this.conv << 3) + (this.options << 5) ^ this.value.hashCode();
    }

    public String toString() {
        return "@" + this.cut + " " + this.conv + " +\"" + this.value + "\"";
    }

    public int getMinSourceLength() {
        return this.cut;
    }

    public byte getConv() {
        return this.conv;
    }

    public short getCut() {
        return this.cut;
    }

    public byte getOptions() {
        return this.options;
    }

    private static class ConvMethod {
        final byte conv;
        final byte options;
        final Converter converter;

        public ConvMethod(byte by, byte by2, Converter converter) {
            this.conv = by;
            this.options = by2;
            this.converter = converter;
        }
    }

    private static final class NoConvConverter
    implements Converter {
        private NoConvConverter() {
        }

        public String process(String string, byte by) {
            return string;
        }
    }

    private static final class CapitalizeConverter
    implements Converter {
        private CapitalizeConverter() {
        }

        public String process(String string, byte by) {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            StringBuffer stringBuffer = new StringBuffer();
            BasicCutPasteGloss.applyCapitalize(stringCharacterIterator, string.length(), stringBuffer, by);
            return stringBuffer.toString();
        }
    }

    private static final class ToUpperConverter
    implements Converter {
        private ToUpperConverter() {
        }

        public String process(String string, byte by) {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            StringBuffer stringBuffer = new StringBuffer();
            BasicCutPasteGloss.applyToUpper(stringCharacterIterator, string.length(), stringBuffer, by);
            return stringBuffer.toString();
        }
    }

    private static final class ToLowerConverter
    implements Converter {
        private ToLowerConverter() {
        }

        public String process(String string, byte by) {
            StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
            StringBuffer stringBuffer = new StringBuffer();
            BasicCutPasteGloss.applyToLower(stringCharacterIterator, string.length(), stringBuffer, by);
            return stringBuffer.toString();
        }
    }

    private static interface Converter {
        public String process(String var1, byte var2);
    }
}

