/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.gloss.AbstractCharVectorGloss;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.LemmaGenerator;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.CharacterIterator;

public class ArabicTransformCodeGloss
extends AbstractCharVectorGloss
implements LemmaGenerator.ForLemma {
    private static final char codeAccept = '!';
    private static final char codeDelete = '~';
    private static final char codeDeleteAll = '^';

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public ArabicTransformCodeGloss() {
    }

    public ArabicTransformCodeGloss(String string) {
        super(string);
    }

    public void getLemma(CharacterIterator characterIterator, int n, int n2, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        UniLexAnalyzer.memcpy(stringBuffer, characterIterator, n, n2);
        int n3 = this.value.length() - 1;
        int n4 = stringBuffer.length();
        while (n3 >= 0 && n4 >= 0) {
            char c = this.value.charAt(n3);
            if (c == '~') {
                stringBuffer.deleteCharAt(n4 - 1);
                --n3;
                --n4;
                continue;
            }
            if (c == '^') {
                stringBuffer.replace(0, n4, "");
                --n3;
                continue;
            }
            if (c == '!') {
                --n3;
                --n4;
                continue;
            }
            stringBuffer.insert(n4, c);
            --n3;
        }
    }

    public String getLemma(CharacterIterator characterIterator, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.getLemma(characterIterator, n, n2, stringBuffer);
        return stringBuffer.toString();
    }

    public int getType() {
        return 71;
    }

    public void read(DataInputStream dataInputStream, int n) throws IOException {
        super.read_(dataInputStream, n);
    }

    public void write(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        super.write_(dataOutputStream, glossMapper);
    }

    public int getMinSourceLength() {
        return 0;
    }

    public String toString() {
        return "ArabicTC(" + this.value + ")";
    }

    public int compareTo(Object object) {
        ArabicTransformCodeGloss arabicTransformCodeGloss = (ArabicTransformCodeGloss)object;
        return super.compareTo(arabicTransformCodeGloss);
    }
}

