/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.Messages;
import com.ibm.dltj.gloss.GlossMapper;
import com.ibm.dltj.gloss.MapperGloss;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractGlossVectorGloss
extends Gloss {
    public Gloss[] element = empty;
    public int rtData = 0;
    private static Gloss[] empty = new Gloss[0];

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public AbstractGlossVectorGloss() {
    }

    public AbstractGlossVectorGloss(Gloss[] glossArray) throws DLTException {
        this.rtData = 0;
        if (glossArray == null) {
            return;
        }
        for (int i = 0; i < glossArray.length; ++i) {
            Gloss gloss = glossArray[i];
            if (gloss != null) continue;
            throw new DLTException(Messages.getString("error.gloss.null"));
        }
        this.element = new Gloss[glossArray.length];
        System.arraycopy(glossArray, 0, this.element, 0, glossArray.length);
    }

    public int numChildren() {
        return this.element.length;
    }

    public Gloss getChild(int n) {
        return this.element[n];
    }

    public void setChild(int n, Gloss gloss) {
        if (n > -1 && n < this.element.length) {
            this.element[n] = gloss;
            return;
        }
        throw new IllegalArgumentException();
    }

    public final void read_(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        if (n < 0) {
            throw new DLTException(Messages.getString("error.streamformat"));
        }
        this.element = new Gloss[n];
        this.rtData = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.element[i] = new MapperGloss(dataInputStream.readInt());
        }
    }

    public void write_(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.element.length);
        dataOutputStream.writeInt(this.rtData);
        for (int i = 0; i < this.element.length; ++i) {
            int n2 = glossMapper.getGlossIndex(this.element[i]);
            dataOutputStream.writeInt(n2);
        }
    }

    public void recalcPointers(Gloss[] glossArray) {
        if (this.element != null && this.element.length > 0 && this.element[0] instanceof MapperGloss) {
            for (int i = 0; i < this.element.length; ++i) {
                this.element[i] = glossArray[((MapperGloss)this.element[i]).map];
            }
        }
    }

    public int hashCode_() {
        int n = 17;
        for (int i = 0; i < this.element.length; ++i) {
            Gloss gloss = this.element[i];
            if (gloss == null) continue;
            n = n * 37 + gloss.hashCode();
        }
        return n;
    }

    public int hashCode() {
        return this.hashCode_();
    }

    public boolean equals(Object object) {
        return object instanceof AbstractGlossVectorGloss && Arrays.equals(this.element, ((AbstractGlossVectorGloss)object).element);
    }

    public int getRtData() {
        return this.rtData;
    }

    public void setRtData(int n) {
        this.rtData = n;
    }

    public final Gloss getGloss(Class clazz) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i].getClass() != clazz) continue;
            return this.element[i];
        }
        return null;
    }

    public final Gloss getGloss(int n) {
        for (int i = 0; i < this.element.length; ++i) {
            if (this.element[i].getType() != n) continue;
            return this.element[i];
        }
        return null;
    }
}

