/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class AbstractCharVectorGloss
extends Gloss
implements Comparable {
    public String value;
    public int rtData;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public AbstractCharVectorGloss() {
        this.value = "";
    }

    public AbstractCharVectorGloss(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.value = string.intern();
    }

    public final void read_(DataInputStream dataInputStream, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(n);
        this.rtData = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)dataInputStream.readShort());
        }
        this.value = stringBuffer.toString().intern();
    }

    public void write_(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.value.length());
        dataOutputStream.writeInt(this.rtData);
        for (int i = 0; i < this.value.length(); ++i) {
            dataOutputStream.writeShort(this.value.charAt(i));
        }
    }

    public final int hashCode_() {
        return this.value.hashCode();
    }

    public int hashCode() {
        return this.hashCode_();
    }

    public boolean equals(Object object) {
        return object instanceof AbstractCharVectorGloss && this.value.equals(((AbstractCharVectorGloss)object).value);
    }

    public int compareTo(AbstractCharVectorGloss abstractCharVectorGloss) {
        return this.value.compareTo(abstractCharVectorGloss.value);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public int getRtData() {
        return this.rtData;
    }

    public int setRtData(int n) {
        this.rtData = n;
        return this.rtData;
    }
}

