/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.gloss;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

public abstract class AbstractByteVectorGloss
extends Gloss {
    public byte[] value;
    public int rtData;

    static String copyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public AbstractByteVectorGloss() {
        this.value = new byte[0];
    }

    public AbstractByteVectorGloss(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        this.value = byArray;
    }

    public final void read_(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        this.rtData = dataInputStream.readInt();
        this.value = new byte[n];
        dataInputStream.read(this.value);
    }

    public void write_(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws IOException, DLTException {
        int n = glossMapper.getGlossIndex(this);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(this.value.length);
        dataOutputStream.writeInt(this.rtData);
        dataOutputStream.write(this.value);
    }

    public final int hashCode_() {
        return this.value.hashCode();
    }

    public byte[] getValue() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public int getRtData() {
        return this.rtData;
    }

    public int setRtData(int n) {
        this.rtData = n;
        return this.rtData;
    }

    public int getType() {
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractByteVectorGloss && Arrays.equals(((AbstractByteVectorGloss)object).value, this.value);
    }

    public int hashCode() {
        int n = 1;
        for (int i = 0; i < this.value.length; ++i) {
            n = 31 * n + this.value[i];
        }
        return n;
    }
}

