/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst._NetDefs;
import com.ibm.icu.text.Normalizer;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

public abstract class _NetNodeFunctions
extends _NetDefs {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    abstract int first_ptr();

    int node_clsid(int n) {
        return this.getType(n);
    }

    abstract int node_size(int var1);

    abstract int next(int var1, char var2);

    abstract int next(int var1, CharacterIterator var2);

    abstract int num_entries(int var1);

    abstract int num_trans(int var1);

    abstract int num_chars(int var1);

    abstract int get_trans(int var1, int var2);

    abstract char get_char(int var1, int var2);

    abstract String get_chars(int var1, int var2);

    abstract void set_trans(int var1, int var2, int var3) throws DLTException;

    abstract void set_char(int var1, int var2, char var3);

    abstract void set_chars(int var1, CharacterIterator var2, int var3, int var4);

    abstract int addChar(int var1, char var2, int var3, int var4) throws DLTException;

    abstract int add(int var1, CharacterIterator var2, int var3) throws DLTException;

    abstract boolean replace(int var1, CharacterIterator var2, int var3, int var4) throws DLTException;

    abstract int remove(int var1, CharacterIterator var2, int var3, int var4) throws DLTException;

    abstract boolean isFinal(int var1);

    abstract void copy_add(int var1, int var2, CharacterIterator var3, int var4) throws DLTException;

    abstract int getGlossIdx(int var1);

    abstract Object getGlossByIdx(int var1);

    abstract Object getGlossForNode(int var1);

    abstract void setGlossIdx(int var1, int var2);

    abstract int next_restricted(int var1, CharacterIterator var2, int var3);

    abstract int getType(int var1);

    abstract int match(int var1, CharacterIterator var2);

    public Object get(CharacterIterator characterIterator, int n) {
        int n2 = characterIterator.getIndex();
        int n3 = n2 + n;
        int n4 = this.first_ptr();
        while (n2 <= n3) {
            int n5 = this.next(n4, characterIterator);
            if (n5 == -1) {
                return null;
            }
            n2 = characterIterator.getIndex();
            if (n2 == n3 && this.isFinal(n5)) {
                return this.getGlossForNode(n5);
            }
            n4 = n5;
        }
        return null;
    }

    int getInt(CharacterIterator characterIterator, int n) {
        int n2 = characterIterator.getIndex();
        int n3 = n2 + n;
        int n4 = this.first_ptr();
        while (n2 <= n3) {
            int n5 = this.next(n4, characterIterator);
            n2 = characterIterator.getIndex();
            if (n5 == -1) {
                return -1;
            }
            if (this.isFinal(n5) && n2 == n3) {
                return this.getGlossIdx(n5);
            }
            n4 = n5;
        }
        return -1;
    }

    public int traverse(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        int n = this.first_ptr();
        do {
            if (!this.isFinal(n)) continue;
            matchBuffer.add(characterIterator.getIndex(), this.getGlossForNode(n));
        } while ((n = this.next(n, characterIterator)) != -1);
        int n2 = matchBuffer.matchLength();
        if (n2 > 0) {
            matchBuffer.pushMatch();
        }
        return n2;
    }

    public int traverseReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        int n = this.first_ptr();
        do {
            if (!this.isFinal(n)) continue;
            matchBuffer.addReversed(characterIterator.getIndex(), this.getGlossForNode(n));
        } while ((n = this.next(n, characterIterator)) != -1);
        int n2 = matchBuffer.matchLength();
        if (n2 > 0) {
            matchBuffer.pushMatch();
        }
        return n2;
    }

    public final int normalizingTraverse(CharacterIterator characterIterator, MatchBuffer matchBuffer, Normalizer.Mode mode) {
        int n = this.first_ptr();
        while (true) {
            int n2;
            if ((n2 = this.next(n, characterIterator)) == -1) {
                String string = Normalizer.normalize((int)characterIterator.current(), (Normalizer.Mode)mode);
                StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
                do {
                    n = n2 = this.next(n, stringCharacterIterator);
                } while (n2 != -1 && stringCharacterIterator.current() != '\uffff');
                if (n2 == -1) break;
                characterIterator.setIndex(characterIterator.getIndex() + 1);
            }
            if (this.isFinal(n2)) {
                matchBuffer.add(characterIterator.getIndex(), this.getGlossForNode(n2));
            }
            n = n2;
        }
        int n3 = matchBuffer.matchLength();
        if (n3 > 0) {
            matchBuffer.pushMatch();
        }
        return n3;
    }

    public final int whitespaceIgnoringTraverse(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        int n;
        int n2 = n = this.first_ptr();
        while (true) {
            int n3;
            if ((n3 = this.next(n2, characterIterator)) == -1) {
                if (n2 == n || !Character.isSpaceChar(characterIterator.current())) break;
                characterIterator.next();
                continue;
            }
            if (this.isFinal(n3)) {
                matchBuffer.add(characterIterator.getIndex(), this.getGlossForNode(n3));
            }
            n2 = n3;
        }
        int n4 = matchBuffer.matchLength();
        if (n4 > 0) {
            matchBuffer.pushMatch();
        }
        return n4;
    }

    public boolean traverseLongest(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        int n = this.first_ptr();
        boolean bl = false;
        do {
            if (!this.isFinal(n) || !matchBuffer.addMax(characterIterator.getIndex(), this.getGlossForNode(n))) continue;
            bl = true;
        } while ((n = this.next(n, characterIterator)) != -1);
        if (bl) {
            matchBuffer.pushMatch();
        }
        return bl;
    }

    public boolean traverseLongestReversed(CharacterIterator characterIterator, MatchBuffer matchBuffer) {
        int n = this.first_ptr();
        boolean bl = false;
        do {
            if (!this.isFinal(n) || !matchBuffer.addMin(characterIterator.getIndex(), this.getGlossForNode(n))) continue;
            bl = true;
        } while ((n = this.next(n, characterIterator)) != -1);
        if (bl) {
            matchBuffer.pushMatch();
        }
        return bl;
    }
}

