/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossReader;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.IntArrayBuffer;
import com.ibm.dltj.fst._Net;
import java.io.DataInputStream;
import java.io.IOException;
import java.text.CharacterIterator;

abstract class _NetIntegerImplBase
extends _Net {
    private final IntArrayBuffer buffer = new IntArrayBuffer();
    protected int alloc_pos;
    protected boolean contiguous = true;
    private static final int SEGREGATE_SIZE = 32;
    private int[] best_fit = new int[32];
    private int assorted_sizes;
    private int alloc_size;
    private int alloc_buddy;
    private int numNodes;
    private static final int TABLE_NODE_N = 65536;
    static final boolean VERIFY_NODES = false;
    static final int[] bestHashSize = new int[]{769, 1543, 3079, 6151, 12289, 24593, 49157, 98317, 196613, 393241, 786433, 1572869, 0x30000B, 0x60000D, 0xC00005, 25165843};
    private IntHash intHash;

    static String getCopyright() {
        return "\n\nLicensed Materials - Property of IBM\nASW16ZZ\n(C) Copyright IBM Corp. 2003, 2006. All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or\ndisclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    }

    private void reset() {
        this.buffer.reset();
        this.alloc_size = 0;
        this.alloc_buddy = 0;
        this.first_node = 0;
        this.alloc_pos = 0;
        this.assorted_sizes = -1;
        for (int i = 0; i < 32; ++i) {
            this.best_fit[i] = -1;
        }
        this.numNodes = 0;
        this.contiguous = true;
        this.enchain = false;
        this.contracted = false;
    }

    public _NetIntegerImplBase() {
        this.reset();
        this.reallocate(0);
        this.new_node(1, 0);
    }

    IntArrayBuffer getBuffer() {
        return this.buffer;
    }

    void setBufferArray(int[] nArray) {
        this.reset();
        this.buffer.setArray(nArray);
    }

    public int getCode(int n) {
        return this.buffer.get(n);
    }

    public void setCode(int n, int n2) {
        this.buffer.put(n, n2);
    }

    private int _getN(int n) {
        return n >>> 8;
    }

    private int _setN(int n, int n2) {
        return n & 0xFF | n2 << 8;
    }

    private int _getType(int n) {
        return n & 0xFF;
    }

    int getN(int n) {
        return this._getN(this.buffer.get(n));
    }

    int getType(int n) {
        return this._getType(this.buffer.get(n));
    }

    int node_size(int n) {
        int n2 = this.buffer.get(n);
        return this.size_up_node(n2 & 0xFF, n2 >>> 8);
    }

    int next(int n, char c) {
        int n2 = this.getCode(n);
        int n3 = this._getN(n2);
        switch (this._getType(n2)) {
            case 1: {
                int n4 = this._linearSearch(n + 1, c, n3);
                if (n4 >= 0) {
                    int n5 = n + 1 + _NetIntegerImplBase.search_table_size(n3);
                    return this.buffer.get(n5 + n4);
                }
                return -1;
            }
            case 2: {
                int n6 = this._binarySearch(n + 1, c, n3);
                if (n6 >= 0) {
                    int n7 = n + 1 + _NetIntegerImplBase.search_table_size(n3);
                    return this.buffer.get(n7 + n6);
                }
                return -1;
            }
            case 3: {
                return this.buffer.get(n + 1 + (c & 0xFFFF));
            }
            case 4: {
                return -1;
            }
            case 8: {
                return n3 > 0 ? this.buffer.get(n + 1 + 1) : -1;
            }
            case 6: {
                return this.buffer.get(n + 1 + 1);
            }
            case 5: {
                return -1;
            }
        }
        return -1;
    }

    int next(int n, CharacterIterator characterIterator) {
        int n2 = this.buffer.get(n);
        int n3 = n2 >>> 8;
        int n4 = n2 & 0xFF;
        switch (n4) {
            case 1: {
                int n5 = this._linearSearch(n + 1, characterIterator.current(), n3);
                if (n5 >= 0) {
                    int n6 = n + 1 + _NetIntegerImplBase.search_table_size(n3);
                    characterIterator.next();
                    return this.buffer.get(n6 + n5);
                }
                return -1;
            }
            case 2: {
                int n7 = this._binarySearch(n + 1, characterIterator.current(), n3);
                if (n7 >= 0) {
                    int n8 = n + 1 + _NetIntegerImplBase.search_table_size(n3);
                    characterIterator.next();
                    return this.buffer.get(n8 + n7);
                }
                return -1;
            }
            case 3: {
                int n9 = this.buffer.get(n + 1 + characterIterator.current());
                if (n9 != -1) {
                    characterIterator.next();
                }
                return n9;
            }
            case 4: {
                int n10 = n + 1;
                int n11 = characterIterator.getIndex();
                for (int i = 0; i < n3; ++i) {
                    if (characterIterator.current() != this._getChar(n10, i)) {
                        characterIterator.setIndex(n11);
                        return -1;
                    }
                    characterIterator.next();
                }
                return this.buffer.get(n10 + _NetIntegerImplBase.chain_size(n3));
            }
            case 8: {
                return n3 > 0 ? this.buffer.get(n + 1 + 1) : -1;
            }
            case 6: {
                return this.buffer.get(n + 1 + 1);
            }
            case 5: {
                return -1;
            }
        }
        return -1;
    }

    int next_restricted(int n, CharacterIterator characterIterator, int n2) {
        int n3 = this.getCode(n);
        int n4 = this._getN(n3);
        int n5 = characterIterator.getIndex();
        switch (this._getType(n3)) {
            case 1: {
                int n6 = this._linearSearch(n + 1, characterIterator.current(), n4);
                if (n6 >= 0 && n5 < n2) {
                    int n7 = n + 1 + _NetIntegerImplBase.search_table_size(n4);
                    characterIterator.next();
                    return this.buffer.get(n7 + n6);
                }
                return -1;
            }
            case 2: {
                int n8 = this._binarySearch(n + 1, characterIterator.current(), n4);
                if (n8 >= 0 && n5 < n2) {
                    int n9 = n + 1 + _NetIntegerImplBase.search_table_size(n4);
                    characterIterator.next();
                    return this.buffer.get(n9 + n8);
                }
                return -1;
            }
            case 3: {
                if (n5 >= n2) {
                    return -1;
                }
                int n10 = this.buffer.get(n + 1 + characterIterator.current());
                if (n10 != -1) {
                    characterIterator.next();
                }
                return n10;
            }
            case 4: {
                int n11;
                int n12 = n + 1;
                int n13 = n2 - n5;
                if (n13 < n4) {
                    return -1;
                }
                for (n11 = 0; n11 < n4 && n11 < n13; ++n11) {
                    if (characterIterator.current() != this._getChar(n12, n11)) {
                        characterIterator.setIndex(n5);
                        return -1;
                    }
                    characterIterator.next();
                }
                return n11 == n4 ? this.buffer.get(n12 + _NetIntegerImplBase.chain_size(n4)) : -1;
            }
            case 8: {
                return n4 > 0 ? this.buffer.get(n + 1 + 1) : -1;
            }
            case 6: {
                return this.buffer.get(n + 1 + 1);
            }
            case 5: {
                return -1;
            }
        }
        return -1;
    }

    int next_recommended_type(int n, int n2) {
        int n3 = this.num_trans(n) + n2;
        if (n3 <= 8) {
            return 1;
        }
        if (n3 < 6553) {
            return 2;
        }
        return 3;
    }

    int num_entries(int n) {
        int n2 = this.getCode(n);
        switch (this._getType(n2)) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                return this._getN(n2);
            }
            case 6: {
                return 1;
            }
            case 5: {
                return 0;
            }
            case 3: {
                int n3 = this._getN(n2);
                return n3 != 0 ? n3 : 65536;
            }
        }
        return 0;
    }

    int num_trans(int n) {
        int n2 = this.getCode(n);
        switch (this._getType(n2)) {
            case 1: 
            case 2: 
            case 8: {
                return this._getN(n2);
            }
            case 4: 
            case 6: {
                return 1;
            }
            case 5: {
                return 0;
            }
            case 3: {
                return 65536;
            }
        }
        return 0;
    }

    int num_chars(int n) {
        int n2 = this.getCode(n);
        switch (this._getType(n2)) {
            case 1: 
            case 2: 
            case 3: {
                return 1;
            }
            case 4: {
                return this.getN(n);
            }
            case 5: 
            case 6: 
            case 8: {
                return 0;
            }
        }
        return 0;
    }

    int get_trans(int n, int n2) {
        int n3 = this.getCode(n);
        int n4 = this._getN(n3);
        switch (this._getType(n3)) {
            case 1: 
            case 2: {
                return this.buffer.get(n + 1 + _NetIntegerImplBase.search_table_size(n4) + n2);
            }
            case 3: {
                return this.buffer.get(n + 1 + n2);
            }
            case 4: {
                return this.buffer.get(n + 1 + _NetIntegerImplBase.chain_size(n4));
            }
            case 5: {
                return -1;
            }
            case 6: {
                return n2 == 0 ? this.buffer.get(n + 2) : -1;
            }
            case 8: {
                return this.buffer.get(n + 1 + n2);
            }
        }
        return -1;
    }

    private char _getChar(int n, int n2) {
        int n3 = this.buffer.get(n + (n2 >>> 1));
        return (n2 & 1) == 0 ? (char)(n3 >>> 16) : (char)(n3 & 0xFFFF);
    }

    private int _getPtr(int n, int n2) {
        return this.buffer.get(n + n2);
    }

    void _setChar(int n, int n2, char c) {
        this.buffer.putChar(n + (n2 >>> 1), (n2 & 1) == 0, c);
    }

    void _setPtr(int n, int n2, int n3) {
        this.buffer.put(n + n2, n3);
    }

    char get_char(int n, int n2) {
        int n3 = this.getCode(n);
        int n4 = this._getN(n3);
        switch (this._getType(n3)) {
            case 1: 
            case 2: 
            case 4: {
                return this._getChar(n + 1, n2);
            }
            case 3: {
                return (char)n2;
            }
            case 5: 
            case 6: 
            case 8: {
                return '\u0000';
            }
        }
        return '\u0000';
    }

    void set_char(int n, int n2, char c) {
        int n3 = this.getCode(n);
        int n4 = this._getN(n3);
        switch (this._getType(n3)) {
            case 1: 
            case 2: 
            case 4: {
                this._setChar(n + 1, n2, c);
                break;
            }
        }
    }

    String get_chars(int n, int n2) {
        int n3 = this.getCode(n);
        int n4 = this._getN(n3);
        switch (this._getType(n3)) {
            case 1: 
            case 2: {
                return String.valueOf(this._getChar(n + 1, n2));
            }
            case 4: {
                StringBuffer stringBuffer = new StringBuffer(n4);
                for (int i = 0; i < n4; ++i) {
                    stringBuffer.append(this._getChar(n + 1, i));
                }
                return stringBuffer.toString();
            }
            case 3: {
                return String.valueOf((char)n2);
            }
            case 5: 
            case 6: 
            case 8: {
                return "";
            }
        }
        return "";
    }

    void set_chars(int n, CharacterIterator characterIterator, int n2, int n3) {
        int n4 = this.getCode(n);
        int n5 = this._getN(n4);
        switch (this._getType(n4)) {
            case 1: 
            case 2: {
                this._setChar(n + 1, n2, characterIterator.current());
                characterIterator.next();
                this._setPtr(n + 1 + _NetIntegerImplBase.search_table_size(n5), n2, n3);
                break;
            }
            case 3: {
                this._setPtr(n + 1, n2, n3);
                characterIterator.next();
                break;
            }
            case 4: {
                for (int i = 0; i < n5; ++i) {
                    this._setChar(n + 1, i, characterIterator.current());
                    characterIterator.next();
                }
                this._setPtr(n + 1 + _NetIntegerImplBase.chain_size(n5), 0, n3);
                break;
            }
            case 6: {
                if (n2 != 0) break;
                this._setPtr(n + 2, 0, n3);
                break;
            }
            case 8: {
                this._setPtr(n + 1, n2, n3);
                break;
            }
        }
    }

    void set_trans(int n, int n2, int n3) throws DLTException {
        int n4 = this.getCode(n);
        int n5 = this._getN(n4);
        switch (this._getType(n4)) {
            case 1: 
            case 2: {
                this._setPtr(n + 1 + _NetIntegerImplBase.search_table_size(n5), n2, n3);
                break;
            }
            case 3: {
                this._setPtr(n + 1, n2, n3);
                break;
            }
            case 4: {
                this._setPtr(n + 1 + _NetIntegerImplBase.chain_size(n5), 0, n3);
                break;
            }
            case 6: {
                if (n2 != 0) break;
                this._setPtr(n + 2, 0, n3);
                break;
            }
            case 8: {
                this._setPtr(n + 1, n2, n3);
                break;
            }
            default: {
                throw new DLTException(Messages.getString("cannot.settrans"));
            }
        }
    }

    int match(int n, CharacterIterator characterIterator) {
        int n2;
        int n3 = characterIterator.getIndex();
        int n4 = this.getCode(n);
        int n5 = Math.min(this._getN(n4), characterIterator.getEndIndex() - n3);
        int n6 = n + 1;
        for (n2 = 0; n2 < n5 && characterIterator.current() == this._getChar(n6, n2); ++n2) {
            characterIterator.next();
        }
        characterIterator.setIndex(n3);
        return n2;
    }

    private int _linearSearch(int n, char c, int n2) {
        int n3 = n2 >>> 1;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.buffer.get(n + i);
            if (n4 >>> 16 == c) {
                return i << 1;
            }
            if ((n4 & 0xFFFF) != c) continue;
            return (i << 1) + 1;
        }
        if ((n2 & 1) == 1 && this._getChar(n, n2 - 1) == c) {
            return n2 - 1;
        }
        return -1;
    }

    private int _binarySearch(int n, char c, int n2) {
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >> 1;
            char c2 = this._getChar(n, n5);
            if (c2 < c) {
                n3 = n5 + 1;
                continue;
            }
            if (c2 > c) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    private void _addOne(int n, int n2, int n3, int n4, char n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10 = n4 + 1 + 1 >>> 1;
        if ((n3 & 1) == 0) {
            n9 = n5;
            for (n8 = n3 >>> 1; n8 < n10; ++n8) {
                n7 = this.buffer.get(n + n8);
                this.buffer.put(n + n8, n7 >>> 16 | n9 << 16);
                n9 = n7;
            }
        } else {
            n9 = n3 >>> 1;
            n7 = n8 = this.buffer.get(n + n9);
            n8 = n8 & 0xFFFF0000 | n5;
            this.buffer.put(n + n9, n8);
            ++n9;
            while (n9 < n10) {
                n8 = this.buffer.get(n + n9);
                this.buffer.put(n + n9, n8 >>> 16 | n7 << 16);
                n7 = n8;
                ++n9;
            }
        }
        for (n9 = n4; n9 > n3; --n9) {
            this.buffer.put(n2 + n9, this.buffer.get(n2 + n9 - 1));
        }
        this.buffer.put(n2 + n3, n6);
    }

    int addChar(int n, char c, int n2, int n3) throws DLTException {
        int n4 = this.getCode(n);
        int n5 = this._getN(n4);
        switch (this._getType(n4)) {
            case 1: {
                this._setChar(n + 1, n5, c);
                int n6 = n + 1 + _NetIntegerImplBase.search_table_size(n5);
                this.buffer.put(n6 + n5, n3);
                this.setCode(n, this._setN(n4, n5 + 1));
                return n5 + 1;
            }
            case 2: {
                int n7 = n + 1;
                int n8 = n7 + _NetIntegerImplBase.search_table_size(n5);
                int n9 = this._binarySearch(n7, c, n5);
                if (n9 >= 0) {
                    throw new DLTException(Messages.getString("error.call"));
                }
                n9 = -n9 - 1;
                this._addOne(n7, n8, n9, n5, c, n3);
                this.setCode(n, this._setN(n4, n5 + 1));
                return n5 + 1;
            }
            case 3: {
                this.buffer.put(n + 1 + c, n3);
                this.setCode(n, this._setN(n4, n5 + 1));
                return n5 + 1;
            }
            case 4: {
                this.buffer.put(n + 1 + _NetIntegerImplBase.chain_size(n5), n3);
                this.setCode(n, this._setN(n4, n5 + 1));
                return n5 + 1;
            }
            case 6: {
                this.buffer.put(n + 2, n3);
                return 1;
            }
        }
        return 0;
    }

    final boolean isFinal(int n) {
        int n2 = this.buffer.get(n) & 0xFF;
        return n2 == 6 || n2 == 5;
    }

    int add(int n, CharacterIterator characterIterator, int n2) throws DLTException {
        int n3 = this.getCode(n);
        int n4 = this._getN(n3);
        switch (this._getType(n3)) {
            case 1: {
                this._setChar(n + 1, n4, characterIterator.current());
                characterIterator.next();
                int n5 = n + 1 + _NetIntegerImplBase.search_table_size(n4);
                this.buffer.put(n5 + n4, n2);
                this.setCode(n, this._setN(n3, n4 + 1));
                return n4 + 1;
            }
            case 2: {
                int n6 = n + 1;
                int n7 = n6 + _NetIntegerImplBase.search_table_size(n4);
                char c = characterIterator.current();
                characterIterator.next();
                int n8 = this._binarySearch(n6, c, n4);
                if (n8 >= 0) {
                    throw new DLTException(Messages.getString("error.call"));
                }
                n8 = -n8 - 1;
                this._addOne(n6, n7, n8, n4, c, n2);
                this.setCode(n, this._setN(n3, n4 + 1));
                return n4 + 1;
            }
            case 3: {
                char c = characterIterator.current();
                characterIterator.next();
                this.buffer.put(n + 1 + c, n2);
                this.setCode(n, this._setN(n3, n4 + 1));
                return n4 + 1;
            }
        }
        throw new DLTException(Messages.getString("notimplement"));
    }

    boolean replace(int n, CharacterIterator characterIterator, int n2, int n3) throws DLTException {
        int n4 = this.getCode(n);
        int n5 = this._getN(n4);
        switch (this._getType(n4)) {
            case 1: {
                int n6 = this._linearSearch(n + 1, characterIterator.current(), n5);
                if (n6 >= 0) {
                    int n7 = n + 1 + _NetIntegerImplBase.search_table_size(n5);
                    characterIterator.next();
                    this.buffer.put(n7 + n6, n3);
                    return true;
                }
                throw new DLTException(Messages.getString("cannot.replaceentry"));
            }
            case 2: {
                int n8 = this._binarySearch(n + 1, characterIterator.current(), n5);
                if (n8 >= 0) {
                    int n9 = n + 1 + _NetIntegerImplBase.search_table_size(n5);
                    characterIterator.next();
                    this.buffer.put(n9 + n8, n3);
                    return true;
                }
                throw new DLTException(Messages.getString("cannot.replaceentry"));
            }
            case 3: {
                int n10 = n + 1 + characterIterator.current();
                int n11 = this.buffer.get(n10);
                if (n11 != -1) {
                    characterIterator.next();
                    this.buffer.put(n10, n3);
                    return true;
                }
                throw new DLTException(Messages.getString("cannot.replaceentry"));
            }
            case 4: {
                int n12 = n + 1;
                int n13 = characterIterator.getIndex();
                for (int i = 0; i < n5; ++i) {
                    if (characterIterator.current() != this._getChar(n12, i)) {
                        characterIterator.setIndex(n13);
                        throw new DLTException(Messages.getString("cannot.replaceentry"));
                    }
                    characterIterator.next();
                }
                this.buffer.put(n12 + _NetIntegerImplBase.chain_size(n5), n3);
                return true;
            }
            case 8: {
                throw new DLTException(Messages.getString("cannot.replaceentry"));
            }
            case 6: {
                if (characterIterator.getIndex() < n2) {
                    this.buffer.put(n + 1 + 1, n3);
                    return true;
                }
                throw new DLTException(Messages.getString("cannot.replaceentry"));
            }
            case 5: {
                throw new DLTException(Messages.getString("cannot.addtransition"));
            }
        }
        throw new DLTException(Messages.getString("cannot.addlink"));
    }

    int removeChar(int n, char c, int n2) throws DLTException {
        throw new IllegalStateException(Messages.getString("notimplement.method"));
    }

    int remove(int n, CharacterIterator characterIterator, int n2, int n3) throws DLTException {
        throw new IllegalStateException(Messages.getString("notimplement.method"));
    }

    /*
     * WARNING - void declaration
     */
    void copy_add(int n, int n2, CharacterIterator characterIterator, int n3) throws DLTException {
        int n4 = this.getCode(n);
        int n5 = this.getCode(n2);
        int n6 = this._getN(n5);
        int n7 = this._getN(n4);
        switch (this._getType(n4)) {
            case 1: {
                int n8 = n + 1 + _NetIntegerImplBase.search_table_size(n7);
                switch (this._getType(n5)) {
                    case 1: 
                    case 2: {
                        int n9;
                        int n10 = _NetIntegerImplBase.search_table_size(n6);
                        int n11 = n2 + 1 + n10;
                        for (n9 = 0; n9 < n10; ++n9) {
                            this.buffer.put(n + 1 + n9, this.buffer.get(n2 + 1 + n9));
                        }
                        for (n9 = 0; n9 < n6; ++n9) {
                            this.buffer.put(n8 + n9, this.buffer.get(n11 + n9));
                        }
                        break;
                    }
                    case 3: {
                        boolean n12 = false;
                        for (int i = 0; i < 65536; ++i) {
                            void c;
                            int n10 = this.buffer.get(n2 + 1 + i);
                            if (n10 == -1) continue;
                            this._setChar(n + 1, (int)c, (char)i);
                            this.buffer.put(n8 + c, this.buffer.get(n2 + 1 + i));
                            ++c;
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(Messages.getString("cannot.copy"));
                    }
                }
                this._setChar(n + 1, n6, characterIterator.current());
                this._setPtr(n8, n6, n3);
                characterIterator.next();
                break;
            }
            case 2: {
                int n11;
                int n15 = n + 1;
                int n16 = n15 + _NetIntegerImplBase.search_table_size(n7);
                switch (this._getType(n5)) {
                    case 1: {
                        int n23 = n2 + 1;
                        n11 = _NetIntegerImplBase.search_table_size(n6);
                        int n12 = n2 + 1 + n11;
                        for (int i = 0; i < n6; ++i) {
                            char c = this._getChar(n23, i);
                            int n13 = this._getPtr(n12, i);
                            int n14 = this._binarySearch(n15, c, i);
                            if (n14 >= 0) {
                                throw new DLTException(Messages.getString("error.call"));
                            }
                            n14 = -n14 - 1;
                            this._addOne(n15, n16, n14, i, c, n13);
                        }
                        break;
                    }
                    case 2: {
                        int n17;
                        int i = _NetIntegerImplBase.search_table_size(n6);
                        n11 = n2 + 1 + i;
                        for (n17 = 0; n17 < i; ++n17) {
                            this.buffer.put(n + 1 + n17, this.buffer.get(n2 + 1 + n17));
                        }
                        for (n17 = 0; n17 < n6; ++n17) {
                            this.buffer.put(n16 + n17, this.buffer.get(n11 + n17));
                        }
                        break;
                    }
                    case 3: {
                        void var11_22;
                        boolean bl = false;
                        n11 = 0;
                        while (var11_22 < 65536) {
                            int n18 = this.buffer.get(n2 + 1 + var11_22);
                            if (n18 != -1) {
                                this._setChar(n15, n11, (char)var11_22);
                                this._setPtr(n16, n11, n18);
                                if (++n11 > n6) {
                                    throw new UnsupportedOperationException(Messages.getString("node.format"));
                                }
                            }
                            ++var11_22;
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(Messages.getString("cannot.copy"));
                    }
                }
                char c = characterIterator.current();
                characterIterator.next();
                n11 = this._binarySearch(n15, c, n6);
                if (n11 >= 0) {
                    throw new DLTException(Messages.getString("error.call"));
                }
                n11 = -n11 - 1;
                this._addOne(n15, n16, n11, n7, c, n3);
                break;
            }
            case 3: {
                int n21;
                int n22 = n + 1;
                switch (this._getType(n5)) {
                    case 1: 
                    case 2: {
                        n21 = _NetIntegerImplBase.search_table_size(n6);
                        int n19 = n2 + 1 + n21;
                        for (int i = 0; i < n6; ++i) {
                            char c = this._getChar(n2 + 1, i);
                            int n20 = this._getPtr(n19, i);
                            this._setPtr(n22, c, n20);
                        }
                        break;
                    }
                    case 3: {
                        void var11_27;
                        n21 = n2 + 1;
                        boolean bl = false;
                        while (var11_27 < 65536) {
                            this._setPtr(n22, (int)var11_27, this._getPtr(n21, (int)var11_27));
                            ++var11_27;
                        }
                        break;
                    }
                    default: {
                        throw new DLTException(Messages.getString("notimplement"));
                    }
                }
                n21 = characterIterator.current();
                characterIterator.next();
                this._setPtr(n22, n21, n3);
                break;
            }
            default: {
                throw new DLTException(Messages.getString("notimplement"));
            }
        }
    }

    int getGlossIdx(int n) {
        return this.buffer.get(n + 1);
    }

    void setGlossIdx(int n, int n2) {
        this.buffer.put(n + 1, n2);
    }

    int allocate(int n, int n2) {
        this.alloc_size += n;
        int n3 = this.allocate_existing(n);
        if (n3 != -1) {
            return n3;
        }
        if (this.alloc_pos + n > this.buffer.capacity()) {
            this.reallocate(n);
        }
        if (n2 != -1) {
            // empty if block
        }
        n3 = this.alloc_pos;
        this.alloc_pos += n;
        ++this.numNodes;
        return n3;
    }

    private void reallocate(int n) {
        if (n <= 0) {
            n = 16386;
        }
        int n2 = this.buffer.capacity();
        int n3 = this.alloc_pos - n2 + n;
        int n4 = n2 + Math.max(n3, 262144);
        this.buffer.setCapacity(n4);
    }

    private int allocate_existing(int n) {
        int n2;
        int n3 = n;
        int n4 = -1;
        if (n < 32) {
            for (n2 = n; n2 < 32; ++n2) {
                if (this.best_fit[n2] == -1) continue;
                n4 = this.best_fit[n2];
                this.best_fit[n2] = this.buffer.get(n4 + 1);
                n3 = n2;
                break;
            }
        } else {
            n2 = this.assorted_sizes;
            int n5 = -1;
            for (int i = 0; n2 != -1 && i < 128; ++i) {
                n3 = this.getN(n2);
                if (n3 >= n) {
                    n4 = n2;
                    if (i > 0) {
                        this.buffer.put(n5 + 1, this.buffer.get(n2 + 1));
                    } else {
                        this.assorted_sizes = this.buffer.get(n2 + 1);
                    }
                    break;
                }
                n5 = n2;
                n2 = this.buffer.get(n2 + 1);
            }
        }
        if (n4 == -1) {
            return -1;
        }
        if (n3 > n) {
            n2 = n3 - n;
            if (n2 > 1) {
                this.deallocateSpace(n4 + n, n2);
            } else {
                this.buffer.put(n4 + n, 0xFE | n2 << 8);
                this.alloc_buddy += n2;
            }
        }
        return n4;
    }

    public boolean verifyFreeMemory() {
        int n;
        int n2;
        int n3;
        int n4 = this.alloc_buddy;
        for (n3 = 0; n3 < 32; ++n3) {
            n2 = 0;
            n = this.best_fit[n3];
            while (n != -1) {
                ++n2;
                n4 += n3;
                n = this.buffer.get(n + 1);
            }
        }
        n3 = 0;
        n2 = 0;
        n = this.assorted_sizes;
        while (n != -1) {
            ++n3;
            n2 += this.getN(n);
            n = this.buffer.get(n + 1);
        }
        return this.alloc_pos - this.alloc_size - (n4 += n2) == 0;
    }

    void deallocate(int n) {
        int n2 = this.getCode(n);
        int n3 = this.size_up_node(this._getType(n2), this._getN(n2));
        this.alloc_size -= n3;
        if (this.getType(n + n3) == 254) {
            int n4 = this.getN(n + n3);
            n3 += n4;
            this.alloc_buddy -= n4;
        }
        this.deallocateSpace(n, n3);
        --this.numNodes;
    }

    private void deallocateSpace(int n, int n2) {
        this.buffer.put(n, 0xFF | n2 << 8);
        if (n2 < 32) {
            int n3 = this.best_fit[n2];
            this.best_fit[n2] = n;
            this.buffer.put(n + 1, n3);
        } else {
            int n4 = this.assorted_sizes;
            this.assorted_sizes = n;
            this.buffer.put(n + 1, n4);
        }
    }

    private static int search_table_size(int n) {
        return n > 0 ? n + 1 >>> 1 : 1;
    }

    private static int search_transition_table_size(int n) {
        return (n > 0 ? n + 1 >>> 1 : 1) << 1;
    }

    private static int chain_size(int n) {
        return n > 0 ? n + 1 >>> 1 : 1;
    }

    int size_up_node(int n, int n2) {
        switch (n) {
            case 1: 
            case 2: {
                return 1 + _NetIntegerImplBase.search_table_size(n2) + _NetIntegerImplBase.search_transition_table_size(n2);
            }
            case 3: {
                return 65537;
            }
            case 4: {
                return 1 + _NetIntegerImplBase.chain_size(n2) + 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
            case 8: {
                return 1 + n2;
            }
        }
        return Integer.MIN_VALUE;
    }

    void instantiate_node(int n, int n2, int n3) {
        this.buffer.put(n, this._setN(n2, n3));
        switch (n2) {
            case 1: 
            case 2: {
                int n4;
                int n5 = _NetIntegerImplBase.search_table_size(n3);
                for (n4 = 0; n4 < n5; ++n4) {
                    this.buffer.put(n + 1 + n4, 0);
                }
                n4 = n + 1 + n5;
                for (int i = 0; i < n3; ++i) {
                    this.buffer.put(n4 + i, -1);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 65536; ++i) {
                    this.buffer.put(n + 1 + i, -1);
                }
                break;
            }
            case 4: {
                int n6 = _NetIntegerImplBase.chain_size(n3);
                for (int i = 0; i < n6; ++i) {
                    this.buffer.put(n + 1 + i, 0);
                }
                this.buffer.put(n + 1 + _NetIntegerImplBase.chain_size(n3), -1);
                break;
            }
            case 5: {
                this.buffer.put(n + 1, -1);
                break;
            }
            case 6: {
                this.buffer.put(n + 1, -1);
                this.buffer.put(n + 1 + 1, -1);
                break;
            }
            case 8: {
                break;
            }
        }
    }

    int new_node(int n, int n2) {
        int n3 = this.size_up_node(n, n2);
        int n4 = this.allocate(n3, -1);
        this.instantiate_node(n4, n, n2);
        return n4;
    }

    protected long read_contents(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        int n2 = dataInputStream.readInt();
        if (n2 != -1161904401) {
            throw new DLTException(Messages.getString("error.dict.format"));
        }
        this.reset();
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        if (n3 < 0 || n4 < 0) {
            throw new DLTException(Messages.getString("error.dict.format"));
        }
        this.enchain = (n5 & 1) != 0;
        this.contracted = (n5 & 2) != 0;
        this.reallocate(n + n / 8);
        this.read_nodes(dataInputStream, n3);
        this.first_node = 0;
        return n4;
    }

    private int read_nodes(DataInputStream dataInputStream, int n) throws IOException, DLTException {
        int n2;
        int n3;
        int n4;
        int n5;
        if (n <= 0) {
            throw new DLTException(Messages.getString("error.dict.format"));
        }
        int[] nArray = new int[n];
        for (n5 = 0; n5 < n; ++n5) {
            n4 = dataInputStream.readByte();
            n3 = dataInputStream.readByte();
            dataInputStream.readByte();
            dataInputStream.readByte();
            if (n4 == 2) {
                n2 = dataInputStream.readShort() & 0xFFFF;
            } else if (n4 == 1) {
                n2 = dataInputStream.readByte() & 0xFFFF;
            } else {
                throw new DLTException(Messages.format("node.charsize", n4));
            }
            if (n3 <= 0 || n3 >= 9) {
                throw new DLTException(Messages.getString("error.dict.format"));
            }
            nArray[n5] = this.readNode(dataInputStream, n4, n3, n2);
        }
        block9: for (n5 = 0; n5 < n; ++n5) {
            n4 = nArray[n5];
            n3 = this.getCode(n4);
            n2 = this._getType(n3);
            int n6 = this._getN(n3);
            switch (n2) {
                case 1: 
                case 2: {
                    int n7;
                    int n8;
                    int n9 = n4 + 1 + _NetIntegerImplBase.search_table_size(n6);
                    for (n8 = 0; n8 < n6; ++n8) {
                        n7 = this.buffer.get(n9 + n8);
                        this.buffer.put(n9 + n8, nArray[n7]);
                    }
                    continue block9;
                }
                case 3: {
                    int n7;
                    int n8;
                    int n9 = n4 + 1;
                    for (n8 = 0; n8 < 65536; ++n8) {
                        n7 = this.buffer.get(n9 + n8);
                        if (n7 == -1) continue;
                        this.buffer.put(n9 + n8, nArray[n7]);
                    }
                    continue block9;
                }
                case 4: {
                    int n9 = n4 + 1 + _NetIntegerImplBase.chain_size(n6);
                    int n8 = this.buffer.get(n9);
                    this.buffer.put(n9, nArray[n8]);
                    continue block9;
                }
                case 5: {
                    continue block9;
                }
                case 6: {
                    int n9 = n4 + 2;
                    int n8 = this.buffer.get(n9);
                    this.buffer.put(n9, nArray[n8]);
                    continue block9;
                }
                case 8: {
                    int n7;
                    int n8;
                    int n9 = n4 + 1;
                    for (n8 = 0; n8 < n6; ++n8) {
                        n7 = this.buffer.get(n9 + n8);
                        this.buffer.put(n9 + n8, nArray[n7]);
                    }
                    continue block9;
                }
                default: {
                    throw new DLTException(Messages.format("node.type", n2));
                }
            }
        }
        return n;
    }

    int readNode(DataInputStream dataInputStream, int n, int n2, int n3) throws IOException, DLTException {
        if (n != 2 && n2 != 5 && n2 != 6) {
            throw new DLTException(Messages.format("node.typecharsize", n2, n));
        }
        int n4 = this.new_node(n2, n3);
        switch (n2) {
            case 1: 
            case 2: {
                int n5;
                int n6;
                for (n6 = 0; n6 < n3; ++n6) {
                    n5 = n == 2 ? (int)dataInputStream.readShort() : (int)dataInputStream.readByte();
                    this._setChar(n4 + 1, n6, (char)n5);
                }
                n6 = n4 + 1 + _NetIntegerImplBase.search_table_size(n3);
                for (n5 = 0; n5 < n3; ++n5) {
                    int n7 = dataInputStream.readInt();
                    this.buffer.put(n6 + n5, n7);
                }
                break;
            }
            case 3: {
                int n8;
                int n9 = n4 + 1;
                int n10 = 0;
                int n11 = n8 = n3 == 65535 ? 65535 : 65536;
                for (int i = 0; i < 65536; ++i) {
                    int n12 = dataInputStream.readInt();
                    this.buffer.put(n9 + i, n12);
                    if (n12 == -1) continue;
                    ++n10;
                }
                this.setCode(n4, this._setN(this.getCode(n4), n10));
                break;
            }
            case 4: {
                char c;
                int n13;
                for (n13 = 0; n13 < n3; ++n13) {
                    c = n == 2 ? (char)dataInputStream.readShort() : (char)dataInputStream.readByte();
                    this._setChar(n4 + 1, n13, c);
                }
                n13 = dataInputStream.readInt();
                c = n4 + 1 + _NetIntegerImplBase.chain_size(n3);
                this.buffer.put(c, n13);
                break;
            }
            case 5: {
                int n14 = dataInputStream.readInt();
                this.setGlossIdx(n4, GlossReader.decode_ordinal(n14));
                break;
            }
            case 6: {
                int n15 = dataInputStream.readInt();
                int n16 = dataInputStream.readInt();
                this.setGlossIdx(n4, GlossReader.decode_ordinal(n16));
                this.buffer.put(n4 + 1 + 1, n15);
                break;
            }
            case 8: {
                int n17 = n4 + 1;
                for (int i = 0; i < n3; ++i) {
                    int n18 = dataInputStream.readInt();
                    this.buffer.put(n17 + i, n18);
                }
                break;
            }
            default: {
                throw new DLTException(Messages.format("node.type", n2));
            }
        }
        return n4;
    }

    private boolean verifyLSearch(int n) {
        return true;
    }

    private boolean verifyBSearch(int n) {
        return true;
    }

    private boolean verifyTable(int n) {
        return true;
    }

    boolean treesEqual(int n, int n2) {
        if (n == n2) {
            return true;
        }
        if (n == -1 || n2 == -1) {
            return false;
        }
        int n3 = this.getCode(n);
        int n4 = this.getCode(n2);
        int n5 = this._getN(n3);
        int n6 = this._getN(n4);
        switch (this._getType(n3)) {
            case 1: {
                if (n5 != n6) {
                    return false;
                }
                switch (this._getType(n4)) {
                    case 1: 
                    case 2: 
                    case 3: {
                        int n7 = n + 1 + _NetIntegerImplBase.search_table_size(n5);
                        for (int i = 0; i < n5; ++i) {
                            int n8;
                            char c = this._getChar(n + 1, i);
                            int n9 = this._getPtr(n7, i);
                            if (this.treesEqual(n9, n8 = this.next(n2, c))) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                if (n5 != n6) {
                    return false;
                }
                switch (this._getType(n4)) {
                    case 2: {
                        int n10;
                        int n11 = _NetIntegerImplBase.search_table_size(n5);
                        for (n10 = 0; n10 < n11; ++n10) {
                            if (!((n5 & 1) == 0 || n10 < n11 - 1 ? this.buffer.get(n + 1 + n10) != this.buffer.get(n2 + 1 + n10) : (0xFFFF0000 & this.buffer.get(n + 1 + n10)) != (0xFFFF0000 & this.buffer.get(n2 + 1 + n10)))) continue;
                            return false;
                        }
                        n10 = n + 1 + n11;
                        int n12 = n2 + 1 + n11;
                        for (int i = 0; i < n5; ++i) {
                            if (this.treesEqual(this._getPtr(n10, i), this._getPtr(n12, i))) continue;
                            return false;
                        }
                        return true;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        return this.treesEqual(n2, n);
                    }
                }
                return false;
            }
            case 3: {
                if (n5 != n6) {
                    return false;
                }
                switch (this._getType(n4)) {
                    case 3: {
                        for (int i = 0; i < 65536; ++i) {
                            if (this.treesEqual(this.buffer.get(n + 1 + i), this.buffer.get(n2 + 1 + i))) continue;
                            return false;
                        }
                        return true;
                    }
                    case 1: 
                    case 2: {
                        int n13 = _NetIntegerImplBase.search_table_size(n6);
                        for (int i = 0; i < n6; ++i) {
                            char c = this._getChar(n2 + 1, i);
                            if (this.treesEqual(this.buffer.get(n + 1 + c), this.buffer.get(n2 + 1 + n13 + i))) continue;
                            return false;
                        }
                        return true;
                    }
                    case 4: {
                        return this.treesEqual(n2, n);
                    }
                }
                return false;
            }
            case 4: {
                switch (this._getType(n4)) {
                    case 4: {
                        if (n5 != n6) {
                            return false;
                        }
                        int n14 = _NetIntegerImplBase.chain_size(n5);
                        for (int i = 0; i < n14; ++i) {
                            if (!(i != n14 - 1 || (n5 & 1) == 0 ? this.buffer.get(n + 1 + i) != this.buffer.get(n2 + 1 + i) : (0xFFFF0000 & this.buffer.get(n + 1 + i)) != (0xFFFF0000 & this.buffer.get(n2 + 1 + i)))) continue;
                            return false;
                        }
                        return this.treesEqual(this.buffer.get(n + 1 + n14), this.buffer.get(n2 + 1 + n14));
                    }
                    case 1: 
                    case 2: {
                        if (n5 == 1 && n6 == 1) {
                            char c = this._getChar(n + 1, 0);
                            if (this.treesEqual(this.buffer.get(n + 1 + _NetIntegerImplBase.chain_size(n5)), this.get_trans(n2, 0))) {
                                return true;
                            }
                        }
                        return false;
                    }
                    case 3: {
                        if (n5 == 1 && n6 == 1) {
                            char c = this._getChar(n + 1, 0);
                            if (this.treesEqual(this.buffer.get(n + 1 + _NetIntegerImplBase.chain_size(n5)), this.get_trans(n2, c))) {
                                return true;
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
            case 5: {
                return this._getType(n4) == 5 && this.glossesEqual(this.buffer.get(n + 1), this.buffer.get(n2 + 1));
            }
            case 6: {
                return this._getType(n4) == 6 && this.glossesEqual(this.buffer.get(n + 1), this.buffer.get(n2 + 1)) && this.treesEqual(this._getPtr(n + 2, 0), this._getPtr(n2 + 2, 0));
            }
            case 8: {
                if (this._getType(n4) == 8) {
                    if (n5 != n6) {
                        return false;
                    }
                    for (int i = 0; i < n5; ++i) {
                        if (this.treesEqual(this._getPtr(n + 1, i), this._getPtr(n2 + 1, i))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    boolean glossesEqual(int n, int n2) {
        return n == n2;
    }

    int glossHash(int n) {
        return n + 17;
    }

    boolean nodeEqualByContents(int n, int n2) {
        if (n == n2) {
            return true;
        }
        int n3 = this.getCode(n);
        int n4 = this.getCode(n2);
        int n5 = this._getN(n3);
        int n6 = this._getN(n4);
        switch (this._getType(n3)) {
            case 1: {
                if (n5 != n6) {
                    return false;
                }
                switch (this._getType(n4)) {
                    case 1: 
                    case 2: 
                    case 3: {
                        int n7 = n + 1 + _NetIntegerImplBase.search_table_size(n5);
                        for (int i = 0; i < n5; ++i) {
                            char c = this._getChar(n + 1, i);
                            int n8 = this._getPtr(n7, i);
                            int n9 = this.next(n2, c);
                            if (n9 == n8) continue;
                            return false;
                        }
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                if (n5 != n6) {
                    return false;
                }
                switch (this._getType(n4)) {
                    case 2: {
                        int n10;
                        int n11 = _NetIntegerImplBase.search_table_size(n5);
                        for (n10 = 0; n10 < n11; ++n10) {
                            if (!((n5 & 1) == 0 || n10 < n11 - 1 ? this.buffer.get(n + 1 + n10) != this.buffer.get(n2 + 1 + n10) : (0xFFFF0000 & this.buffer.get(n + 1 + n10)) != (0xFFFF0000 & this.buffer.get(n2 + 1 + n10)))) continue;
                            return false;
                        }
                        n10 = n + 1 + n11;
                        int n12 = n2 + 1 + n11;
                        for (int i = 0; i < n5; ++i) {
                            if (this._getPtr(n10, i) == this._getPtr(n12, i)) continue;
                            return false;
                        }
                        return true;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        return this.nodeEqualByContents(n2, n);
                    }
                }
                return false;
            }
            case 3: {
                if (n5 != n6) {
                    return false;
                }
                switch (this._getType(n4)) {
                    case 3: {
                        for (int i = 0; i < 65536; ++i) {
                            if (this.buffer.get(n + 1 + i) == this.buffer.get(n2 + 1 + i)) continue;
                            return false;
                        }
                        return true;
                    }
                    case 1: 
                    case 2: {
                        int n13 = _NetIntegerImplBase.search_table_size(n6);
                        for (int i = 0; i < n6; ++i) {
                            char c = this._getChar(n2 + 1, i);
                            if (this.buffer.get(n + 1 + c) == this.buffer.get(n2 + 1 + n13 + i)) continue;
                            return false;
                        }
                        return true;
                    }
                    case 4: {
                        return this.nodeEqualByContents(n2, n);
                    }
                }
                return false;
            }
            case 4: {
                switch (this._getType(n4)) {
                    case 4: {
                        if (n5 != n6) {
                            return false;
                        }
                        int n14 = _NetIntegerImplBase.chain_size(n5);
                        for (int i = 0; i < n14; ++i) {
                            if (!(i != n14 - 1 || (n5 & 1) == 0 ? this.buffer.get(n + 1 + i) != this.buffer.get(n2 + 1 + i) : (0xFFFF0000 & this.buffer.get(n + 1 + i)) != (0xFFFF0000 & this.buffer.get(n2 + 1 + i)))) continue;
                            return false;
                        }
                        return this.buffer.get(n + 1 + n14) == this.buffer.get(n2 + 1 + n14);
                    }
                    case 1: 
                    case 2: {
                        if (n5 == 1 && n6 == 1) {
                            char c = this._getChar(n + 1, 0);
                            if (this.buffer.get(n + 1 + _NetIntegerImplBase.chain_size(n5)) == this.get_trans(n2, 0)) {
                                return true;
                            }
                        }
                        return false;
                    }
                    case 3: {
                        if (n5 == 1 && n6 == 1) {
                            char c = this._getChar(n + 1, 0);
                            if (this.buffer.get(n + 1 + _NetIntegerImplBase.chain_size(n5)) == this.get_trans(n2, c)) {
                                return true;
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
            case 5: {
                return this._getType(n4) == 5 && this._getPtr(n + 1, 0) == this._getPtr(n2 + 1, 0);
            }
            case 6: {
                return this._getType(n4) == 6 && this._getPtr(n + 1, 0) == this._getPtr(n2 + 1, 0) && this._getPtr(n + 2, 0) == this._getPtr(n2 + 2, 0);
            }
            case 8: {
                if (this._getType(n4) == 8) {
                    if (n5 != n6) {
                        return false;
                    }
                    for (int i = 0; i < n5; ++i) {
                        if (this._getPtr(n + 1, i) == this._getPtr(n2 + 1, i)) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private int contractRecursively(int n, int n2, int n3) throws DLTException {
        int n4;
        if (n == -1) {
            return 0;
        }
        int n5 = this.num_trans(n);
        int n6 = 0;
        for (int i = 0; i < n5; ++i) {
            n4 = this.get_char(n, i);
            int n7 = this.get_trans(n, i);
            if (n7 == -1) continue;
            n6 += n4;
            n6 += this.contractRecursively(n7, n, i);
        }
        if (this.isFinal(n)) {
            n6 += this.glossHash(this.getGlossIdx(n));
        }
        int[] nArray = this.intHash.getBucket(n6);
        for (n4 = 0; n4 < nArray.length && nArray[n4] != -1; ++n4) {
            if (!this.treesEqual(n, nArray[n4])) continue;
            if (n2 != -1) {
                this.set_trans(n2, n3, nArray[n4]);
            }
            return n6;
        }
        this.intHash.put(n, n6);
        return n6;
    }

    public void contract() throws DLTException {
        if (this.contracted) {
            throw new DLTException(Messages.getString("cannot.contract.already"));
        }
        if (this.enchain) {
            throw new DLTException(Messages.getString("cannot.contract.enchained"));
        }
        this.intHash = new IntHash(this.numNodes > 0 ? this.numNodes : 100000);
        this.contractRecursively(this.first_ptr(), -1, 0);
        this.intHash = null;
        this.contracted = true;
    }

    protected int dupRemoveChar(int n, char c) throws DLTException {
        int n2;
        int n3 = this.getCode(n);
        int n4 = this._getN(n3);
        int n5 = this._getType(n3);
        int n6 = n + 1;
        switch (n5) {
            case 1: 
            case 2: {
                int n7 = n4 - 1;
                n2 = this.new_node(n5, n7);
                int n8 = n2 + 1;
                int n9 = n8 + _NetIntegerImplBase.search_table_size(n7);
                int n10 = n6 + _NetIntegerImplBase.search_table_size(n4);
                int n11 = 0;
                for (int i = 0; i < n4; ++i) {
                    char c2 = this._getChar(n6, i);
                    if (c2 == c) continue;
                    this._setChar(n8, n11, c2);
                    this._setPtr(n9, n11, this._getPtr(n10, i));
                    ++n11;
                }
                break;
            }
            case 3: {
                n2 = this.new_node(3, 65536);
                int n12 = n2 + 1;
                for (int i = 0; i < n4; ++i) {
                    if (i == c) continue;
                    this._setPtr(n12, i, this._getPtr(n6, i));
                }
                break;
            }
            default: {
                throw new DLTException(Messages.format("cannot.replacechar", new Integer(n5)));
            }
        }
        return n2;
    }

    private static class IntHash {
        final int[][] buckets;
        final int N;
        final int Size;

        IntHash(int n) {
            int n2;
            int n3 = n / 7;
            for (n2 = 0; n2 < bestHashSize.length && n3 > bestHashSize[n2]; ++n2) {
            }
            this.N = bestHashSize[n2];
            this.Size = n;
            this.buckets = new int[this.N][];
            for (int i = 0; i < this.N; ++i) {
                this.buckets[i] = new int[7];
                for (int j = 0; j < 7; ++j) {
                    this.buckets[i][j] = -1;
                }
            }
        }

        void put(int n, int n2) {
            int n3 = (n2 > 0 ? n2 : -n2) % this.N;
            for (int i = 0; i < this.buckets[n3].length; ++i) {
                if (this.buckets[n3][i] != -1) continue;
                this.buckets[n3][i] = n;
                if (i + 1 == this.buckets[n3].length) {
                    this.reallocRow(n3);
                }
                return;
            }
            this.reallocRow(n3);
            this.buckets[n3][i] = n;
        }

        int[] getBucket(int n) {
            int n2 = (n > 0 ? n : -n) % this.N;
            return this.buckets[n2];
        }

        private void reallocRow(int n) {
            int[] nArray = new int[this.buckets[n].length + 1];
            for (int i = 0; i < this.buckets[n].length; ++i) {
                nArray[i] = this.buckets[n][i];
            }
            nArray[this.buckets[n].length] = -1;
            this.buckets[n] = nArray;
        }
    }
}

