/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst._NetIntegerImplBase;
import com.ibm.dltj.gloss.MapperGloss;
import java.io.DataInputStream;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class _NetIntegerImpl
extends _NetIntegerImplBase
implements MultiNet {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public Node first() {
        return new NodeImpl(this.first_ptr());
    }

    public long read_contents(DataInputStream dataInputStream) throws DLTException, IOException {
        int n;
        if (dataInputStream.readInt() != -1161904401) {
            throw new DLTException(Messages.getString("error.dict.signature"));
        }
        int n2 = dataInputStream.readInt();
        dataInputStream.readInt();
        this.read_contents(dataInputStream, n2 / 4);
        int n3 = dataInputStream.readInt();
        int n4 = 0;
        for (int i = n3; i != 0; i -= n) {
            int n5;
            n = 0;
            GlossCollection glossCollection = new GlossCollection();
            int n6 = this.addGloss(glossCollection);
            while ((n5 = dataInputStream.readInt()) != -1) {
                MapperGloss mapperGloss = new MapperGloss(n5);
                glossCollection.add(mapperGloss);
                ++n;
            }
            ++n4;
        }
        n = dataInputStream.readInt();
        if (n != -84230466) {
            throw new DLTException(Messages.getString("error.marker"));
        }
        return n3;
    }

    void setGloss(int n, Object object) throws DLTException {
        this.setGlossIdx(n, this.addGloss(object));
    }

    public void setChainPolicy(boolean bl) {
        this.enchain = bl;
    }

    public boolean getChainPolicy() {
        return this.enchain;
    }

    public boolean isContracted() {
        return this.contracted;
    }

    public void processGlosses(GlossProcessor glossProcessor) throws DLTException {
        if (this.contiguous) {
            for (int i = this.first_ptr(); i < this.alloc_pos; i += this.size_up_node(this.getType(i), this.getN(i))) {
                if (!this.isFinal(i)) continue;
                Object object = this.getGlossForNode(i);
                Object object2 = glossProcessor.process(object);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    public void endReading() {
        this.contiguous = false;
    }

    public void startBuild(boolean bl) {
    }

    public int endBuild() {
        return 0;
    }

    public int remove(CharacterIterator characterIterator, int n) throws DLTException {
        int n2;
        int n3;
        int n4;
        int n5 = characterIterator.getIndex();
        int n6 = n5 + n;
        if (characterIterator.current() == '\uffff') {
            return 0;
        }
        int n7 = this.first_ptr();
        int n8 = this.first_ptr();
        int n9 = -1;
        int n10 = -1;
        int n11 = this.getType(n7);
        int n12 = -1;
        int n13 = characterIterator.getIndex();
        int n14 = n5;
        while (characterIterator.getIndex() < n6) {
            n4 = characterIterator.getIndex();
            n3 = this.next_restricted(n7, characterIterator, n6);
            if (n3 == -1) {
                return 0;
            }
            n2 = this.getType(n3);
            if (this.num_trans(n7) > 1 || n2 == 6) {
                n8 = n7;
                n13 = n4;
                n9 = n10;
                n14 = n12;
            }
            n12 = n4;
            n10 = n7;
            n7 = n3;
            n11 = n2;
        }
        if (characterIterator.getIndex() != n6 && characterIterator.current() != '\uffff') {
            return 0;
        }
        if (n11 != 6 && n11 != 5) {
            return 0;
        }
        if (n11 == 6) {
            n4 = this.get_trans(n7, 0);
            this.deallocate(n7);
            characterIterator.previous();
            this.replace(n8, characterIterator, n6, n4);
            return 1;
        }
        characterIterator.setIndex(n13);
        n4 = this.next_restricted(n8, characterIterator, n6);
        if (this.getType(n4) == 6) {
            n3 = this.getGlossIdx(n4);
            n2 = this.new_node(5, 0);
            this.setGlossIdx(n2, n3);
            characterIterator.setIndex(n13);
            this.replace(n8, characterIterator, n6, n2);
        } else {
            characterIterator.setIndex(n13);
            n3 = this.dupRemoveChar(n8, characterIterator.current());
            if (n8 == this.first_ptr()) {
                this.first_node = n3;
            } else {
                characterIterator.setIndex(n14);
                this.replace(n9, characterIterator, n6, n3);
            }
            this.deallocate(n8);
        }
        while (n4 != -1) {
            if (this.num_trans(n4) > 1) {
                throw new DLTException(Messages.getString("error.network"));
            }
            n3 = this.get_trans(n4, 0);
            this.deallocate(n4);
            n4 = n3;
        }
        return 1;
    }

    public Iterator iterator() {
        return new WordIterator();
    }

    public void removeGloss(CharacterIterator characterIterator, int n, Gloss gloss) throws DLTException {
        if (this.contracted) {
            throw new IllegalStateException(Messages.getString("wrong.call"));
        }
        int n2 = characterIterator.getIndex();
        GlossCollection glossCollection = (GlossCollection)this.get(characterIterator, n);
        if (gloss != null) {
            glossCollection.remove(gloss);
        }
        if (gloss == null || glossCollection.isEmpty()) {
            characterIterator.setIndex(n2);
            this.remove(characterIterator, n);
        }
    }

    Object getGlossByIdx(int n) {
        return new Integer(n);
    }

    Object getGlossForNode(int n) {
        return this.getGlossByIdx(this.getGlossIdx(n));
    }

    int addGloss(Object object) throws DLTException {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return n;
        }
        throw new DLTException(Messages.getString("wrong.call"));
    }

    void removeGloss(int n) {
        throw new IllegalStateException(Messages.getString("wrong.call"));
    }

    void processExisting(int n, Object object) throws DLTException {
        if (!(object instanceof Integer)) {
            throw new DLTException(Messages.getString("wrong.call"));
        }
        int n2 = (Integer)object;
        this.setGlossIdx(n, n2);
    }

    void processNew(int n, Object object) throws DLTException {
        if (!(object instanceof Integer)) {
            throw new DLTException(Messages.getString("wrong.call"));
        }
        int n2 = (Integer)object;
        this.setGlossIdx(n, n2);
    }

    public Node newNode(int n, int n2) {
        int n3 = this.new_node(n, n2);
        return new NodeImpl(n3);
    }

    public void setFirstNode(Node node) throws DLTException {
        if (!(node instanceof NodeImpl)) {
            throw new DLTException(Messages.getString("wrong.call"));
        }
        this.first_node = ((NodeImpl)node).getPNode();
    }

    protected class WordIterator
    implements Iterator {
        protected ArrayListStack stack = new ArrayListStack();
        protected boolean hasNext = false;

        protected WordIterator() {
            this.hasNext = this.propagate(_NetIntegerImpl.this.first());
        }

        protected WordIterator(String string) {
            this.hasNext = this.propagate(_NetIntegerImpl.this.first(), new StringCharacterIterator(string));
        }

        private boolean propagate(Node node) {
            if (node == null) {
                return false;
            }
            block0: while (node != null) {
                Node node2 = node;
                if (node2.isFinal()) {
                    this.stack.add(new StackElement(node, -1));
                    return true;
                }
                int n = node2.num_trans();
                node = null;
                for (int i = 0; i < n; ++i) {
                    node = node2.get_trans(i);
                    if (node == null) continue;
                    this.stack.add(new StackElement(node2, i));
                    continue block0;
                }
            }
            return false;
        }

        private boolean propagate(Node node, CharacterIterator characterIterator) {
            if (node == null) {
                return false;
            }
            block0: while (node != null) {
                int n;
                int n2;
                if (node.isFinal()) {
                    this.stack.add(new StackElement(node, -1));
                    return true;
                }
                Node node2 = node.next(characterIterator);
                if (node2 == null) {
                    n2 = node.num_trans();
                    for (n = 0; n < n2; ++n) {
                        if (node.get_trans(n) == null) continue;
                        node = node.get_trans(n);
                        this.stack.add(new StackElement(node, n));
                        continue block0;
                    }
                    continue;
                }
                n = node.num_chars();
                if (n > 1) {
                    node = node2;
                    this.stack.add(new StackElement(node, 0));
                    break;
                }
                n2 = characterIterator.previous();
                int n3 = node.num_trans();
                for (int i = 0; i < n3; ++i) {
                    if (node.get_char(i) != n2) continue;
                    node = node.get_trans(i);
                    this.stack.add(new StackElement(node, i));
                    continue block0;
                }
            }
            return true;
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        private Entry collectWord() {
            if (this.stack.isEmpty()) {
                return null;
            }
            int n = this.stack.size();
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                StackElement stackElement = (StackElement)this.stack.get(i);
                if (stackElement.n.num_chars() <= 0 || stackElement.position < 0) continue;
                stringBuffer.append(stackElement.n.get_chars(stackElement.position));
            }
            String string = stringBuffer.capacity() > stringBuffer.length() ? new String(stringBuffer.toString()) : stringBuffer.toString();
            return new Entry(string, ((StackElement)this.stack.top()).n.getGloss());
        }

        public Object next() {
            Entry entry = this.collectWord();
            int n = this.stack.size() - 1;
            while (n >= 0) {
                StackElement stackElement = (StackElement)this.stack.get(n);
                int n2 = stackElement.n.num_trans();
                while (n2 > stackElement.position + 1 || n2 == stackElement.position + 1 && stackElement.n.getGloss() != null) {
                    ++stackElement.position;
                    Node node = stackElement.n.get_trans(stackElement.position);
                    if (node == null || !this.propagate(node)) continue;
                    return entry;
                }
                this.stack.remove(n--);
            }
            if (this.stack.size() == 0) {
                this.hasNext = false;
            }
            return entry;
        }

        public void remove() {
            throw new IllegalStateException(Messages.getString("cannot.removeword"));
        }

        public final class Entry
        implements Map.Entry {
            String key;
            Object value;

            public Entry(String string, Object object) {
                this.key = string;
                this.value = object;
            }

            public Object getKey() {
                return this.key;
            }

            public Object getValue() {
                return this.value;
            }

            public Object setValue(Object object) {
                throw new UnsupportedOperationException();
            }
        }

        protected class StackElement {
            public Node n;
            public int position;

            public StackElement(Node node, int n) {
                this.n = node;
                this.position = n;
            }
        }

        protected class ArrayListStack
        extends ArrayList {
            private static final long serialVersionUID = 1L;

            protected ArrayListStack() {
            }

            public void push(Object object) {
                this.add(object);
            }

            public Object pop() {
                if (this.size() > 0) {
                    return this.remove(this.size() - 1);
                }
                return null;
            }

            public Object top() {
                if (this.size() > 0) {
                    return this.get(this.size() - 1);
                }
                return null;
            }
        }
    }

    private class NodeImpl
    implements Node {
        private int pnode;

        NodeImpl(int n) {
            this.pnode = n;
        }

        int getPNode() {
            return this.pnode;
        }

        public Node next(char c) {
            int n = _NetIntegerImpl.this.next(this.pnode, c);
            return n != -1 ? new NodeImpl(n) : null;
        }

        public Node next(CharacterIterator characterIterator) {
            int n = _NetIntegerImpl.this.next(this.pnode, characterIterator);
            return n != -1 ? new NodeImpl(n) : null;
        }

        public int num_entries() {
            return _NetIntegerImpl.this.num_entries(this.pnode);
        }

        public int num_trans() {
            return _NetIntegerImpl.this.num_trans(this.pnode);
        }

        public int num_chars() {
            return _NetIntegerImpl.this.num_chars(this.pnode);
        }

        public Node get_trans(int n) {
            int n2 = _NetIntegerImpl.this.get_trans(this.pnode, n);
            return n2 != -1 ? new NodeImpl(n2) : null;
        }

        public char get_char(int n) {
            return _NetIntegerImpl.this.get_char(this.pnode, n);
        }

        public String get_chars(int n) {
            return _NetIntegerImpl.this.get_chars(this.pnode, n);
        }

        public void set_trans(int n, Node node) throws DLTException {
            if (!(node instanceof NodeImpl)) {
                throw new IllegalStateException(Messages.getString("cannot.usefunction"));
            }
            _NetIntegerImpl.this.set_trans(this.pnode, n, ((NodeImpl)node).pnode);
        }

        public void process_glosses(GlossProcessor glossProcessor) throws DLTException {
            Object object = glossProcessor.process(_NetIntegerImpl.this.getGlossForNode(this.pnode));
            _NetIntegerImpl.this.setGloss(this.pnode, object);
        }

        public int addChar(char c, int n, Node node) throws DLTException {
            if (node instanceof NodeImpl) {
                return _NetIntegerImpl.this.addChar(this.pnode, c, n, ((NodeImpl)node).pnode);
            }
            throw new IllegalStateException(Messages.getString("cannot.usefunction"));
        }

        public int add(CharacterIterator characterIterator, int n, int n2, Node node) throws DLTException {
            if (node instanceof NodeImpl) {
                return _NetIntegerImpl.this.add(this.pnode, characterIterator, ((NodeImpl)node).pnode);
            }
            throw new IllegalStateException(Messages.getString("cannot.usefunction"));
        }

        public int removeChar(char c, int n) throws DLTException {
            return _NetIntegerImpl.this.removeChar(this.pnode, c, n);
        }

        public Node dupRemoveChar(char c) throws DLTException {
            int n = _NetIntegerImpl.this.dupRemoveChar(this.pnode, c);
            return new NodeImpl(n);
        }

        public void deallocate() {
            this.removeExistingGloss();
            _NetIntegerImpl.this.deallocate(this.pnode);
            this.pnode = -1;
        }

        private void removeExistingGloss() {
            int n;
            if (this.isFinal() && (n = _NetIntegerImpl.this.getGlossIdx(this.pnode)) >= 0) {
                _NetIntegerImpl.this.removeGloss(n);
            }
        }

        public boolean isFinal() {
            int n = _NetIntegerImpl.this.getType(this.pnode);
            return n == 5 || n == 6;
        }

        public void copy(Node node) throws DLTException {
            if (node instanceof NodeImpl) {
                throw new DLTException(Messages.getString("notimplement"));
            }
            throw new DLTException(Messages.getString("notimplement"));
        }

        public Object getGloss() {
            int n = _NetIntegerImpl.this.getType(this.pnode);
            if (n == 5 || n == 6) {
                int n2 = _NetIntegerImpl.this.getGlossIdx(this.pnode);
                return n2 >= 0 ? _NetIntegerImpl.this.getGlossByIdx(n2) : null;
            }
            return null;
        }

        public void setGloss(Object object) throws DLTException {
            this.removeExistingGloss();
            _NetIntegerImpl.this.setGloss(this.pnode, object);
        }

        public Node nextRestricted(CharacterIterator characterIterator, int n) {
            int n2 = _NetIntegerImpl.this.next_restricted(this.pnode, characterIterator, characterIterator.getIndex() + n);
            return n2 != -1 ? new NodeImpl(n2) : null;
        }

        public int getType() {
            return _NetIntegerImpl.this.getType(this.pnode);
        }

        public int hashCode() {
            return this.pnode;
        }

        public boolean equals(Object object) {
            return ((NodeImpl)object).pnode == this.pnode;
        }
    }
}

