/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.Node;
import java.text.CharacterIterator;

public class NodeTable
implements Node {
    public Node[] outNode;
    int size;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public NodeTable() {
        this.outNode = new Node[65536];
        this.size = 0;
    }

    NodeTable(int n) {
        this.outNode = new Node[n];
        this.size = 0;
    }

    public final Node next(CharacterIterator characterIterator) {
        Node node;
        char c = characterIterator.current();
        Node node2 = node = c < this.outNode.length ? this.outNode[c] : null;
        if (node != null) {
            characterIterator.next();
        }
        return node;
    }

    public final Node next(char c) {
        Node node = this.outNode[c];
        return node;
    }

    public final void process_glosses(GlossProcessor glossProcessor) {
    }

    public final int num_entries() {
        return this.size;
    }

    public final int num_trans() {
        return 65536;
    }

    public int num_chars() {
        return 1;
    }

    public char get_char(int n) {
        return (char)n;
    }

    public String get_chars(int n) {
        return "" + (char)n;
    }

    public final Node get_trans(int n) {
        return this.outNode[n];
    }

    public final void set_trans(int n, Node node) {
        this.outNode[n] = node;
    }

    public int addChar(char c, int n, Node node) throws DLTException {
        if (this.outNode[c] == null) {
            if (n == 0x40000000) {
                throw new IllegalArgumentException(Messages.getString("cannot.replaceentry"));
            }
            ++this.size;
        }
        this.outNode[c] = node;
        return 0;
    }

    public int removeChar(char c, int n) throws DLTException {
        if (this.outNode[c] != null) {
            this.outNode[c] = null;
            --this.size;
        }
        return c;
    }

    public Node dupRemoveChar(char c) throws DLTException {
        throw new DLTException(Messages.getString("cannot.dupremove"));
    }

    public final boolean isFinal() {
        return false;
    }

    public void copy(Node node) {
    }

    public int add(CharacterIterator characterIterator, int n, int n2, Node node) throws DLTException {
        return 0;
    }

    public Object getGloss() {
        return null;
    }

    public void setGloss(Object object) {
        throw new IllegalArgumentException(Messages.getString("cannot.setgloss"));
    }

    public Node nextRestricted(CharacterIterator characterIterator, int n) {
        return n > 0 ? this.next(characterIterator) : null;
    }

    public int getType() {
        return 3;
    }

    public void deallocate() {
    }
}

