/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.gloss.GlossMapper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class NodeHashIndex {
    private Map _glossCollections = new LinkedHashMap();
    private Map _nodes = new LinkedHashMap();
    private final Node _first;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public NodeHashIndex(Node node) {
        this._first = node;
        this.processNode(node);
    }

    public int getNodeCount() {
        return this._nodes.size();
    }

    public int getGlossCollectionCount() {
        return this._glossCollections.size();
    }

    private void processNode(Node node) {
        Object object;
        if (node == null) {
            return;
        }
        if (this._nodes.containsKey(node)) {
            return;
        }
        this._nodes.put(node, new Integer(this._nodes.size()));
        if (node.isFinal() && !this._glossCollections.containsKey(object = this.getNodeGlossCollectionKey(node))) {
            this._glossCollections.put(object, new Integer(this._glossCollections.size()));
        }
        for (int i = 0; i < node.num_trans(); ++i) {
            this.processNode(node.get_trans(i));
        }
    }

    private Object getNodeGlossCollectionKey(Node node) {
        return ((GlossCollection)node.getGloss()).getFirst();
    }

    private GlossCollection getGlossCollectionFromMap(Object object) {
        return new GlossCollection((GlossListElement)object);
    }

    public int write_nodes(DataOutputStream dataOutputStream, int n) throws Exception {
        int n2 = 0;
        n2 += this.writeNodeDetails(dataOutputStream, this._first, n);
        Iterator iterator = this._nodes.keySet().iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            if (node == this._first) continue;
            n2 += this.writeNodeDetails(dataOutputStream, node, n);
        }
        return n2;
    }

    public int write_gloss_header(DataOutputStream dataOutputStream, GlossMapper glossMapper) throws Exception {
        int n = 0;
        int n2 = this.getGlossCollectionsSize();
        dataOutputStream.writeInt(n2);
        n += 4;
        Iterator iterator = this._glossCollections.keySet().iterator();
        while (iterator.hasNext()) {
            GlossCollection glossCollection = this.getGlossCollectionFromMap(iterator.next());
            n += this.writeGlossCollectionDetails(dataOutputStream, glossCollection, glossMapper);
        }
        dataOutputStream.writeInt(-84230466);
        return n += 4;
    }

    private int getGlossCollectionsSize() {
        int n = 0;
        Iterator iterator = this._glossCollections.keySet().iterator();
        while (iterator.hasNext()) {
            GlossCollection glossCollection = this.getGlossCollectionFromMap(iterator.next());
            n += glossCollection.size();
        }
        return n;
    }

    private int writeGlossCollectionDetails(DataOutputStream dataOutputStream, GlossCollection glossCollection, GlossMapper glossMapper) throws DLTException, IOException {
        int n = 0;
        Iterator iterator = glossCollection.iterator();
        while (iterator.hasNext()) {
            int n2 = glossMapper.getGlossIndex((Gloss)iterator.next());
            n2 = this.newHash(n2);
            dataOutputStream.writeInt(n2);
            n += 4;
        }
        dataOutputStream.writeInt(-1);
        return n += 4;
    }

    private int newHash(int n) {
        if (n == 0) {
            return n;
        }
        int n2 = --n / 3;
        return 4 * n2 + 1 + n % 3;
    }

    private int getNodeGlossCollectionHash(Node node) {
        Object object = this.getNodeGlossCollectionKey(node);
        int n = (Integer)this._glossCollections.get(object);
        return this.newHash(n);
    }

    private int writeNodeDetails(DataOutputStream dataOutputStream, Node node, int n) throws Exception {
        int n2 = 0;
        int n3 = node.getType();
        boolean bl = node.isFinal();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeByte((byte)n3);
        dataOutputStream.writeByte((byte)(bl ? 1 : 0));
        dataOutputStream.writeByte(0);
        n2 += 4;
        int n4 = node.num_entries();
        dataOutputStream.writeShort((short)n4);
        n2 += 2;
        switch (n3) {
            case 1: 
            case 2: {
                int n5;
                for (n5 = 0; n5 < n4; ++n5) {
                    dataOutputStream.writeShort(node.get_char(n5));
                    n2 += 2;
                }
                for (n5 = 0; n5 < n4; ++n5) {
                    Node node2 = node.get_trans(n5);
                    Integer n6 = (Integer)this._nodes.get(node2);
                    int n7 = n6 != null ? n6 : 0;
                    dataOutputStream.writeInt(n + n7);
                    n2 += 4;
                }
                break;
            }
            case 3: {
                for (int i = 0; i < 65536; ++i) {
                    Node node3 = node.get_trans(i);
                    int n8 = -1;
                    if (node3 != null) {
                        Integer n9 = (Integer)this._nodes.get(node3);
                        n8 = n9;
                    }
                    dataOutputStream.writeInt(n + n8);
                    n2 += 4;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n4; ++i) {
                    dataOutputStream.writeShort(node.get_char(i));
                    n2 += 2;
                }
                Node node4 = node.get_trans(0);
                Integer n10 = (Integer)this._nodes.get(node4);
                int n11 = n10;
                dataOutputStream.writeInt(n + n11);
                n2 += 4;
                break;
            }
            case 5: {
                int n12 = this.getNodeGlossCollectionHash(node);
                dataOutputStream.writeInt(n12);
                n2 += 4;
                break;
            }
            case 6: {
                Node node5 = node.get_trans(0);
                Integer n13 = (Integer)this._nodes.get(node5);
                int n14 = n13;
                dataOutputStream.writeInt(n + n14);
                n2 += 4;
                int n15 = this.getNodeGlossCollectionHash(node);
                dataOutputStream.writeInt(n15);
                n2 += 4;
                break;
            }
            case 8: {
                for (int i = 0; i < n4; ++i) {
                    Node node6 = node.get_trans(i);
                    Integer n16 = (Integer)this._nodes.get(node6);
                    int n17 = n16 != null ? n16 : 0;
                    dataOutputStream.writeInt(n + n17);
                    n2 += 4;
                }
                break;
            }
            default: {
                throw new DLTException(Messages.format("node.type", n3));
            }
        }
        return n2;
    }
}

