/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.fst.TransitionList;
import java.text.CharacterIterator;

public class NodeBSearch
extends TransitionList {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public NodeBSearch() {
        super(8);
    }

    NodeBSearch(int n) {
        super(n);
    }

    private final int lowerBound(char c) {
        int n = 0;
        int n2 = this.size - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            char c2 = this.inChar[n3];
            if (c2 < c) {
                n = n3 + 1;
                continue;
            }
            if (c2 > c) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private final Node binMatchInChar(char c) {
        int n = 0;
        int n2 = this.size - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            char c2 = this.inChar[n3];
            if (c2 < c) {
                n = n3 + 1;
                continue;
            }
            if (c2 > c) {
                n2 = n3 - 1;
                continue;
            }
            return this.outNode[n3];
        }
        return null;
    }

    public final Node next(CharacterIterator characterIterator) {
        Node node = this.binMatchInChar(characterIterator.current());
        if (node != null) {
            characterIterator.next();
        }
        return node;
    }

    public final Node next(char c) {
        return this.binMatchInChar(c);
    }

    public final void process_glosses(GlossProcessor glossProcessor) {
    }

    public final int addChar(char c, int n, Node node) throws DLTException {
        int n2 = this.lowerBound(c);
        if (n2 >= 0) {
            if (n != 0x40000000) {
                throw new DLTException(Messages.getString("cannot.replacetransition"));
            }
        } else {
            n2 = -n2 - 1;
            this.addOne(n2);
        }
        this.inChar[n2] = c;
        this.outNode[n2] = node;
        return n2;
    }

    public int removeChar(char c, int n) throws DLTException {
        int n2 = this.lowerBound(c);
        if (n2 < 0) {
            throw new DLTException(Messages.getString("cannot.removetransition"));
        }
        this.removeOne(n2);
        return n2;
    }

    public boolean isFinal() {
        return false;
    }

    public Object getGloss() {
        return null;
    }

    public void setGloss(Object object) {
        throw new IllegalArgumentException(Messages.getString("cannot.setgloss"));
    }

    public int getType() {
        return 2;
    }
}

