/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.GlossCollectionShared;
import com.ibm.dltj.fst._NetIntegerImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class MultiNetIntegerImpl
extends _NetIntegerImpl {
    private static final int GBUCKET_SIZE = 128;
    private static final int GALLOC_CHUNK = 128;
    private TreeSet _freeBuckets = new TreeSet();
    private LLBucket[] _buckets = new LLBucket[128];
    private Map _collections = null;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public MultiNetIntegerImpl() {
        for (int i = 0; i < this._buckets.length; ++i) {
            this._buckets[i] = new LLBucket(i);
            this._freeBuckets.add(this._buckets[i]);
        }
    }

    public void endReading() {
        super.endReading();
        this.freeBuckets();
    }

    private void freeBuckets() {
        int n = 0;
        for (int i = this._buckets.length - 1; i >= 0; --i) {
            if (!this._buckets[i].isEmpty()) {
                n = i + 1;
                break;
            }
            this._freeBuckets.remove(this._buckets[i]);
            this._buckets[i] = null;
        }
        if (n < this._buckets.length) {
            LLBucket[] lLBucketArray = new LLBucket[n];
            System.arraycopy(this._buckets, 0, lLBucketArray, 0, n);
            this._buckets = lLBucketArray;
        }
    }

    public void startBuild(boolean bl) {
        this._collections = bl ? new HashMap() : null;
    }

    public int endBuild() {
        int n = 0;
        if (this._collections != null) {
            n = this._collections.size();
            this._collections = null;
        }
        this.freeBuckets();
        return n;
    }

    private void growBuckets() {
        LLBucket[] lLBucketArray = new LLBucket[this._buckets.length + 128];
        System.arraycopy(this._buckets, 0, lLBucketArray, 0, this._buckets.length);
        for (int i = this._buckets.length; i < lLBucketArray.length; ++i) {
            lLBucketArray[i] = new LLBucket(i);
            this._freeBuckets.add(lLBucketArray[i]);
        }
        this._buckets = lLBucketArray;
    }

    int addGloss(Object object) throws DLTException {
        if (this._freeBuckets.isEmpty()) {
            this.growBuckets();
        }
        LLBucket lLBucket = (LLBucket)this._freeBuckets.first();
        int n = lLBucket.addGloss(object);
        if (lLBucket.isFull()) {
            this._freeBuckets.remove(lLBucket);
        }
        return n;
    }

    void removeGloss(int n) {
        int n2 = n / 128;
        LLBucket lLBucket = this._buckets[n2];
        int n3 = n % 128;
        if (lLBucket.removeGloss(n3)) {
            this._freeBuckets.add(lLBucket);
        }
    }

    void processNew(int n, Object object) throws DLTException {
        GlossCollectionShared glossCollectionShared = new GlossCollectionShared((Gloss)object);
        if (this._collections == null) {
            this.setGlossIdx(n, this.addGloss(glossCollectionShared));
        } else {
            this.findOrAdd(n, glossCollectionShared);
        }
    }

    private void findOrAdd(int n, GlossCollectionShared glossCollectionShared) throws DLTException {
        int n2;
        Object v = this._collections.get(glossCollectionShared);
        if (v != null) {
            glossCollectionShared = (GlossCollectionShared)v;
            glossCollectionShared.incRefCount();
            n2 = glossCollectionShared.getIndex();
        } else {
            this._collections.put(glossCollectionShared, glossCollectionShared);
            n2 = this.addGloss(glossCollectionShared);
            glossCollectionShared.setIndex(n2);
        }
        this.setGlossIdx(n, n2);
    }

    void processExisting(int n, Object object) throws DLTException {
        Object object2 = this.getGlossForNode(n);
        if (this._collections == null) {
            if (!(object2 instanceof GlossCollection)) {
                throw new DLTException(Messages.getString("error.gloss.unexpected"));
            }
            GlossCollection glossCollection = (GlossCollection)object2;
            glossCollection.add(object);
            return;
        }
        if (!(object2 instanceof GlossCollectionShared)) {
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
        GlossCollectionShared glossCollectionShared = (GlossCollectionShared)object2;
        if (glossCollectionShared.isSingleRef()) {
            this._collections.remove(glossCollectionShared);
            glossCollectionShared.add(object);
            Object v = this._collections.get(glossCollectionShared);
            if (v != null) {
                this.removeGloss(glossCollectionShared.getIndex());
                glossCollectionShared = (GlossCollectionShared)v;
                glossCollectionShared.incRefCount();
                this.setGlossIdx(n, glossCollectionShared.getIndex());
            } else {
                this._collections.put(glossCollectionShared, glossCollectionShared);
            }
        } else {
            glossCollectionShared.decRefCount();
            glossCollectionShared = new GlossCollectionShared(glossCollectionShared);
            glossCollectionShared.add(object);
            this.findOrAdd(n, glossCollectionShared);
        }
    }

    Object getGlossByIdx(int n) {
        if (n < 0) {
            return null;
        }
        int n2 = n / 128;
        int n3 = n % 128;
        return this._buckets[n2].getGloss(n3);
    }

    Object getGlossForNode(int n) {
        int n2 = this.getGlossIdx(n);
        if (n2 < 0) {
            return null;
        }
        int n3 = n2 / 128;
        int n4 = n2 % 128;
        return this._buckets[n3].getGloss(n4);
    }

    boolean glossesEqual(int n, int n2) {
        if (n == n2) {
            return true;
        }
        GlossCollection glossCollection = (GlossCollection)this.getGlossByIdx(n);
        GlossCollection glossCollection2 = (GlossCollection)this.getGlossByIdx(n2);
        return glossCollection.equals(glossCollection2);
    }

    int glossHash(int n) {
        return ((GlossCollection)this.getGlossByIdx(n)).hashCode();
    }

    private static class LLBucket
    implements Comparable {
        private final int _firstEntryIndex;
        private int _freeCount = 128;
        private int _firstFree = 0;
        private final Object[] _bucket = new Object[128];

        LLBucket(int n) {
            this._firstEntryIndex = 128 * n;
        }

        boolean isFull() {
            return this._freeCount == 0;
        }

        boolean isEmpty() {
            return this._freeCount == 128;
        }

        int addGloss(Object object) throws DLTException {
            int n = this.findFirstFreeIndex();
            this._bucket[n] = object;
            --this._freeCount;
            this._firstFree = n + 1;
            return this._firstEntryIndex + n;
        }

        private int findFirstFreeIndex() throws DLTException {
            for (int i = this._firstFree; i < 128; ++i) {
                if (this._bucket[i] != null) continue;
                return i;
            }
            throw new DLTException(Messages.getString("cannot.allocateglossentry"));
        }

        boolean removeGloss(int n) {
            this._bucket[n] = null;
            ++this._freeCount;
            if (n < this._firstFree) {
                this._firstFree = n;
            }
            return this._freeCount == 1;
        }

        Object getGloss(int n) {
            return this._bucket[n];
        }

        public int compareTo(Object object) {
            return this._firstEntryIndex - ((LLBucket)object)._firstEntryIndex;
        }
    }
}

