/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossProcessor;
import com.ibm.dltj.GlossReader;
import com.ibm.dltj.Messages;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.fst.Net;
import com.ibm.dltj.fst.Node;
import com.ibm.dltj.gloss.MapperGloss;
import java.io.DataInputStream;
import java.io.IOException;
import java.text.CharacterIterator;
import java.util.Iterator;

public class MultiNetImpl
extends Net
implements MultiNet {
    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    void processNew(Node node, Object object) throws DLTException {
        GlossCollection glossCollection = new GlossCollection();
        glossCollection.add((Gloss)object);
        node.setGloss(glossCollection);
    }

    void processExisting(Node node, Object object) throws DLTException {
        Object object2 = node.getGloss();
        if (!(object2 instanceof GlossCollection) || !(object instanceof Gloss)) {
            throw new DLTException(Messages.getString("error.gloss.unexpected"));
        }
        ((GlossCollection)object2).add((Gloss)object);
    }

    public long read_contents(DataInputStream dataInputStream) throws DLTException, IOException {
        int n;
        if (dataInputStream.readInt() != -1161904401) {
            throw new DLTException(Messages.getString("error.dict.signature"));
        }
        dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        SimpleGlossReader simpleGlossReader = new SimpleGlossReader(n2);
        super.read_contents(dataInputStream, simpleGlossReader);
        int n3 = dataInputStream.readInt();
        int n4 = 0;
        for (int i = n3; i != 0; i -= n) {
            int n5;
            n = 0;
            GlossCollection glossCollection = new GlossCollection();
            while ((n5 = dataInputStream.readInt()) != -1) {
                MapperGloss mapperGloss = new MapperGloss(n5);
                glossCollection.add(mapperGloss);
                ++n;
            }
            simpleGlossReader.map[n4++] = glossCollection;
        }
        n = dataInputStream.readInt();
        if (n != -84230466) {
            throw new DLTException(Messages.getString("error.marker"));
        }
        this.processGlosses(simpleGlossReader);
        simpleGlossReader.map = null;
        return n3;
    }

    public void removeGloss(CharacterIterator characterIterator, int n, Gloss gloss) throws DLTException {
        int n2 = characterIterator.getIndex();
        GlossCollection glossCollection = (GlossCollection)this.get(characterIterator, n);
        if (gloss != null) {
            glossCollection.remove(gloss);
        }
        if (gloss == null || glossCollection.isEmpty()) {
            characterIterator.setIndex(n2);
            this.remove(characterIterator, n);
        }
    }

    public Iterator iterator() {
        return new Net.Iterator(this);
    }

    public void contract() throws DLTException {
        throw new DLTException(Messages.getString("notimplement.method"));
    }

    public Node newNode(int n, int n2) throws DLTException {
        throw new DLTException(Messages.getString("notimplement.method"));
    }

    public void setFirstNode(Node node) {
        this.first = node;
    }

    public void startBuild(boolean bl) {
    }

    public int endBuild() {
        return 0;
    }

    private static class SimpleGlossReader
    extends GlossReader
    implements GlossProcessor {
        Object[] map;

        private SimpleGlossReader(int n) {
            this.map = new Object[n > 0 ? n : 0];
        }

        public final Object process(Object object) {
            if (object != null && object instanceof MapperGloss) {
                return this.map[((MapperGloss)object).map];
            }
            return object;
        }

        public Object recalc(long l) throws DLTException {
            if (l == -1L) {
                return null;
            }
            int n = SimpleGlossReader.decode_ordinal((int)l);
            return this.map[n] == null ? new MapperGloss(n) : this.map[n];
        }

        public final void reset() {
        }
    }
}

