/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.fst;

public class MatchBuffer {
    public int[] index;
    public Object[] gloss;
    int[] savedPositions;
    int savedIndex;
    public int mpos;
    int maxIndex;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public int getNumMatches() {
        return this.savedIndex;
    }

    public int getMaxIndex() {
        return this.maxIndex;
    }

    public void setMaxIndex(int n) {
        this.maxIndex = n;
    }

    public MatchBuffer() {
        this.init(16);
    }

    public MatchBuffer(int n) {
        this.init(n);
    }

    protected void init(int n) {
        this.savedPositions = new int[16];
        this.index = new int[n];
        this.gloss = new Object[n];
        this.mpos = 0;
        this.maxIndex = 0;
        this.savedIndex = 0;
    }

    public final int grow() {
        int[] nArray = new int[this.index.length * 2];
        Object[] objectArray = new Object[this.index.length * 2];
        int n = this.index.length;
        System.arraycopy(this.index, 0, nArray, 0, n);
        System.arraycopy(this.gloss, 0, objectArray, 0, n);
        this.index = nArray;
        this.gloss = objectArray;
        return this.index.length;
    }

    public final void clear() {
        this.maxIndex = 0;
        this.savedIndex = 0;
        this.mpos = 0;
    }

    public void add(int n, Object object) {
        if (this.mpos >= this.index.length) {
            this.grow();
        }
        this.index[this.mpos] = n;
        this.gloss[this.mpos] = object;
        if (this.maxIndex < n) {
            this.maxIndex = n;
        }
        ++this.mpos;
    }

    public void addReversed(int n, Object object) {
        if (this.mpos >= this.index.length) {
            this.grow();
        }
        this.index[this.mpos] = n;
        this.gloss[this.mpos] = object;
        if (this.maxIndex > n) {
            this.maxIndex = n;
        }
        ++this.mpos;
    }

    public boolean addMax(int n, Object object) {
        if (n >= this.maxIndex) {
            if (n > this.maxIndex) {
                this.savedIndex = 0;
                this.mpos = 0;
                this.maxIndex = n;
            }
            if (this.mpos >= this.index.length) {
                this.grow();
            }
            this.index[this.mpos] = n;
            this.gloss[this.mpos] = object;
            ++this.mpos;
            return true;
        }
        return false;
    }

    public boolean addMin(int n, Object object) {
        if (n <= this.maxIndex) {
            if (n < this.maxIndex) {
                this.savedIndex = 0;
                this.mpos = 0;
                this.maxIndex = n;
            }
            if (this.mpos >= this.index.length) {
                this.grow();
            }
            this.index[this.mpos] = n;
            this.gloss[this.mpos] = object;
            ++this.mpos;
            return true;
        }
        return false;
    }

    public void removeRange(int n, int n2) throws ArrayIndexOutOfBoundsException {
        System.arraycopy(this.index, n2, this.index, n, this.mpos - n2);
        System.arraycopy(this.gloss, n2, this.gloss, n, this.mpos - n2);
        this.mpos -= n2 - n;
        this.verify();
    }

    public void pushMatch() {
        ++this.savedIndex;
        if (this.savedIndex >= this.savedPositions.length) {
            int[] nArray = new int[this.savedPositions.length * 2];
            System.arraycopy(this.savedPositions, 0, nArray, 0, this.savedPositions.length);
            this.savedPositions = nArray;
        }
        this.savedPositions[this.savedIndex] = this.mpos;
        this.verify();
    }

    public void prepend(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 0) {
            if (this.mpos + n3 >= this.index.length) {
                this.grow();
            }
            System.arraycopy(this.index, n, this.index, this.mpos, n3);
            System.arraycopy(this.gloss, n, this.gloss, this.mpos, n3);
            this.mpos += n3;
        }
        this.verify();
    }

    public void popMatch() {
        if (this.savedIndex > 0) {
            --this.savedIndex;
        } else {
            this.mpos = 0;
        }
        this.verify();
    }

    public int matchLength() {
        return this.savedIndex == 0 ? this.mpos : this.mpos - this.savedPositions[this.savedIndex];
    }

    public int getMatchStart(int n) {
        return this.savedPositions[n];
    }

    public int getMatchEnd(int n) {
        return n < this.savedIndex ? this.savedPositions[n + 1] : this.mpos;
    }

    public void removeMatch(int n) {
        int n2 = this.getMatchStart(n);
        int n3 = this.getMatchEnd(n);
        int n4 = n3 - n2;
        System.arraycopy(this.index, n3, this.index, n2, this.mpos - n3);
        System.arraycopy(this.gloss, n3, this.gloss, n2, this.mpos - n3);
        for (int i = n + 1; i < this.savedIndex; ++i) {
            this.savedPositions[i] = this.savedPositions[i + 1] - n4;
        }
        if (this.savedIndex > 0) {
            --this.savedIndex;
        }
        this.mpos -= n3 - n2;
        this.verify();
    }

    public void verify() {
    }
}

