/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.data.ja;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public final class JaTrHandler {
    private static final String fname1 = "jatr.dat";
    private static final String fname2 = "jatrle.dat";
    private final Map data1 = this.createIndex("jatr.dat");
    private final Map data2 = this.createIndex("jatrle.dat");
    private static final JaTrHandler instance = new JaTrHandler();

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    private JaTrHandler() {
    }

    public static final JaTrHandler getInstance() {
        return instance;
    }

    public final Map getData1(int n) {
        return (Map)this.data1.get(new Integer(n));
    }

    public final Map getData2(int n) {
        return (Map)this.data2.get(new Integer(n));
    }

    private Map createIndex(String string) {
        TreeMap treeMap = new TreeMap();
        try {
            int n;
            URL uRL = this.getClass().getResource(string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream(), "utf-8"));
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedReader);
            streamTokenizer.parseNumbers();
            streamTokenizer.commentChar(35);
            streamTokenizer.whitespaceChars(44, 44);
            streamTokenizer.whitespaceChars(123, 123);
            streamTokenizer.whitespaceChars(125, 125);
            streamTokenizer.eolIsSignificant(true);
            int[] nArray = new int[6];
            int n2 = 0;
            block7: while ((n = streamTokenizer.nextToken()) != -1) {
                switch (n) {
                    case 10: {
                        if (n2 == nArray.length) {
                            Ternary ternary;
                            TreeSet<Ternary> treeSet;
                            Integer n3 = new Integer(nArray[0]);
                            TreeMap treeMap2 = (TreeMap)treeMap.get(n3);
                            if (treeMap2 == null) {
                                treeMap2 = new TreeMap();
                                treeMap.put(n3, treeMap2);
                            }
                            if ((treeSet = (TreeSet<Ternary>)treeMap2.get(ternary = new Ternary(nArray[0], nArray[1], nArray[2]))) == null) {
                                treeSet = new TreeSet<Ternary>();
                                treeMap2.put(ternary, treeSet);
                            }
                            Ternary ternary2 = new Ternary(nArray[3], nArray[4], nArray[5]);
                            treeSet.add(ternary2);
                        }
                        n2 = 0;
                        Arrays.fill(nArray, 0);
                        continue block7;
                    }
                    case -2: {
                        nArray[n2++] = (int)streamTokenizer.nval;
                        continue block7;
                    }
                }
            }
            bufferedReader.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return treeMap;
    }

    public static final class Ternary
    implements Comparable {
        public final int val1;
        public final int val2;
        public final int val3;

        public Ternary(int n, int n2, int n3) {
            this.val1 = n;
            this.val2 = n2;
            this.val3 = n3;
        }

        public int compareTo(Object object) {
            Ternary ternary = (Ternary)object;
            int n = this.val1 - ternary.val1;
            if (n != 0) {
                return n;
            }
            n = this.val2 - ternary.val2;
            if (n != 0) {
                return n;
            }
            return this.val3 - ternary.val3;
        }

        public int hashCode() {
            int n = 17;
            n = 37 * n + this.val1;
            n = 37 * n + this.val2;
            n = 37 * n + this.val3;
            return n;
        }

        public boolean equals(Object object) {
            return this.val1 != this.val1 ? false : (this.val2 != this.val2 ? false : this.val3 == this.val3);
        }
    }
}

