/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj.data;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Messages;
import com.ibm.icu.text.RuleBasedBreakIterator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.TreeMap;

public class BreakIteratorManager {
    protected static final Map breakIterators = new TreeMap();
    public static final int BY_LOCALE = 0;
    public static final int BY_FILE = 1;
    public int constrMethod = 0;
    static final String resourceBase = "dltb_";

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public void setConstrMethod(int n) {
        this.constrMethod = n;
    }

    private RuleBasedBreakIterator construct(String string) throws DLTException, IOException {
        RuleBasedBreakIterator ruleBasedBreakIterator = (RuleBasedBreakIterator)breakIterators.get(string);
        if (ruleBasedBreakIterator != null) {
            return (RuleBasedBreakIterator)ruleBasedBreakIterator.clone();
        }
        if (this.constrMethod == 1) {
            FileInputStream fileInputStream = new FileInputStream(string);
            ruleBasedBreakIterator = RuleBasedBreakIterator.getInstanceFromCompiledRules((InputStream)fileInputStream);
            fileInputStream.close();
        } else {
            ruleBasedBreakIterator = this.getInstanceFromResource(string);
        }
        if (ruleBasedBreakIterator != null) {
            breakIterators.put(string, ruleBasedBreakIterator);
            return (RuleBasedBreakIterator)ruleBasedBreakIterator.clone();
        }
        return null;
    }

    public RuleBasedBreakIterator constructBreakIterator(String string) throws DLTException {
        if (string == null || string.length() == 0) {
            string = "default";
            this.constrMethod = 0;
        }
        try {
            Map map = breakIterators;
            synchronized (map) {
                RuleBasedBreakIterator ruleBasedBreakIterator = null;
                if (this.constrMethod == 1) {
                    ruleBasedBreakIterator = this.construct(string);
                    if (ruleBasedBreakIterator != null) {
                        return ruleBasedBreakIterator;
                    }
                } else {
                    ruleBasedBreakIterator = this.construct(string);
                    if (ruleBasedBreakIterator != null) {
                        return ruleBasedBreakIterator;
                    }
                    if (string.length() > 2 && (ruleBasedBreakIterator = this.construct(string.substring(0, 2))) != null) {
                        return ruleBasedBreakIterator;
                    }
                    ruleBasedBreakIterator = this.construct("default");
                    if (ruleBasedBreakIterator != null) {
                        return ruleBasedBreakIterator;
                    }
                }
                throw new DLTException(Messages.format("cannot.loadresource", string));
            }
        }
        catch (IOException iOException) {
            String string2 = this.constrMethod == 1 ? ": *file*" : ": *locale*";
            throw new DLTException(Messages.getString("exception.read") + string2 + ": " + iOException.getMessage());
        }
    }

    private RuleBasedBreakIterator getInstanceFromResource(String string) throws IOException {
        InputStream inputStream = null;
        String string2 = resourceBase + string + ".brk";
        Class<?> clazz = this.getClass();
        inputStream = clazz.getResourceAsStream(string2);
        RuleBasedBreakIterator ruleBasedBreakIterator = null;
        if (inputStream != null) {
            ruleBasedBreakIterator = RuleBasedBreakIterator.getInstanceFromCompiledRules((InputStream)inputStream);
            inputStream.close();
        }
        return ruleBasedBreakIterator;
    }
}

