/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.Messages;
import com.ibm.dltj.UniDictionaryManager;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.UniMorphoSyntaxFi;
import com.ibm.dltj.fst.MatchBuffer;
import java.text.CharacterIterator;

class UniMorphoSyntax
extends UniDictionaryManager {
    MatchBuffer matches = new MatchBuffer();
    int cmPolicy = 1;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    UniMorphoSyntax() {
    }

    static UniMorphoSyntax getMorphoSyntax(String string, String string2) {
        if (string.startsWith("fi")) {
            return new UniMorphoSyntaxFi();
        }
        return new UniMorphoSyntax(string, string2);
    }

    private UniMorphoSyntax(String string, String string2) {
        this();
    }

    public void open(Dictionary[] dictionaryArray, int n) throws DLTException {
        this.cmPolicy = n;
        this.matches.clear();
        for (int i = 0; i < dictionaryArray.length; ++i) {
            if (dictionaryArray[i] != null && dictionaryArray[i].valid()) continue;
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        this.dictionaries = dictionaryArray;
        this.lockReadDictionaries();
    }

    public void open(int n) throws DLTException {
        this.cmPolicy = n;
        this.matches.clear();
        this.lockReadDictionaries();
    }

    protected boolean dictLookup(CharacterIterator characterIterator, UniLexAnalyzer.DictLookupPos dictLookupPos) {
        int n = characterIterator.getIndex();
        boolean bl = false;
        while (dictLookupPos.dictIdx < this.dictionaries.length) {
            characterIterator.setIndex(n);
            if (this.dictionaries[dictLookupPos.dictIdx].lookupLongest(characterIterator, this.matches)) {
                bl = true;
                if (this.cmPolicy == 1) {
                    ++dictLookupPos.dictIdx;
                    break;
                }
            }
            ++dictLookupPos.dictIdx;
        }
        characterIterator.setIndex(n);
        return bl;
    }

    public GlossCollection dictLookupWord(CharacterIterator characterIterator, int n) {
        GlossCollection glossCollection = null;
        try {
            for (int i = 0; i < this.dictionaries.length; ++i) {
                GlossCollection glossCollection2 = this.dictionaries[i].lookupWord(characterIterator, n);
                if (glossCollection2 == null) continue;
                if (glossCollection == null) {
                    glossCollection = new GlossCollection();
                    glossCollection.addAll(glossCollection2);
                    if (this.cmPolicy != 1) continue;
                    return glossCollection;
                }
                glossCollection.addAll(glossCollection2);
            }
        }
        catch (DLTException dLTException) {
            dLTException.printStackTrace();
        }
        return glossCollection;
    }

    protected GlossCollection oov_dictLookup(CharacterIterator characterIterator, int n) {
        if (this.oov_dictionaries.length <= 0) {
            return null;
        }
        GlossCollection glossCollection = null;
        for (int i = 0; i < this.oov_dictionaries.length; ++i) {
            GlossCollection glossCollection2 = (GlossCollection)this.oov_dictionaries[i].oovLookup(characterIterator, n);
            if (glossCollection2 == null) continue;
            if (glossCollection == null) {
                glossCollection = new GlossCollection();
                glossCollection.addAll(glossCollection2);
                if (this.cmPolicy != 1) continue;
                return glossCollection;
            }
            glossCollection.addAll(glossCollection2);
        }
        return glossCollection;
    }
}

