/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.HanNormalizer;
import com.ibm.dltj.HanNumeralCharacterClassifierZh;
import com.ibm.dltj.UniLexAnalyzerTrellis;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.gloss.LangNameGloss;
import com.ibm.dltj.gloss.LemmaGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.RegExpGloss;
import com.ibm.dltj.gloss.ZhCposGloss;
import com.ibm.dltj.gloss.ZhDecompGloss;
import com.ibm.dltj.gloss.ZhFreqGloss;
import com.ibm.dltj.gloss.ZhLemmaGloss;
import com.ibm.dltj.gloss.ZhMorphGloss;
import com.ibm.dltj.parser.RBBICategory;
import com.ibm.dltj.trellis.EdgeListElement;
import com.ibm.dltj.trellis.GlossFilter;
import com.ibm.dltj.trellis.WeightBuffer;
import com.ibm.dltj.trellis.WeightExtractor;
import com.ibm.dltj.trellis.WeightTrellis;
import java.text.CharacterIterator;

final class UniLexAnalyzerZh
extends UniLexAnalyzerTrellis {
    private static final int UNKNOWN_FREQUENCY = 70000;
    private static final boolean NORMALIZATION_FLAG = true;
    private final HanNormalizer normalizer = new HanNormalizer(new HanNumeralCharacterClassifierZh());
    private static final String NORMALIZED_DATE_PREFIX = "date!";
    private final GlossCollection m_emptyGlossColl;
    static /* synthetic */ Class class$com$ibm$dltj$gloss$MidGloss;
    static /* synthetic */ Class class$com$ibm$dltj$gloss$ZhDecompGloss;
    static /* synthetic */ Class class$com$ibm$dltj$gloss$ZhFreqGloss;
    static /* synthetic */ Class class$com$ibm$dltj$gloss$ZhMorphGloss;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public UniLexAnalyzerZh(String string) throws DLTException {
        super(string);
        this.trellis = new WeightTrellis(new WeightExtractorImpl(), new StandardGlossFilter());
        this.decompFlags |= 1;
        this.m_emptyGlossColl = new GlossCollection(new GlossListElement(new MidGloss(new Gloss[]{new ZhCposGloss(new byte[]{0}), new ZhLemmaGloss(""), new LangNameGloss(string)}), null));
    }

    public UniLexAnalyzerZh(String string, String string2) throws DLTException {
        super(string, string2);
        this.trellis = new WeightTrellis(new WeightExtractorImpl(), new StandardGlossFilter());
        this.decompFlags |= 1;
        this.m_emptyGlossColl = new GlossCollection(new GlossListElement(new MidGloss(new Gloss[]{new ZhCposGloss(new byte[]{0}), new ZhLemmaGloss(""), new LangNameGloss(string)}), null));
    }

    protected int rawLookup(CharacterIterator characterIterator, MultiNet multiNet, MatchBuffer matchBuffer) {
        return multiNet.whitespaceIgnoringTraverse(characterIterator, matchBuffer);
    }

    protected void doProcessTrellis() throws DLTException {
        EdgeListElement edgeListElement;
        if (this.trellis.isEmpty()) {
            return;
        }
        for (EdgeListElement edgeListElement2 = edgeListElement = this.trellis.process(); edgeListElement2 != null; edgeListElement2 = edgeListElement2.getNext()) {
            int n = edgeListElement2.getStartIndex();
            int n2 = edgeListElement2.getEndIndex();
            Object object = edgeListElement2.getGloss();
            if (n == n2) continue;
            if (object instanceof RegExpGloss) {
                int n3 = ((RegExpGloss)object).getExpCls();
                int n4 = this.characterIterator.getIndex();
                this.characterIterator.setIndex(n);
                if (RBBICategory.isPunctuation(n3)) {
                    this.insertPunctuation(n, n2, 65535, this.characterIterator.current());
                } else if (this.hasNormalizationFlag()) {
                    String string = null;
                    switch (n3) {
                        case 106: 
                        case 109: 
                        case 420: 
                        case 421: 
                        case 425: 
                        case 426: 
                        case 427: {
                            string = this.normalizer.normalize(this.characterIterator, n, n2, 1);
                            break;
                        }
                        case 401: {
                            string = NORMALIZED_DATE_PREFIX + this.normalizer.normalize(this.characterIterator, n, n2, 3);
                            break;
                        }
                        case 105: {
                            string = NORMALIZED_DATE_PREFIX + this.normalizer.normalize(this.characterIterator, n, n2, 2);
                            break;
                        }
                    }
                    if (string != null) {
                        int n5 = 0;
                        this.startDecompGroup(n, n2);
                        this.fork();
                        this.insertUnknownWord(n, n2, n3);
                        ++n5;
                        this.addToFork();
                        MidGloss midGloss = new MidGloss(new Gloss[]{new LemmaGloss(string)});
                        this.insertDecompElement(n, n2, new GlossCollection(new GlossListElement(midGloss, null)));
                        this.closeDecompGroup(++n5);
                    } else {
                        switch (n3) {
                            case 201: 
                            case 202: 
                            case 203: {
                                if ((this.hints & 2) != 2 && this.isHyphenWord(n, n2)) {
                                    this.decomposeHypheWord(n, n2, n3);
                                    break;
                                }
                                this.insertUnknownWord(n, n2, n3);
                                break;
                            }
                            default: {
                                this.insertUnknownWord(n, n2, n3);
                                break;
                            }
                        }
                    }
                } else {
                    switch (n3) {
                        case 201: 
                        case 202: 
                        case 203: {
                            if ((this.hints & 2) != 2 && this.isHyphenWord(n, n2)) {
                                this.decomposeHypheWord(n, n2, n3);
                                break;
                            }
                            this.insertUnknownWord(n, n2, n3);
                            break;
                        }
                        default: {
                            this.insertUnknownWord(n, n2, n3);
                        }
                    }
                }
                this.characterIterator.setIndex(n4);
                continue;
            }
            if (object instanceof Gloss) {
                object = this.gFactory.getInstance(object);
            }
            if (this.hasDecompositionFlag() && this.isCompoundWord(n, n2, object)) {
                this.decomposeWord(n, n2, object);
                continue;
            }
            this.insertParsedGloss(n, n2, (GlossCollection)object);
        }
        this.trellis.clear();
    }

    protected int stepForward(int n, int n2, int n3) {
        return n < n2 ? n2 : n + 1;
    }

    private boolean hasNormalizationFlag() {
        return true;
    }

    private boolean hasDecompositionFlag() {
        return (this.hints & 1) != 0;
    }

    private boolean isCompoundWord(int n, int n2, Object object) {
        return n2 - n > 2;
    }

    private void decomposeWord(int n, int n2, Object object) throws DLTException {
        MidGloss midGloss = (MidGloss)((GlossCollection)object).getGloss(class$com$ibm$dltj$gloss$MidGloss == null ? (class$com$ibm$dltj$gloss$MidGloss = UniLexAnalyzerZh.class$("com.ibm.dltj.gloss.MidGloss")) : class$com$ibm$dltj$gloss$MidGloss);
        if (midGloss == null) {
            this.insertParsedGloss(n, n2, (GlossCollection)object);
            return;
        }
        ZhDecompGloss zhDecompGloss = (ZhDecompGloss)midGloss.getGloss(class$com$ibm$dltj$gloss$ZhDecompGloss == null ? (class$com$ibm$dltj$gloss$ZhDecompGloss = UniLexAnalyzerZh.class$("com.ibm.dltj.gloss.ZhDecompGloss")) : class$com$ibm$dltj$gloss$ZhDecompGloss);
        if (zhDecompGloss == null) {
            this.insertParsedGloss(n, n2, (GlossCollection)object);
            return;
        }
        int n3 = 0;
        this.startDecompGroup(n, n2);
        this.fork();
        this.insertDecompElement(n, n2, (GlossCollection)object);
        ++n3;
        this.addToFork();
        int n4 = n;
        int n5 = n;
        if (0 < zhDecompGloss.value[0]) {
            n4 = n;
            n5 = this.getBackwardIndex(n, n2, zhDecompGloss.value[0]);
            Object[] objectArray = this.trellis.getElement(n4, n5);
            if (objectArray.length == 0) {
                this.insertDecompElement(n4, n5, this.m_emptyGlossColl);
            } else if (objectArray.length == 1 && objectArray[0] instanceof RegExpGloss) {
                this.insertUnknownWord(n4, n5, ((RegExpGloss)objectArray[0]).getExpCls());
            } else {
                this.insertDecompElement(n4, n5, this.getFirstGlossCollection(objectArray));
            }
        }
        for (int i = 0; i < zhDecompGloss.value.length; i += 2) {
            n4 = this.getForwardIndex(n, n2, zhDecompGloss.value[i]);
            Object[] objectArray = this.trellis.getElement(n4, n5 = this.getBackwardIndex(n, n2, zhDecompGloss.value[i + 1]));
            if (objectArray.length == 0) {
                this.insertDecompElement(n4, n5, this.m_emptyGlossColl);
                continue;
            }
            if (objectArray.length == 1 && objectArray[0] instanceof RegExpGloss) {
                this.insertUnknownWord(n4, n5, ((RegExpGloss)objectArray[0]).getExpCls());
                continue;
            }
            this.insertDecompElement(n4, n5, this.getFirstGlossCollection(objectArray));
        }
        if (n5 < n2) {
            n4 = this.getForwardIndex(n, n2, zhDecompGloss.value[zhDecompGloss.value.length - 1]);
            Object[] objectArray = this.trellis.getElement(n4, n5 = n2);
            if (objectArray.length == 0) {
                this.insertDecompElement(n4, n5, this.m_emptyGlossColl);
            } else if (objectArray.length == 1 && objectArray[0] instanceof RegExpGloss) {
                this.insertUnknownWord(n4, n5, ((RegExpGloss)objectArray[0]).getExpCls());
            } else {
                this.insertDecompElement(n4, n5, this.getFirstGlossCollection(objectArray));
            }
        }
        this.closeDecompGroup(++n3);
    }

    private int getForwardIndex(int n, int n2, int n3) {
        int n4 = this.characterIterator.getIndex();
        int n5 = 0;
        this.characterIterator.setIndex(n);
        while (this.characterIterator.getIndex() < n2 && (Character.isWhitespace(this.characterIterator.current()) || ++n5 <= n3)) {
            this.characterIterator.next();
        }
        int n6 = this.characterIterator.getIndex();
        this.characterIterator.setIndex(n4);
        return n6;
    }

    private int getBackwardIndex(int n, int n2, int n3) {
        int n4 = this.characterIterator.getIndex();
        int n5 = 0;
        this.characterIterator.setIndex(n);
        while (this.characterIterator.getIndex() < n2 && (Character.isWhitespace(this.characterIterator.current()) || ++n5 < n3)) {
            this.characterIterator.next();
        }
        int n6 = this.characterIterator.getIndex() + 1;
        this.characterIterator.setIndex(n4);
        return n6;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class StandardGlossFilter
    implements GlossFilter {
        private StandardGlossFilter() {
        }

        public boolean accept(Object object) {
            return true;
        }
    }

    private static final class WeightExtractorImpl
    implements WeightExtractor {
        private WeightExtractorImpl() {
        }

        public void open() {
        }

        public void extract(int n, int n2, Object object, WeightBuffer weightBuffer) {
            int n3 = 70000;
            if (object instanceof GlossCollection) {
                GlossCollection glossCollection = (GlossCollection)object;
                GlossListElement glossListElement = glossCollection.getFirst();
                Gloss gloss = glossListElement.gloss;
                if (gloss instanceof MidGloss) {
                    MidGloss midGloss = (MidGloss)gloss;
                    ZhFreqGloss zhFreqGloss = (ZhFreqGloss)midGloss.getGloss(class$com$ibm$dltj$gloss$ZhFreqGloss == null ? (class$com$ibm$dltj$gloss$ZhFreqGloss = UniLexAnalyzerZh.class$("com.ibm.dltj.gloss.ZhFreqGloss")) : class$com$ibm$dltj$gloss$ZhFreqGloss);
                    if (zhFreqGloss != null) {
                        n3 = zhFreqGloss.getFreq();
                    } else {
                        zhFreqGloss = (ZhMorphGloss)midGloss.getGloss(class$com$ibm$dltj$gloss$ZhMorphGloss == null ? (class$com$ibm$dltj$gloss$ZhMorphGloss = UniLexAnalyzerZh.class$("com.ibm.dltj.gloss.ZhMorphGloss")) : class$com$ibm$dltj$gloss$ZhMorphGloss);
                        if (zhFreqGloss != null) {
                            n3 = zhFreqGloss.getFreq();
                        }
                    }
                }
            }
            weightBuffer.add(n, n2, object, object, n3);
        }

        public void close() {
        }
    }
}

