/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.UniLexAnalyzer;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.gloss.RegExpGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.trellis.Trellis;
import com.ibm.dltj.util.ArrayResize;
import com.ibm.dltj.util.factory.ObjectFactory;
import com.ibm.dltj.util.factory.WeakRefCachedObjectFactory;
import com.ibm.icu.lang.UCharacter;
import java.text.CharacterIterator;

abstract class UniLexAnalyzerTrellis
extends UniLexAnalyzer {
    private static final int STATE_ZERO = 0;
    private static final int STATE_AWAIT = 1;
    private static final int STATE_HAVE = 2;
    private static final int STATE_READY_FOR_TRELLIS = 3;
    private static final int STATE_END = 255;
    protected UniLexAnalyzer.DictLookupPos dictPos = new UniLexAnalyzer.DictLookupPos();
    protected Trellis trellis;
    private RegExpGloss[] regexps = new RegExpGloss[1024];
    protected final ObjectFactory gFactory = new WeakRefCachedObjectFactory(){

        protected Object create(Object object) {
            return new GlossCollection(new GlossListElement((Gloss)object, null));
        }
    };

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    protected UniLexAnalyzerTrellis(String string) throws DLTException {
        super(string);
    }

    protected UniLexAnalyzerTrellis(String string, String string2) throws DLTException {
        super(string, string2);
    }

    public void close() throws DLTException {
        super.close();
        if (this.trellis != null) {
            this.trellis.clear();
        }
        this.gFactory.clear();
    }

    protected GlossCollection dictLookup(CharacterIterator characterIterator, int n) throws DLTException {
        int n2 = characterIterator.getIndex();
        GlossCollection glossCollection = null;
        for (int i = 0; i < this.morphoSyntax.dictionaries.length; ++i) {
            glossCollection = this.morphoSyntax.dictionaries[i].lookupWord(characterIterator, n);
            characterIterator.setIndex(n2);
            if (glossCollection != null) break;
        }
        return glossCollection;
    }

    private int dictLookup(CharacterIterator characterIterator, UniLexAnalyzer.DictLookupPos dictLookupPos, MatchBuffer matchBuffer) {
        int n = characterIterator.getIndex();
        int n2 = matchBuffer.mpos;
        while (dictLookupPos.dictIdx < this.morphoSyntax.dictionaries.length) {
            int n3 = this.rawLookup(characterIterator, this.morphoSyntax.dictionaries[dictLookupPos.dictIdx].fsa, this.morphoSyntax.matches);
            characterIterator.setIndex(n);
            if (n3 > 0 && this.morphoSyntax.cmPolicy == 1) {
                ++dictLookupPos.dictIdx;
                break;
            }
            ++dictLookupPos.dictIdx;
        }
        return matchBuffer.mpos - n2;
    }

    protected abstract int rawLookup(CharacterIterator var1, MultiNet var2, MatchBuffer var3);

    private void addDictEntry(int n) {
        int n2 = this.characterIterator.getIndex();
        this.characterIterator.setIndex(n);
        this.dictPos.dictIdx = 0;
        this.morphoSyntax.matches.clear();
        int n3 = this.dictLookup(this.characterIterator, this.dictPos, this.morphoSyntax.matches);
        for (int i = 0; i < n3; ++i) {
            int n4 = this.morphoSyntax.matches.index[i];
            GlossCollection glossCollection = (GlossCollection)this.morphoSyntax.matches.gloss[i];
            this.trellis.addElement(n, n4, glossCollection);
        }
        this.characterIterator.setIndex(n2);
    }

    private void addRegExpEntry(int n, int n2, int n3) {
        RegExpGloss regExpGloss;
        int n4 = this.regexps.length;
        if (n4 <= n3) {
            int n5 = (n3 / 128 + 1) * 128;
            this.regexps = (RegExpGloss[])ArrayResize.resize(this.regexps, n5);
        }
        if ((regExpGloss = this.regexps[n3]) == null) {
            regExpGloss = this.regexps[n3] = new RegExpGloss(n3);
        }
        this.trellis.addElement(n, n2, regExpGloss);
    }

    protected ParsingStream doProcessText(CharacterIterator characterIterator) throws DLTException {
        this.breakIterator.setText(characterIterator);
        char c = '\u0000';
        int n = characterIterator.getIndex();
        char c2 = characterIterator.current();
        int n2 = UCharacter.getType((int)c2);
        int n3 = 2;
        block13: while (n3 != 255) {
            switch (n3) {
                case 1: {
                    c2 = characterIterator.current();
                    n2 = UCharacter.getType((int)c2);
                }
                case 2: {
                    int n4;
                    n3 = 1;
                    switch (n2) {
                        case 12: {
                            this.doProcessTrellis();
                            characterIterator.next();
                            continue block13;
                        }
                        case 15: 
                        case 16: {
                            this.doProcessTrellis();
                            if (c2 != '\r' && c2 != '\n') {
                                characterIterator.next();
                                continue block13;
                            }
                        }
                        case 13: {
                            this.doProcessTrellis();
                            c = c2;
                            n4 = 1;
                            while (true) {
                                c2 = characterIterator.next();
                                if (c == '\r' && c2 == '\n') continue;
                                if (n4 != 0 && c2 == c) {
                                    this.markParagraph(characterIterator.getIndex() - 1);
                                    n4 = 0;
                                    continue;
                                }
                                if (c2 != c && c2 != '\t' && c2 != ' ') break;
                            }
                            if (c2 == '\uffff') {
                                n3 = 255;
                                continue block13;
                            }
                            n3 = 1;
                            continue block13;
                        }
                        case 14: {
                            this.doProcessTrellis();
                            this.markParagraph(characterIterator.getIndex());
                            characterIterator.next();
                            continue block13;
                        }
                        case 23: {
                            this.doProcessTrellis();
                            this.insertPunctuation(characterIterator.getIndex(), characterIterator.getIndex() + 1, 65535, c2);
                            characterIterator.next();
                            continue block13;
                        }
                        case 0: {
                            if (c2 != '\uffff') break;
                            this.doProcessTrellis();
                            n3 = 255;
                            continue block13;
                        }
                    }
                    n3 = 3;
                }
                case 3: {
                    int n4;
                    n3 = 1;
                    if (this.trellis.isEmpty()) {
                        n = characterIterator.getIndex();
                        this.trellis.init(n);
                    }
                    do {
                        n4 = characterIterator.getIndex();
                        this.addDictEntry(n4);
                        int n5 = this.breakIterator.next();
                        int n6 = this.breakIterator.getRuleStatus();
                        this.addRegExpEntry(n4, n5, n6);
                        characterIterator.setIndex(n4);
                        int n7 = this.stepForward(n4, n5, n6);
                        characterIterator.setIndex(n7);
                    } while (this.trellis.isAmbiguous(characterIterator.getIndex()));
                    continue block13;
                }
            }
            n3 = 1;
            characterIterator.next();
        }
        return this.m_pLPS;
    }

    protected abstract void doProcessTrellis() throws DLTException;

    protected abstract int stepForward(int var1, int var2, int var3);

    protected GlossCollection getFirstGlossCollection(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof GlossCollection)) continue;
            return (GlossCollection)objectArray[i];
        }
        return null;
    }

    protected boolean isHyphenWord(int n, int n2) {
        int n3 = this.characterIterator.getIndex();
        for (int i = n; i < n2; ++i) {
            char c = this.characterIterator.setIndex(i);
            switch (c) {
                case '-': {
                    this.characterIterator.setIndex(n3);
                    return true;
                }
            }
        }
        this.characterIterator.setIndex(n3);
        return false;
    }

    protected int decomposeHypheWord(int n, int n2, int n3) throws DLTException {
        int n4 = this.characterIterator.getIndex();
        int n5 = this.dictPos.dictIdx;
        int n6 = n;
        block3: for (int i = n; i < n2; ++i) {
            char c = this.characterIterator.setIndex(i);
            switch (c) {
                case '-': {
                    this.characterIterator.setIndex(n6);
                    this.dictPos.dictIdx = 0;
                    GlossCollection glossCollection = this.dictLookup(this.characterIterator, i - n6);
                    if (glossCollection != null) {
                        this.insertParsedGloss(n6, i, glossCollection);
                    } else {
                        this.insertUnknownWord(n6, i, n3);
                    }
                    this.insertPunctuation(i, i + 1, 65535, c);
                    n6 = i + 1;
                    continue block3;
                }
            }
        }
        if (n6 < n2) {
            this.characterIterator.setIndex(n6);
            this.dictPos.dictIdx = 0;
            GlossCollection glossCollection = this.dictLookup(this.characterIterator, n2 - n6);
            if (glossCollection != null) {
                this.insertParsedGloss(n6, n2, glossCollection);
            } else {
                this.insertUnknownWord(n6, n2, n3);
            }
        }
        this.characterIterator.setIndex(n4);
        this.dictPos.dictIdx = n5;
        return 1;
    }
}

