/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Dictionary;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.InflectionParsingStreamJa;
import com.ibm.dltj.Messages;
import com.ibm.dltj.UniLexAnalyzerTrellis;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.fst.MultiNet;
import com.ibm.dltj.gloss.GrammarGloss;
import com.ibm.dltj.gloss.JaGramSetGloss;
import com.ibm.dltj.gloss.MidGloss;
import com.ibm.dltj.gloss.RegExpGloss;
import com.ibm.dltj.parser.ParsingStream;
import com.ibm.dltj.trellis.EdgeListElement;
import com.ibm.dltj.trellis.GlossFilter;
import com.ibm.dltj.trellis.StateBuffer;
import com.ibm.dltj.trellis.StateExtractor;
import com.ibm.dltj.trellis.StateMatrix;
import com.ibm.dltj.trellis.StateTrellis;
import com.ibm.dltj.trellis.Trellis;
import com.ibm.icu.text.Normalizer;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

final class UniLexAnalyzerJa
extends UniLexAnalyzerTrellis {
    private static final String UNKNOWN_WORD_ENTRY_KEY = "__IBM_LANGUAGEWARE_5_JAPANESE_MICHIGO__";
    private static final String LAST_EPSILON_ENTRY_KEY = "__IBM_LANGUAGEWARE_5_JAPANESE_LAST_EPSILON__";
    private static final String UNKNOWN_PROPER_NOUN_WORD_ENTRY_KEY = "__IBM_LANGUAGEWARE_5_JAPANESE_MICHI_KOYUU_MEISHI__";
    private static final String NUMERAL_WORD_ENTRY_KEY = "__IBM_LANGUAGEWARE_5_JAPANESE_NUMERAL__";
    private GlossCollection unknown_entry;
    private GlossCollection last_epsilon_entry;
    private GlossCollection unknown_proper_noun_entry;
    private GlossCollection numeral_entry;
    private static final char KATAKANA_MIDDLE_DOT = '\u30fb';
    private static final char HALFWIDTH_KATAKANA_MIDDLE_DOT = '\uff65';
    private final Trellis decomposer = new StateTrellis(new StateExtractorImpl(), new CompoundWordGlossFilter());
    private static final int GRAMMAR_MASK_DECOMP = Integer.MIN_VALUE;
    static /* synthetic */ Class class$com$ibm$dltj$gloss$JaGramSetGloss;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public UniLexAnalyzerJa(String string) throws DLTException {
        super(string);
        this.trellis = new StateTrellis(new StateExtractorImpl(), new StandardGlossFilter());
        this.decompFlags |= 1;
    }

    public UniLexAnalyzerJa(String string, String string2) throws DLTException {
        super(string, string2);
        this.trellis = new StateTrellis(new StateExtractorImpl(), new StandardGlossFilter());
        this.decompFlags |= 1;
    }

    public void open(Dictionary[] dictionaryArray, int n, int n2, int n3) throws DLTException {
        super.open(dictionaryArray, n, n2, n3);
        this.morphoSyntax.cmPolicy = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator("");
        stringCharacterIterator.setText(LAST_EPSILON_ENTRY_KEY);
        this.last_epsilon_entry = this.dictLookup(stringCharacterIterator, stringCharacterIterator.getEndIndex());
        stringCharacterIterator.setText(UNKNOWN_WORD_ENTRY_KEY);
        this.unknown_entry = this.dictLookup(stringCharacterIterator, stringCharacterIterator.getEndIndex());
        stringCharacterIterator.setText(UNKNOWN_PROPER_NOUN_WORD_ENTRY_KEY);
        this.unknown_proper_noun_entry = this.dictLookup(stringCharacterIterator, stringCharacterIterator.getEndIndex());
        stringCharacterIterator.setText(NUMERAL_WORD_ENTRY_KEY);
        this.numeral_entry = this.dictLookup(stringCharacterIterator, stringCharacterIterator.getEndIndex());
        if (this.last_epsilon_entry == null || this.unknown_entry == null || this.unknown_proper_noun_entry == null || this.numeral_entry == null) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
    }

    public void open(int n, int n2, int n3) throws DLTException {
        this.open(this.morphoSyntax.dictionaries, n, n2, n3);
    }

    public void close() throws DLTException {
        super.close();
    }

    protected int rawLookup(CharacterIterator characterIterator, MultiNet multiNet, MatchBuffer matchBuffer) {
        return multiNet.normalizingTraverse(characterIterator, matchBuffer, Normalizer.NFKD);
    }

    protected ParsingStream doProcessText(CharacterIterator characterIterator) throws DLTException {
        if (this.last_epsilon_entry == null || this.unknown_entry == null || this.unknown_proper_noun_entry == null || this.numeral_entry == null) {
            throw new DLTException(Messages.getString("invalid.dict"));
        }
        if (!this.hasDwbreakFlag() && !(this.m_pLPS instanceof InflectionParsingStreamJa)) {
            this.m_pLPS = new InflectionParsingStreamJa(this.m_pLPS);
            this.m_pLPS.reset(this);
        }
        return super.doProcessText(characterIterator);
    }

    protected void doProcessTrellis() throws DLTException {
        EdgeListElement edgeListElement;
        if (this.trellis.isEmpty()) {
            return;
        }
        int n = this.trellis.getEndIndex();
        this.trellis.addElement(n, n, this.last_epsilon_entry);
        for (EdgeListElement edgeListElement2 = edgeListElement = this.trellis.process(); edgeListElement2 != null; edgeListElement2 = edgeListElement2.getNext()) {
            int n2;
            int n3 = edgeListElement2.getStartIndex();
            int n4 = edgeListElement2.getEndIndex();
            Object object = edgeListElement2.getGloss();
            if (n3 == n4) continue;
            if (object instanceof RegExpGloss) {
                n2 = ((RegExpGloss)object).getExpCls();
                switch (n2) {
                    case 1: {
                        int n5 = this.characterIterator.getIndex();
                        this.characterIterator.setIndex(n3);
                        this.insertPunctuation(n3, n4, 65535, this.characterIterator.current());
                        this.characterIterator.setIndex(n5);
                        break;
                    }
                    case 304: {
                        if (this.hasDecompositionFlag() && this.isCompoundKatakana(n3, n4)) {
                            int n6 = 0;
                            this.startDecompGroup(n3, n4);
                            this.fork();
                            this.insertUnknownWord(n3, n4, n2);
                            ++n6;
                            this.addToFork();
                            this.decomposeKatakana(n3, n4, n2);
                            this.closeDecompGroup(++n6);
                            break;
                        }
                        this.insertUnknownWord(n3, n4, n2);
                        break;
                    }
                    case 201: 
                    case 202: 
                    case 203: {
                        if ((this.hints & 2) != 2 && this.isHyphenWord(n3, n4)) {
                            this.decomposeHypheWord(n3, n4, n2);
                            break;
                        }
                        this.insertUnknownWord(n3, n4, n2);
                        break;
                    }
                    default: {
                        this.insertUnknownWord(n3, n4, n2);
                        break;
                    }
                }
                continue;
            }
            if (object instanceof Gloss) {
                if (this.hasDecompositionFlag() && this.isCompoundWord(object)) {
                    n2 = 0;
                    this.startDecompGroup(n3, n4);
                    this.fork();
                    this.insertDecompElement(n3, n4, (GlossCollection)this.gFactory.getInstance(object));
                    ++n2;
                    this.addToFork();
                    this.decomposeWord(n3, n4, object);
                    this.closeDecompGroup(++n2);
                    continue;
                }
                this.insertParsedGloss(n3, n4, (GlossCollection)this.gFactory.getInstance(object));
                continue;
            }
            if (!(object instanceof GlossCollection)) continue;
            this.insertParsedGloss(n3, n4, (GlossCollection)object);
        }
        this.trellis.clear();
    }

    protected int stepForward(int n, int n2, int n3) {
        int n4 = n + 1;
        switch (n3) {
            case 301: {
                n4 = n + 1;
                break;
            }
            case 300: 
            case 302: 
            case 304: {
                n4 = this.hasDecompositionFlag() ? n + 1 : (n2 > n ? n2 : n + 1);
                break;
            }
            default: {
                n4 = n2 > n ? n2 : n + 1;
            }
        }
        return n4;
    }

    private boolean hasDwbreakFlag() {
        return (this.flagSpec & 1) != 0;
    }

    private boolean hasDecompositionFlag() {
        return (this.hints & 1) != 0;
    }

    private boolean isCompoundWord(Object object) {
        GrammarGloss grammarGloss;
        return object instanceof MidGloss && (grammarGloss = ((MidGloss)object).getGrammarGloss()) != null && grammarGloss.mask.length > 0 && (grammarGloss.mask[0] & Integer.MIN_VALUE) != 0;
    }

    private boolean isCompoundKatakana(int n, int n2) {
        int n3 = this.characterIterator.getIndex();
        for (int i = n; i < n2; ++i) {
            char c = this.characterIterator.setIndex(i);
            switch (c) {
                case '\u30fb': 
                case '\uff65': {
                    this.characterIterator.setIndex(n3);
                    return true;
                }
            }
        }
        this.characterIterator.setIndex(n3);
        return false;
    }

    private int decomposeWord(int n, int n2, Object object) throws DLTException {
        int n3 = this.characterIterator.getIndex();
        this.decomposer.init(n);
        this.decomposer.append(this.trellis, n, n2);
        if (this.decomposer.isEmpty()) {
            return 0;
        }
        int n4 = this.decomposer.getEndIndex();
        this.decomposer.addElement(n4, n4, this.last_epsilon_entry);
        EdgeListElement edgeListElement = this.decomposer.process();
        if (edgeListElement == null) {
            this.decomposer.clear();
            if (this.isCompoundKatakana(n, n2)) {
                this.decomposeKatakana(n, n2, 100);
                this.characterIterator.setIndex(n3);
                return 1;
            }
            this.characterIterator.setIndex(n3);
            return 0;
        }
        for (EdgeListElement edgeListElement2 = edgeListElement; edgeListElement2 != null; edgeListElement2 = edgeListElement2.getNext()) {
            int n5 = edgeListElement2.getStartIndex();
            int n6 = edgeListElement2.getEndIndex();
            Object object2 = edgeListElement2.getGloss();
            if (n5 == n6) continue;
            if (object2 instanceof RegExpGloss) {
                int n7 = ((RegExpGloss)object2).getExpCls();
                switch (n7) {
                    case 1: {
                        int n8 = this.characterIterator.getIndex();
                        this.characterIterator.setIndex(n5);
                        this.insertPunctuation(n5, n6, 65535, this.characterIterator.current());
                        this.characterIterator.setIndex(n8);
                        break;
                    }
                    case 304: {
                        this.decomposeKatakana(n5, n6, n7);
                        break;
                    }
                    default: {
                        this.insertUnknownWord(n5, n6, n7);
                        break;
                    }
                }
                continue;
            }
            if (object2 instanceof GlossCollection) {
                this.insertDecompElement(n5, n6, (GlossCollection)object2);
                continue;
            }
            this.insertDecompElement(n5, n6, (GlossCollection)this.gFactory.getInstance(object2));
        }
        this.decomposer.clear();
        this.characterIterator.setIndex(n3);
        return 1;
    }

    private int decomposeKatakana(int n, int n2, int n3) throws DLTException {
        int n4 = this.characterIterator.getIndex();
        int n5 = n;
        block3: for (int i = n; i < n2; ++i) {
            char c = this.characterIterator.setIndex(i);
            switch (c) {
                case '\u30fb': 
                case '\uff65': {
                    Object[] objectArray = this.trellis.getElement(n5, i);
                    if (objectArray.length == 0) {
                        this.insertUnknownWord(n5, i, n3);
                    } else if (objectArray.length == 1 && objectArray[0] instanceof RegExpGloss) {
                        this.insertUnknownWord(n5, i, ((RegExpGloss)objectArray[0]).getExpCls());
                    } else {
                        this.insertDecompElement(n5, i, this.getFirstGlossCollection(objectArray));
                    }
                    this.insertPunctuation(i, i + 1, 65535, c);
                    n5 = i + 1;
                    continue block3;
                }
            }
        }
        if (n5 < n2) {
            Object[] objectArray = this.trellis.getElement(n5, n2);
            if (objectArray.length == 0) {
                this.insertUnknownWord(n5, n2, n3);
            } else if (objectArray.length == 1 && objectArray[0] instanceof RegExpGloss) {
                this.insertUnknownWord(n5, n2, ((RegExpGloss)objectArray[0]).getExpCls());
            } else {
                this.insertDecompElement(n5, n2, this.getFirstGlossCollection(objectArray));
            }
        }
        this.characterIterator.setIndex(n4);
        return 1;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static final class CompoundWordGlossFilter
    implements GlossFilter {
        private CompoundWordGlossFilter() {
        }

        public boolean accept(Object object) {
            GrammarGloss grammarGloss;
            return !(object instanceof MidGloss) || (grammarGloss = ((MidGloss)object).getGrammarGloss()) == null || grammarGloss.mask.length <= 0 || (grammarGloss.mask[0] & Integer.MIN_VALUE) == 0;
        }
    }

    private static final class StandardGlossFilter
    implements GlossFilter {
        private StandardGlossFilter() {
        }

        public boolean accept(Object object) {
            return true;
        }
    }

    private final class StateExtractorImpl
    implements StateExtractor {
        private StateMatrix[] numeral;
        private StateMatrix[] unknown;

        public void open() {
            MidGloss midGloss;
            JaGramSetGloss jaGramSetGloss;
            Gloss gloss;
            int n = 0;
            GlossListElement glossListElement = ((UniLexAnalyzerJa)UniLexAnalyzerJa.this).numeral_entry.first;
            while (glossListElement != null) {
                ++n;
                glossListElement = glossListElement.next;
            }
            this.numeral = new StateMatrix[n];
            n = 0;
            glossListElement = ((UniLexAnalyzerJa)UniLexAnalyzerJa.this).numeral_entry.first;
            while (glossListElement != null) {
                gloss = glossListElement.gloss;
                jaGramSetGloss = null;
                if (gloss instanceof MidGloss) {
                    midGloss = (MidGloss)gloss;
                    jaGramSetGloss = (JaGramSetGloss)midGloss.getGloss(class$com$ibm$dltj$gloss$JaGramSetGloss == null ? UniLexAnalyzerJa.class$("com.ibm.dltj.gloss.JaGramSetGloss") : class$com$ibm$dltj$gloss$JaGramSetGloss);
                    this.numeral[n++] = jaGramSetGloss.getData();
                }
                glossListElement = glossListElement.next;
            }
            n = 0;
            glossListElement = ((UniLexAnalyzerJa)UniLexAnalyzerJa.this).unknown_entry.first;
            while (glossListElement != null) {
                ++n;
                glossListElement = glossListElement.next;
            }
            this.unknown = new StateMatrix[n];
            n = 0;
            glossListElement = ((UniLexAnalyzerJa)UniLexAnalyzerJa.this).unknown_entry.first;
            while (glossListElement != null) {
                gloss = glossListElement.gloss;
                jaGramSetGloss = null;
                if (gloss instanceof MidGloss) {
                    midGloss = (MidGloss)gloss;
                    jaGramSetGloss = (JaGramSetGloss)midGloss.getGloss(class$com$ibm$dltj$gloss$JaGramSetGloss == null ? UniLexAnalyzerJa.class$("com.ibm.dltj.gloss.JaGramSetGloss") : class$com$ibm$dltj$gloss$JaGramSetGloss);
                    this.unknown[n++] = jaGramSetGloss.getData();
                }
                glossListElement = glossListElement.next;
            }
        }

        public void close() {
            this.numeral = null;
            this.unknown = null;
        }

        public void extract(int n, int n2, Object object, StateBuffer stateBuffer) {
            if (object instanceof RegExpGloss) {
                StateMatrix[] stateMatrixArray;
                int n3 = ((RegExpGloss)object).getExpCls();
                switch (n3) {
                    case 103: 
                    case 105: 
                    case 106: 
                    case 108: 
                    case 109: 
                    case 206: {
                        stateMatrixArray = this.numeral;
                        break;
                    }
                    default: {
                        stateMatrixArray = this.unknown;
                    }
                }
                for (int i = 0; i < stateMatrixArray.length; ++i) {
                    stateBuffer.add(n, n2, object, object, stateMatrixArray[i]);
                }
                return;
            }
            if (object instanceof GlossCollection) {
                GlossCollection glossCollection = (GlossCollection)object;
                GlossListElement glossListElement = glossCollection.first;
                while (glossListElement != null) {
                    Gloss gloss = glossListElement.gloss;
                    JaGramSetGloss jaGramSetGloss = null;
                    if (gloss instanceof MidGloss) {
                        jaGramSetGloss = (JaGramSetGloss)((MidGloss)gloss).getGloss(class$com$ibm$dltj$gloss$JaGramSetGloss == null ? UniLexAnalyzerJa.class$("com.ibm.dltj.gloss.JaGramSetGloss") : class$com$ibm$dltj$gloss$JaGramSetGloss);
                    }
                    if (jaGramSetGloss == null) {
                        for (int i = 0; i < this.unknown.length; ++i) {
                            stateBuffer.add(n, n2, object, object, this.unknown[i]);
                        }
                        return;
                    }
                    stateBuffer.add(n, n2, object, gloss, jaGramSetGloss.getData());
                    glossListElement = glossListElement.next;
                }
                return;
            }
        }
    }
}

