/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dltj;

import com.ibm.dltj.DLTException;
import com.ibm.dltj.Gloss;
import com.ibm.dltj.GlossCollection;
import com.ibm.dltj.GlossListElement;
import com.ibm.dltj.UniLexAnalyzerEu;
import com.ibm.dltj.UniMorphoSyntaxFi;
import com.ibm.dltj.fst.MatchBuffer;
import com.ibm.dltj.gloss.BasicCutPasteGloss;
import com.ibm.dltj.gloss.CutPasteGloss;
import com.ibm.dltj.gloss.FeatureSetGloss;
import com.ibm.dltj.gloss.LemmaGenerator;
import com.ibm.dltj.gloss.MidGloss;

class UniLexAnalyzerFi
extends UniLexAnalyzerEu {
    private static final int INVALID_MATCH = 0;
    private static final int STANDALONE_MATCH = 1;
    private static final int COMPOUND_MATCH = 2;

    static String getCopyright() {
        return "\n\n(C) Copyright IBM Corp. 2003, 2006.\n\n";
    }

    public UniLexAnalyzerFi(String string) throws DLTException {
        super(string);
    }

    protected void insertGlosses(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.morphoSyntax.matches.getMaxIndex();
        int n7 = this.morphoSyntax.matches.getNumMatches();
        int[] nArray = new int[n7];
        int n8 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n5 = 0; n5 < n7; ++n5) {
            n4 = this.morphoSyntax.matches.getMatchStart(n5);
            if (n4 == (n3 = this.morphoSyntax.matches.getMatchEnd(n5)) || this.morphoSyntax.matches.index[n3 - 1] < n6 || !UniMorphoSyntaxFi.isWordEnd((GlossCollection)this.morphoSyntax.matches.gloss[n3 - 1])) continue;
            nArray[n5] = 1;
            ++n8;
            for (n2 = n4; n2 < n3 - 2; ++n2) {
                if (this.morphoSyntax.matches.index[n2] == n6 || !UniMorphoSyntaxFi.isWordBoundary((GlossCollection)this.morphoSyntax.matches.gloss[n2])) continue;
                nArray[n5] = 2;
                bl = true;
            }
        }
        if (n8 > 1 || bl) {
            this.startDecompGroup(n, n6);
            bl2 = true;
        }
        n5 = 0;
        for (n4 = 0; n4 < n7; ++n4) {
            if (nArray[n4] == 0) continue;
            n3 = this.morphoSyntax.matches.getMatchStart(n4);
            n2 = this.morphoSyntax.matches.getMatchEnd(n4);
            if (bl2) {
                if (n5 == 0) {
                    this.fork();
                } else {
                    this.addToFork();
                }
            }
            if (nArray[n4] == 1) {
                this.standaloneWord(this.morphoSyntax.matches, n, n3, n2);
            } else {
                if (nArray[n4] != 2) continue;
                this.decompoundedWords(this.morphoSyntax.matches, n, n3, n2);
            }
            ++n5;
        }
        if (bl2) {
            this.closeDecompGroup(n5);
        }
        if (n5 == 0) {
            this.unknownWord(n);
        }
    }

    protected int decompose(int n, int n2) {
        return 0;
    }

    protected int decomposeHypheWord(int n, int n2, int n3) {
        int n4;
        int n5 = this.characterIterator.getIndex();
        int n6 = this.dictPos.dictIdx;
        int n7 = this.startIndex;
        block3: for (n4 = this.startIndex; n4 < n3; ++n4) {
            char c = this.characterIterator.setIndex(n4);
            switch (c) {
                case '-': {
                    this.characterIterator.setIndex(n7);
                    this.dictPos.dictIdx = 0;
                    this.morphoSyntax.dictLookup(this.characterIterator, this.dictPos);
                    int n8 = this.morphoSyntax.matches.getMaxIndex();
                    if (n8 == n4) {
                        this.characterIterator.setIndex(n8);
                        this.insertGlosses(n7);
                    } else {
                        this.insertUnknownWord(n7, n4, n);
                    }
                    this.insertPunctuation(n4, n4 + 1, 65535, c);
                    n7 = n4 + 1;
                    this.morphoSyntax.matches.clear();
                    continue block3;
                }
            }
        }
        if (n7 < n3) {
            this.characterIterator.setIndex(n7);
            this.dictPos.dictIdx = 0;
            this.morphoSyntax.dictLookup(this.characterIterator, this.dictPos);
            n4 = this.morphoSyntax.matches.getMaxIndex();
            if (n4 == n3) {
                this.characterIterator.setIndex(n4);
                this.insertGlosses(n7);
            } else {
                this.insertUnknownWord(n7, n3, n);
            }
        }
        this.characterIterator.setIndex(n5);
        this.dictPos.dictIdx = n6;
        this.morphoSyntax.matches.clear();
        return 1;
    }

    public void decompoundedWords(MatchBuffer matchBuffer, int n, int n2, int n3) {
        LemmaGenerator lemmaGenerator = null;
        FeatureSetGloss featureSetGloss = null;
        int n4 = n;
        for (int i = n2; i < n3; ++i) {
            if (!UniMorphoSyntaxFi.isWordBoundary((GlossCollection)this.morphoSyntax.matches.gloss[i]) && (!UniMorphoSyntaxFi.isWordEnd((GlossCollection)this.morphoSyntax.matches.gloss[i]) || i != n3 - 1)) continue;
            int n5 = matchBuffer.index[i];
            block3: for (int j = i; j >= n2 && n4 != n5; --j) {
                GlossCollection glossCollection = (GlossCollection)matchBuffer.gloss[j];
                GlossListElement glossListElement = glossCollection.getFirst();
                while (glossListElement != null) {
                    Gloss gloss = glossListElement.gloss;
                    if (gloss instanceof MidGloss) {
                        MidGloss midGloss = (MidGloss)gloss;
                        featureSetGloss = midGloss.getFeatureGloss();
                        lemmaGenerator = midGloss.getLemmaGloss();
                        if (featureSetGloss != null && lemmaGenerator != null && featureSetGloss.getPOS() != 0 && lemmaGenerator instanceof BasicCutPasteGloss) {
                            BasicCutPasteGloss basicCutPasteGloss = (BasicCutPasteGloss)lemmaGenerator;
                            if (basicCutPasteGloss.getMinSourceLength() > n5 - n4) {
                                lemmaGenerator = null;
                            }
                            if (lemmaGenerator != null) {
                                lemmaGenerator = new CutPasteGloss(basicCutPasteGloss.getValue(), n5 - matchBuffer.index[j] + basicCutPasteGloss.getCut(), basicCutPasteGloss.getConv(), basicCutPasteGloss.getOptions());
                            }
                            GlossCollection glossCollection2 = new GlossCollection();
                            try {
                                Gloss[] glossArray;
                                if (lemmaGenerator == null) {
                                    Gloss[] glossArray2 = new Gloss[1];
                                    glossArray = glossArray2;
                                    glossArray2[0] = featureSetGloss;
                                } else {
                                    Gloss[] glossArray3 = new Gloss[2];
                                    glossArray3[0] = (Gloss)((Object)lemmaGenerator);
                                    glossArray = glossArray3;
                                    glossArray3[1] = featureSetGloss;
                                }
                                MidGloss midGloss2 = new MidGloss(glossArray);
                                glossCollection2.add(midGloss2);
                            }
                            catch (DLTException dLTException) {
                                // empty catch block
                            }
                            featureSetGloss = null;
                            lemmaGenerator = null;
                            if (n4 > n5) {
                                throw new IllegalArgumentException();
                            }
                            this.insertParsedGloss(n4, n5, glossCollection2);
                            n4 = n5;
                            continue block3;
                        }
                    }
                    glossListElement = glossListElement.next;
                }
            }
        }
    }

    public void standaloneWord(MatchBuffer matchBuffer, int n, int n2, int n3) {
        LemmaGenerator lemmaGenerator = null;
        FeatureSetGloss featureSetGloss = null;
        int n4 = matchBuffer.index[n3 - 1];
        for (int i = n3 - 1; i >= n2; --i) {
            GlossCollection glossCollection = (GlossCollection)matchBuffer.gloss[i];
            GlossListElement glossListElement = glossCollection.getFirst();
            while (glossListElement != null) {
                Gloss gloss = glossListElement.gloss;
                if (gloss instanceof MidGloss) {
                    MidGloss midGloss = (MidGloss)gloss;
                    featureSetGloss = midGloss.getFeatureGloss();
                    lemmaGenerator = midGloss.getLemmaGloss();
                    if (featureSetGloss != null && lemmaGenerator != null && featureSetGloss.getPOS() != 0 && lemmaGenerator instanceof BasicCutPasteGloss) {
                        BasicCutPasteGloss basicCutPasteGloss = (BasicCutPasteGloss)lemmaGenerator;
                        if (basicCutPasteGloss.getMinSourceLength() > n4 - n) {
                            lemmaGenerator = null;
                        }
                        if (lemmaGenerator != null) {
                            lemmaGenerator = new CutPasteGloss(basicCutPasteGloss.getValue(), n4 - matchBuffer.index[i] + basicCutPasteGloss.getCut(), basicCutPasteGloss.getConv(), basicCutPasteGloss.getOptions());
                        }
                        GlossCollection glossCollection2 = new GlossCollection();
                        try {
                            Gloss[] glossArray;
                            if (lemmaGenerator == null) {
                                Gloss[] glossArray2 = new Gloss[1];
                                glossArray = glossArray2;
                                glossArray2[0] = featureSetGloss;
                            } else {
                                Gloss[] glossArray3 = new Gloss[2];
                                glossArray3[0] = (Gloss)((Object)lemmaGenerator);
                                glossArray = glossArray3;
                                glossArray3[1] = featureSetGloss;
                            }
                            MidGloss midGloss2 = new MidGloss(glossArray);
                            glossCollection2.add(midGloss2);
                        }
                        catch (DLTException dLTException) {
                            // empty catch block
                        }
                        if (n > n4) {
                            throw new IllegalArgumentException();
                        }
                        this.insertParsedGloss(n, n4, glossCollection2);
                        return;
                    }
                }
                glossListElement = glossListElement.next;
            }
        }
    }

    private void unknownWord(int n) {
        int n2 = this.characterIterator.getIndex();
        this.characterIterator.setIndex(n);
        this.breakIterator.next();
        this.insertUnknown(n, n2, this.breakIterator.getRuleStatus());
        this.characterIterator.setIndex(n2);
    }
}

